/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.enforcement_points.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.enforcement_points;

public interface ServiceDefinitions extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.enforcement_points.ServiceDefinitionsTypes {

    /**
     * Create a Service Definition on given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinition (required)
     * @return com.vmware.nsx_policy.model.ServiceDefinition
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServiceDefinition create(java.lang.String enforcementPointId, com.vmware.nsx_policy.model.ServiceDefinition serviceDefinition);

    /**
     * Create a Service Definition on given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinition (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ServiceDefinition
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServiceDefinition create(java.lang.String enforcementPointId, com.vmware.nsx_policy.model.ServiceDefinition serviceDefinition, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a Service Definition on given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceDefinition
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinition (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String enforcementPointId, com.vmware.nsx_policy.model.ServiceDefinition serviceDefinition, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceDefinition> asyncCallback);

    /**
     * Create a Service Definition on given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceDefinition
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinition (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String enforcementPointId, com.vmware.nsx_policy.model.ServiceDefinition serviceDefinition, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceDefinition> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete an existing Service Definition on the given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId);

    /**
     * Delete an existing Service Definition on the given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete an existing Service Definition on the given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete an existing Service Definition on the given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read Service Definition with given service-definition-id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @return com.vmware.nsx_policy.model.ServiceDefinition
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServiceDefinition get(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId);

    /**
     * Read Service Definition with given service-definition-id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ServiceDefinition
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServiceDefinition get(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read Service Definition with given service-definition-id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceDefinition
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceDefinition> asyncCallback);

    /**
     * Read Service Definition with given service-definition-id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceDefinition
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceDefinition> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all Service Definitions registered on given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @return com.vmware.nsx_policy.model.ServiceInsertionServiceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServiceInsertionServiceListResult list(java.lang.String enforcementPointId);

    /**
     * List all Service Definitions registered on given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ServiceInsertionServiceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServiceInsertionServiceListResult list(java.lang.String enforcementPointId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all Service Definitions registered on given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceInsertionServiceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String enforcementPointId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceInsertionServiceListResult> asyncCallback);

    /**
     * List all Service Definitions registered on given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceInsertionServiceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String enforcementPointId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceInsertionServiceListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update an existing Service Definition on the given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param serviceDefinition (required)
     * @return com.vmware.nsx_policy.model.ServiceDefinition
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServiceDefinition update(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.nsx_policy.model.ServiceDefinition serviceDefinition);

    /**
     * Update an existing Service Definition on the given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param serviceDefinition (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ServiceDefinition
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServiceDefinition update(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.nsx_policy.model.ServiceDefinition serviceDefinition, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update an existing Service Definition on the given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceDefinition
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param serviceDefinition (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.nsx_policy.model.ServiceDefinition serviceDefinition, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceDefinition> asyncCallback);

    /**
     * Update an existing Service Definition on the given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceDefinition
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param enforcementPointId Enforcement point id (required)
     * @param serviceDefinitionId Id of service definition (required)
     * @param serviceDefinition (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String enforcementPointId, java.lang.String serviceDefinitionId, com.vmware.nsx_policy.model.ServiceDefinition serviceDefinition, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceDefinition> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
