/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.global_infra.tier_1s.dns_forwarder.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.global_infra.tier_1s.dns_forwarder;

public interface Nslookup extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.global_infra.tier_1s.dns_forwarder.NslookupTypes {

    /**
     * Query the nameserver for an ip-address or a FQDN of the given an address
     * optionally using an specified DNS server. If the address is a fqdn, nslookup
     * will resolve ip-address with it. If the address is an ip-address, do a reverse
     * lookup and answer fqdn(s). If enforcement point is specified, then DNS forwarder
     * nslookup answer will get fetched from specified enforcement point. Otherwise
     * from all enforcement points.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param address IP address or FQDN for nslookup (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @return com.vmware.nsx_policy.model.AggregatePolicyDnsAnswer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.AggregatePolicyDnsAnswer get(java.lang.String tier1Id, java.lang.String address, java.lang.String enforcementPointPath);

    /**
     * Query the nameserver for an ip-address or a FQDN of the given an address
     * optionally using an specified DNS server. If the address is a fqdn, nslookup
     * will resolve ip-address with it. If the address is an ip-address, do a reverse
     * lookup and answer fqdn(s). If enforcement point is specified, then DNS forwarder
     * nslookup answer will get fetched from specified enforcement point. Otherwise
     * from all enforcement points.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param address IP address or FQDN for nslookup (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.AggregatePolicyDnsAnswer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.AggregatePolicyDnsAnswer get(java.lang.String tier1Id, java.lang.String address, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Query the nameserver for an ip-address or a FQDN of the given an address
     * optionally using an specified DNS server. If the address is a fqdn, nslookup
     * will resolve ip-address with it. If the address is an ip-address, do a reverse
     * lookup and answer fqdn(s). If enforcement point is specified, then DNS forwarder
     * nslookup answer will get fetched from specified enforcement point. Otherwise
     * from all enforcement points.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.AggregatePolicyDnsAnswer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param address IP address or FQDN for nslookup (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String address, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.AggregatePolicyDnsAnswer> asyncCallback);

    /**
     * Query the nameserver for an ip-address or a FQDN of the given an address
     * optionally using an specified DNS server. If the address is a fqdn, nslookup
     * will resolve ip-address with it. If the address is an ip-address, do a reverse
     * lookup and answer fqdn(s). If enforcement point is specified, then DNS forwarder
     * nslookup answer will get fetched from specified enforcement point. Otherwise
     * from all enforcement points.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.AggregatePolicyDnsAnswer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param address IP address or FQDN for nslookup (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String address, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.AggregatePolicyDnsAnswer> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
