/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra;

public interface LbNodeUsage extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.LbNodeUsageTypes {

    /**
     * API is used to retrieve node usage for load balancer which contains basic
     * information, LB entity usages and capacities for the given node. Currently only
     * edge node is supported. The parameter ?node_path=<node-path> is required. For
     * example, ?node_path=
     * /infra/sites/default/enforcement-points/default/edge-clusters/
     * 85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes/
     * 86e077c0-449f-11e9-87c8-02004eb37029. <br/> <br/> NSX-T Load Balancer is
     * deprecated. <br/> Please take advantage of NSX Advanced Load Balancer. <br/>
     * Refer to Policy > Networking > Network Services > Advanced Load Balancing
     * section of the API guide.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodePath The node path for load balancer node usage (required)
     * @return com.vmware.nsx_policy.model.LBNodeUsage
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.LBNodeUsage}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String nodePath);

    /**
     * API is used to retrieve node usage for load balancer which contains basic
     * information, LB entity usages and capacities for the given node. Currently only
     * edge node is supported. The parameter ?node_path=<node-path> is required. For
     * example, ?node_path=
     * /infra/sites/default/enforcement-points/default/edge-clusters/
     * 85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes/
     * 86e077c0-449f-11e9-87c8-02004eb37029. <br/> <br/> NSX-T Load Balancer is
     * deprecated. <br/> Please take advantage of NSX Advanced Load Balancer. <br/>
     * Refer to Policy > Networking > Network Services > Advanced Load Balancing
     * section of the API guide.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodePath The node path for load balancer node usage (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.LBNodeUsage
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.LBNodeUsage}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String nodePath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API is used to retrieve node usage for load balancer which contains basic
     * information, LB entity usages and capacities for the given node. Currently only
     * edge node is supported. The parameter ?node_path=<node-path> is required. For
     * example, ?node_path=
     * /infra/sites/default/enforcement-points/default/edge-clusters/
     * 85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes/
     * 86e077c0-449f-11e9-87c8-02004eb37029. <br/> <br/> NSX-T Load Balancer is
     * deprecated. <br/> Please take advantage of NSX Advanced Load Balancer. <br/>
     * Refer to Policy > Networking > Network Services > Advanced Load Balancing
     * section of the API guide.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.LBNodeUsage
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.LBNodeUsage}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodePath The node path for load balancer node usage (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String nodePath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * API is used to retrieve node usage for load balancer which contains basic
     * information, LB entity usages and capacities for the given node. Currently only
     * edge node is supported. The parameter ?node_path=<node-path> is required. For
     * example, ?node_path=
     * /infra/sites/default/enforcement-points/default/edge-clusters/
     * 85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes/
     * 86e077c0-449f-11e9-87c8-02004eb37029. <br/> <br/> NSX-T Load Balancer is
     * deprecated. <br/> Please take advantage of NSX Advanced Load Balancer. <br/>
     * Refer to Policy > Networking > Network Services > Advanced Load Balancing
     * section of the API guide.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.LBNodeUsage
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.LBNodeUsage}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodePath The node path for load balancer node usage (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String nodePath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
