/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.domains.intrusion_service_policies.rules.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.domains.intrusion_service_policies.rules;

public interface Statistics extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.domains.intrusion_service_policies.rules.StatisticsTypes {

    /**
     * Get statistics of a IDS-IPS rule. - no enforcement point path specified: Stats
     * will be evaluated on each enforcement point. - {enforcement_point_path}: Stats
     * are evaluated only on the given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain id (required)
     * @param idsPolicyId IDS policy id (required)
     * @param ruleId Rule id (required)
     * @param containerClusterPath String Path of the Container Cluster entity (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @return com.vmware.nsx_policy.model.IdsRuleStatisticsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.IdsRuleStatisticsListResult list(java.lang.String domainId, java.lang.String idsPolicyId, java.lang.String ruleId, java.lang.String containerClusterPath, java.lang.String enforcementPointPath);

    /**
     * Get statistics of a IDS-IPS rule. - no enforcement point path specified: Stats
     * will be evaluated on each enforcement point. - {enforcement_point_path}: Stats
     * are evaluated only on the given enforcement point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain id (required)
     * @param idsPolicyId IDS policy id (required)
     * @param ruleId Rule id (required)
     * @param containerClusterPath String Path of the Container Cluster entity (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IdsRuleStatisticsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.IdsRuleStatisticsListResult list(java.lang.String domainId, java.lang.String idsPolicyId, java.lang.String ruleId, java.lang.String containerClusterPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get statistics of a IDS-IPS rule. - no enforcement point path specified: Stats
     * will be evaluated on each enforcement point. - {enforcement_point_path}: Stats
     * are evaluated only on the given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IdsRuleStatisticsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Domain id (required)
     * @param idsPolicyId IDS policy id (required)
     * @param ruleId Rule id (required)
     * @param containerClusterPath String Path of the Container Cluster entity (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String domainId, java.lang.String idsPolicyId, java.lang.String ruleId, java.lang.String containerClusterPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IdsRuleStatisticsListResult> asyncCallback);

    /**
     * Get statistics of a IDS-IPS rule. - no enforcement point path specified: Stats
     * will be evaluated on each enforcement point. - {enforcement_point_path}: Stats
     * are evaluated only on the given enforcement point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IdsRuleStatisticsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Domain id (required)
     * @param idsPolicyId IDS policy id (required)
     * @param ruleId Rule id (required)
     * @param containerClusterPath String Path of the Container Cluster entity (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String domainId, java.lang.String idsPolicyId, java.lang.String ruleId, java.lang.String containerClusterPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IdsRuleStatisticsListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
