
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx_policy.infra.lb_services;

/**
 * {@link LbServicesFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx_policy.infra.lb_services package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class LbServicesFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private LbServicesFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link LbServicesFactory} factory instance
     */
    public static LbServicesFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        LbServicesFactory instance = new LbServicesFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.lb_services.DetailedStatus}
     */
    public com.vmware.nsx_policy.infra.lb_services.DetailedStatus detailedStatusService() {
        return this.stubFactory.createStub(DetailedStatus.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.lb_services.ServiceUsage}
     */
    public com.vmware.nsx_policy.infra.lb_services.ServiceUsage serviceUsageService() {
        return this.stubFactory.createStub(ServiceUsage.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.lb_services.Statistics}
     */
    public com.vmware.nsx_policy.infra.lb_services.Statistics statisticsService() {
        return this.stubFactory.createStub(Statistics.class, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.lb_services.lb_pools.LbPoolsFactory lbPools() {
        return com.vmware.nsx_policy.infra.lb_services.lb_pools.LbPoolsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.lb_services.lb_virtual_servers.LbVirtualServersFactory lbVirtualServers() {
        return com.vmware.nsx_policy.infra.lb_services.lb_virtual_servers.LbVirtualServersFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
