/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_0s.locale_services.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_0s.locale_services;

public interface L3vpns extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_0s.locale_services.L3vpnsTypes {

    /**
     * Delete the L3Vpn with the given id. This API is deprecated. Please use the
     * following APIs instead: - DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id> to delete the associated IPSecVpnSession. -
     * DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to delete the associated
     * IPSecVpnLocalEndpoint. - DELETE
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id> to delete the associated
     * IPSecVpnTunnelProfile. - DELETE /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>
     * to delete the associated IPSecVpnIkeProfile. - DELETE
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to delete the associated
     * IPSecVpnDpdProfile. If used, this deprecated API will result in the following
     * objects being internally deleted: - IPSecVpnSession:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id> when not used by
     * other IPSecVpnSessions. - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId);

    /**
     * Delete the L3Vpn with the given id. This API is deprecated. Please use the
     * following APIs instead: - DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id> to delete the associated IPSecVpnSession. -
     * DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to delete the associated
     * IPSecVpnLocalEndpoint. - DELETE
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id> to delete the associated
     * IPSecVpnTunnelProfile. - DELETE /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>
     * to delete the associated IPSecVpnIkeProfile. - DELETE
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to delete the associated
     * IPSecVpnDpdProfile. If used, this deprecated API will result in the following
     * objects being internally deleted: - IPSecVpnSession:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id> when not used by
     * other IPSecVpnSessions. - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete the L3Vpn with the given id. This API is deprecated. Please use the
     * following APIs instead: - DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id> to delete the associated IPSecVpnSession. -
     * DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to delete the associated
     * IPSecVpnLocalEndpoint. - DELETE
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id> to delete the associated
     * IPSecVpnTunnelProfile. - DELETE /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>
     * to delete the associated IPSecVpnIkeProfile. - DELETE
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to delete the associated
     * IPSecVpnDpdProfile. If used, this deprecated API will result in the following
     * objects being internally deleted: - IPSecVpnSession:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id> when not used by
     * other IPSecVpnSessions. - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete the L3Vpn with the given id. This API is deprecated. Please use the
     * following APIs instead: - DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id> to delete the associated IPSecVpnSession. -
     * DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to delete the associated
     * IPSecVpnLocalEndpoint. - DELETE
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id> to delete the associated
     * IPSecVpnTunnelProfile. - DELETE /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>
     * to delete the associated IPSecVpnIkeProfile. - DELETE
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to delete the associated
     * IPSecVpnDpdProfile. If used, this deprecated API will result in the following
     * objects being internally deleted: - IPSecVpnSession:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id> when not used by
     * other IPSecVpnSessions. - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read the L3Vpn with the given id. No sensitive data is returned as part of the
     * response. This API is deprecated. Please use the following APIs instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id> to get the associated IPSecVpnSession. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to get the associated
     * IPSecVpnLocalEndpoint. - GET /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>
     * to get the associated IPSecVpnTunnelProfile. - GET
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id> to get the associated
     * IPSecVpnIkeProfile. - GET /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to get
     * the associated IPSecVpnDpdProfile. If used, this deprecated API will not return
     * L3Vpn with <l3vpn-id> id unless the associated IPSecVpnSession with
     * L3VPN_<l3vpn-id> id exists. For example, if the IPSecVpnSession gets deleted
     * using DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>, the deprecated API will throw an
     * ObjectNotFoundException.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @return com.vmware.nsx_policy.model.L3Vpn
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L3Vpn get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId);

    /**
     * Read the L3Vpn with the given id. No sensitive data is returned as part of the
     * response. This API is deprecated. Please use the following APIs instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id> to get the associated IPSecVpnSession. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to get the associated
     * IPSecVpnLocalEndpoint. - GET /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>
     * to get the associated IPSecVpnTunnelProfile. - GET
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id> to get the associated
     * IPSecVpnIkeProfile. - GET /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to get
     * the associated IPSecVpnDpdProfile. If used, this deprecated API will not return
     * L3Vpn with <l3vpn-id> id unless the associated IPSecVpnSession with
     * L3VPN_<l3vpn-id> id exists. For example, if the IPSecVpnSession gets deleted
     * using DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>, the deprecated API will throw an
     * ObjectNotFoundException.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.L3Vpn
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L3Vpn get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read the L3Vpn with the given id. No sensitive data is returned as part of the
     * response. This API is deprecated. Please use the following APIs instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id> to get the associated IPSecVpnSession. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to get the associated
     * IPSecVpnLocalEndpoint. - GET /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>
     * to get the associated IPSecVpnTunnelProfile. - GET
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id> to get the associated
     * IPSecVpnIkeProfile. - GET /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to get
     * the associated IPSecVpnDpdProfile. If used, this deprecated API will not return
     * L3Vpn with <l3vpn-id> id unless the associated IPSecVpnSession with
     * L3VPN_<l3vpn-id> id exists. For example, if the IPSecVpnSession gets deleted
     * using DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>, the deprecated API will throw an
     * ObjectNotFoundException.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L3Vpn
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L3Vpn> asyncCallback);

    /**
     * Read the L3Vpn with the given id. No sensitive data is returned as part of the
     * response. This API is deprecated. Please use the following APIs instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id> to get the associated IPSecVpnSession. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to get the associated
     * IPSecVpnLocalEndpoint. - GET /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>
     * to get the associated IPSecVpnTunnelProfile. - GET
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id> to get the associated
     * IPSecVpnIkeProfile. - GET /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to get
     * the associated IPSecVpnDpdProfile. If used, this deprecated API will not return
     * L3Vpn with <l3vpn-id> id unless the associated IPSecVpnSession with
     * L3VPN_<l3vpn-id> id exists. For example, if the IPSecVpnSession gets deleted
     * using DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>, the deprecated API will throw an
     * ObjectNotFoundException.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L3Vpn
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L3Vpn> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Paginated list of L3Vpns. This API is deprecated. Please use the following APIs
     * instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions to list all IPSecVpnSessions. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints to list all IPSecVpnLocalEndpoints. - GET
     * /infra/ipsec-vpn-tunnel-profiles to list all IPSecVpnTunnelProfiles. - GET
     * /infra/ipsec-vpn-ike-profiles to list all IPSecVpnIkeProfiles. - GET
     * /infra/ipsec-vpn-dpd-profiles to list all IPSecVpnDpdProfiles. If used, this
     * deprecated API will only return L3Vpns that were created through the deprecated
     * PATCH and PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/l3vpns/<l3vpn-id>
     * APIs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param l3vpnSession Resource type of L3Vpn Session (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.L3VpnListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L3VpnListResult list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.String l3vpnSession, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Paginated list of L3Vpns. This API is deprecated. Please use the following APIs
     * instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions to list all IPSecVpnSessions. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints to list all IPSecVpnLocalEndpoints. - GET
     * /infra/ipsec-vpn-tunnel-profiles to list all IPSecVpnTunnelProfiles. - GET
     * /infra/ipsec-vpn-ike-profiles to list all IPSecVpnIkeProfiles. - GET
     * /infra/ipsec-vpn-dpd-profiles to list all IPSecVpnDpdProfiles. If used, this
     * deprecated API will only return L3Vpns that were created through the deprecated
     * PATCH and PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/l3vpns/<l3vpn-id>
     * APIs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param l3vpnSession Resource type of L3Vpn Session (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.L3VpnListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L3VpnListResult list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.String l3vpnSession, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Paginated list of L3Vpns. This API is deprecated. Please use the following APIs
     * instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions to list all IPSecVpnSessions. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints to list all IPSecVpnLocalEndpoints. - GET
     * /infra/ipsec-vpn-tunnel-profiles to list all IPSecVpnTunnelProfiles. - GET
     * /infra/ipsec-vpn-ike-profiles to list all IPSecVpnIkeProfiles. - GET
     * /infra/ipsec-vpn-dpd-profiles to list all IPSecVpnDpdProfiles. If used, this
     * deprecated API will only return L3Vpns that were created through the deprecated
     * PATCH and PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/l3vpns/<l3vpn-id>
     * APIs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L3VpnListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param l3vpnSession Resource type of L3Vpn Session (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.String l3vpnSession, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L3VpnListResult> asyncCallback);

    /**
     * Paginated list of L3Vpns. This API is deprecated. Please use the following APIs
     * instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions to list all IPSecVpnSessions. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints to list all IPSecVpnLocalEndpoints. - GET
     * /infra/ipsec-vpn-tunnel-profiles to list all IPSecVpnTunnelProfiles. - GET
     * /infra/ipsec-vpn-ike-profiles to list all IPSecVpnIkeProfiles. - GET
     * /infra/ipsec-vpn-dpd-profiles to list all IPSecVpnDpdProfiles. If used, this
     * deprecated API will only return L3Vpns that were created through the deprecated
     * PATCH and PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/l3vpns/<l3vpn-id>
     * APIs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L3VpnListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param l3vpnSession Resource type of L3Vpn Session (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.String l3vpnSession, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L3VpnListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create the new L3Vpn if it does not exist. If the L3Vpn already exists, merge
     * with the the existing one. This is a patch. - If the passed L3Vpn is a
     * policy-based one and has new L3VpnRules, add them to the existing L3VpnRules. -
     * If the passed L3Vpn is a policy-based one and also has existing L3VpnRules,
     * update the existing L3VpnRules. This API is deprecated. Please use the following
     * APIs instead: - PATCH /infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id> to
     * patch the IPSecVpnTunnelProfile. - PATCH
     * /infra/ipsec-vpn-ike-profiles/<ike-profile-id> to patch the IPSecVpnIkeProfile.
     * - PATCH /infra/ipsec-vpn-dpd-profiles/<dpd-profile-id> to patch the
     * IPSecVpnDpdProfile. - PATCH
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to patch the IPSecVpnLocalEndpoint.
     * - PATCH
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/<l3vpn-id> to patch the IPSecVpnSession. If used, this
     * deprecated API will result in the following objects being internally
     * created/patched: - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id>. If an object
     * with the same \"local_address\" already exists, then it will be re-used. -
     * IPSecVpnSession: /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param l3Vpn (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.nsx_policy.model.L3Vpn l3Vpn);

    /**
     * Create the new L3Vpn if it does not exist. If the L3Vpn already exists, merge
     * with the the existing one. This is a patch. - If the passed L3Vpn is a
     * policy-based one and has new L3VpnRules, add them to the existing L3VpnRules. -
     * If the passed L3Vpn is a policy-based one and also has existing L3VpnRules,
     * update the existing L3VpnRules. This API is deprecated. Please use the following
     * APIs instead: - PATCH /infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id> to
     * patch the IPSecVpnTunnelProfile. - PATCH
     * /infra/ipsec-vpn-ike-profiles/<ike-profile-id> to patch the IPSecVpnIkeProfile.
     * - PATCH /infra/ipsec-vpn-dpd-profiles/<dpd-profile-id> to patch the
     * IPSecVpnDpdProfile. - PATCH
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to patch the IPSecVpnLocalEndpoint.
     * - PATCH
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/<l3vpn-id> to patch the IPSecVpnSession. If used, this
     * deprecated API will result in the following objects being internally
     * created/patched: - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id>. If an object
     * with the same \"local_address\" already exists, then it will be re-used. -
     * IPSecVpnSession: /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param l3Vpn (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.nsx_policy.model.L3Vpn l3Vpn, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create the new L3Vpn if it does not exist. If the L3Vpn already exists, merge
     * with the the existing one. This is a patch. - If the passed L3Vpn is a
     * policy-based one and has new L3VpnRules, add them to the existing L3VpnRules. -
     * If the passed L3Vpn is a policy-based one and also has existing L3VpnRules,
     * update the existing L3VpnRules. This API is deprecated. Please use the following
     * APIs instead: - PATCH /infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id> to
     * patch the IPSecVpnTunnelProfile. - PATCH
     * /infra/ipsec-vpn-ike-profiles/<ike-profile-id> to patch the IPSecVpnIkeProfile.
     * - PATCH /infra/ipsec-vpn-dpd-profiles/<dpd-profile-id> to patch the
     * IPSecVpnDpdProfile. - PATCH
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to patch the IPSecVpnLocalEndpoint.
     * - PATCH
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/<l3vpn-id> to patch the IPSecVpnSession. If used, this
     * deprecated API will result in the following objects being internally
     * created/patched: - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id>. If an object
     * with the same \"local_address\" already exists, then it will be re-used. -
     * IPSecVpnSession: /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param l3Vpn (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.nsx_policy.model.L3Vpn l3Vpn, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create the new L3Vpn if it does not exist. If the L3Vpn already exists, merge
     * with the the existing one. This is a patch. - If the passed L3Vpn is a
     * policy-based one and has new L3VpnRules, add them to the existing L3VpnRules. -
     * If the passed L3Vpn is a policy-based one and also has existing L3VpnRules,
     * update the existing L3VpnRules. This API is deprecated. Please use the following
     * APIs instead: - PATCH /infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id> to
     * patch the IPSecVpnTunnelProfile. - PATCH
     * /infra/ipsec-vpn-ike-profiles/<ike-profile-id> to patch the IPSecVpnIkeProfile.
     * - PATCH /infra/ipsec-vpn-dpd-profiles/<dpd-profile-id> to patch the
     * IPSecVpnDpdProfile. - PATCH
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to patch the IPSecVpnLocalEndpoint.
     * - PATCH
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/<l3vpn-id> to patch the IPSecVpnSession. If used, this
     * deprecated API will result in the following objects being internally
     * created/patched: - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id>. If an object
     * with the same \"local_address\" already exists, then it will be re-used. -
     * IPSecVpnSession: /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param l3Vpn (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.nsx_policy.model.L3Vpn l3Vpn, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read the L3Vpn with the given id. Sensitive data is returned as part of the
     * response. This API is deprecated. Please use the following APIs instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>?action=show_sensitive_data to get the
     * associated IPSecVpnSession. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to get the associated
     * IPSecVpnLocalEndpoint. - GET /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>
     * to get the associated IPSecVpnTunnelProfile. - GET
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id> to get the associated
     * IPSecVpnIkeProfile. - GET /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to get
     * the associated IPSecVpnDpdProfile. If used, this deprecated API will not return
     * L3Vpn with <l3vpn-id> id unless the associated IPSecVpnSession with
     * L3VPN_<l3vpn-id> id exists. For example, if the IPSecVpnSession gets deleted
     * using DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>, the deprecated API will throw an
     * ObjectNotFoundException.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @return com.vmware.nsx_policy.model.L3Vpn
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L3Vpn showsensitivedata(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId);

    /**
     * Read the L3Vpn with the given id. Sensitive data is returned as part of the
     * response. This API is deprecated. Please use the following APIs instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>?action=show_sensitive_data to get the
     * associated IPSecVpnSession. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to get the associated
     * IPSecVpnLocalEndpoint. - GET /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>
     * to get the associated IPSecVpnTunnelProfile. - GET
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id> to get the associated
     * IPSecVpnIkeProfile. - GET /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to get
     * the associated IPSecVpnDpdProfile. If used, this deprecated API will not return
     * L3Vpn with <l3vpn-id> id unless the associated IPSecVpnSession with
     * L3VPN_<l3vpn-id> id exists. For example, if the IPSecVpnSession gets deleted
     * using DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>, the deprecated API will throw an
     * ObjectNotFoundException.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.L3Vpn
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L3Vpn showsensitivedata(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read the L3Vpn with the given id. Sensitive data is returned as part of the
     * response. This API is deprecated. Please use the following APIs instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>?action=show_sensitive_data to get the
     * associated IPSecVpnSession. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to get the associated
     * IPSecVpnLocalEndpoint. - GET /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>
     * to get the associated IPSecVpnTunnelProfile. - GET
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id> to get the associated
     * IPSecVpnIkeProfile. - GET /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to get
     * the associated IPSecVpnDpdProfile. If used, this deprecated API will not return
     * L3Vpn with <l3vpn-id> id unless the associated IPSecVpnSession with
     * L3VPN_<l3vpn-id> id exists. For example, if the IPSecVpnSession gets deleted
     * using DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>, the deprecated API will throw an
     * ObjectNotFoundException.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L3Vpn
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void showsensitivedata(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L3Vpn> asyncCallback);

    /**
     * Read the L3Vpn with the given id. Sensitive data is returned as part of the
     * response. This API is deprecated. Please use the following APIs instead: - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>?action=show_sensitive_data to get the
     * associated IPSecVpnSession. - GET
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to get the associated
     * IPSecVpnLocalEndpoint. - GET /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>
     * to get the associated IPSecVpnTunnelProfile. - GET
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id> to get the associated
     * IPSecVpnIkeProfile. - GET /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id> to get
     * the associated IPSecVpnDpdProfile. If used, this deprecated API will not return
     * L3Vpn with <l3vpn-id> id unless the associated IPSecVpnSession with
     * L3VPN_<l3vpn-id> id exists. For example, if the IPSecVpnSession gets deleted
     * using DELETE
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/L3VPN_<l3vpn-id>, the deprecated API will throw an
     * ObjectNotFoundException.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L3Vpn
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void showsensitivedata(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L3Vpn> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create a new L3Vpn if the L3Vpn with given id does not already exist. If the
     * L3Vpn with the given id already exists, replace the existing L3Vpn. This a full
     * replace. This API is deprecated. Please use the following APIs instead: - PUT
     * /infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id> to update the
     * IPSecVpnTunnelProfile. - PUT /infra/ipsec-vpn-ike-profiles/<ike-profile-id> to
     * update the IPSecVpnIkeProfile. - PUT
     * /infra/ipsec-vpn-dpd-profiles/<dpd-profile-id> to update the IPSecVpnDpdProfile.
     * - PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to update the IPSecVpnLocalEndpoint.
     * - PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/<l3vpn-id> to update the IPSecVpnSession. If used, this
     * deprecated API will result in the following objects being internally
     * created/updated: - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id>. If an object
     * with the same \"local_address\" already exists, then it will be re-used. -
     * IPSecVpnSession: /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param l3Vpn (required)
     * @return com.vmware.nsx_policy.model.L3Vpn
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L3Vpn update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.nsx_policy.model.L3Vpn l3Vpn);

    /**
     * Create a new L3Vpn if the L3Vpn with given id does not already exist. If the
     * L3Vpn with the given id already exists, replace the existing L3Vpn. This a full
     * replace. This API is deprecated. Please use the following APIs instead: - PUT
     * /infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id> to update the
     * IPSecVpnTunnelProfile. - PUT /infra/ipsec-vpn-ike-profiles/<ike-profile-id> to
     * update the IPSecVpnIkeProfile. - PUT
     * /infra/ipsec-vpn-dpd-profiles/<dpd-profile-id> to update the IPSecVpnDpdProfile.
     * - PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to update the IPSecVpnLocalEndpoint.
     * - PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/<l3vpn-id> to update the IPSecVpnSession. If used, this
     * deprecated API will result in the following objects being internally
     * created/updated: - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id>. If an object
     * with the same \"local_address\" already exists, then it will be re-used. -
     * IPSecVpnSession: /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param l3Vpn (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.L3Vpn
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L3Vpn update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.nsx_policy.model.L3Vpn l3Vpn, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a new L3Vpn if the L3Vpn with given id does not already exist. If the
     * L3Vpn with the given id already exists, replace the existing L3Vpn. This a full
     * replace. This API is deprecated. Please use the following APIs instead: - PUT
     * /infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id> to update the
     * IPSecVpnTunnelProfile. - PUT /infra/ipsec-vpn-ike-profiles/<ike-profile-id> to
     * update the IPSecVpnIkeProfile. - PUT
     * /infra/ipsec-vpn-dpd-profiles/<dpd-profile-id> to update the IPSecVpnDpdProfile.
     * - PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to update the IPSecVpnLocalEndpoint.
     * - PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/<l3vpn-id> to update the IPSecVpnSession. If used, this
     * deprecated API will result in the following objects being internally
     * created/updated: - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id>. If an object
     * with the same \"local_address\" already exists, then it will be re-used. -
     * IPSecVpnSession: /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L3Vpn
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param l3Vpn (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.nsx_policy.model.L3Vpn l3Vpn, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L3Vpn> asyncCallback);

    /**
     * Create a new L3Vpn if the L3Vpn with given id does not already exist. If the
     * L3Vpn with the given id already exists, replace the existing L3Vpn. This a full
     * replace. This API is deprecated. Please use the following APIs instead: - PUT
     * /infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id> to update the
     * IPSecVpnTunnelProfile. - PUT /infra/ipsec-vpn-ike-profiles/<ike-profile-id> to
     * update the IPSecVpnIkeProfile. - PUT
     * /infra/ipsec-vpn-dpd-profiles/<dpd-profile-id> to update the IPSecVpnDpdProfile.
     * - PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/local-endpoints/<local-endpoint-id> to update the IPSecVpnLocalEndpoint.
     * - PUT
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/ipsec-vpn-services/
     * default/sessions/<l3vpn-id> to update the IPSecVpnSession. If used, this
     * deprecated API will result in the following objects being internally
     * created/updated: - IPSecVpnTunnelProfile:
     * /infra/ipsec-vpn-tunnel-profiles/L3VPN_<l3vpn-id>. - IPSecVpnIkeProfile:
     * /infra/ipsec-vpn-ike-profiles/L3VPN_<l3vpn-id>. - IPSecVpnDpdProfile:
     * /infra/ipsec-vpn-dpd-profiles/L3VPN_<l3vpn-id>. - IPSecVpnLocalEndpoint:
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/local-endpoints/<local-endpoint-id>. If an object
     * with the same \"local_address\" already exists, then it will be re-used. -
     * IPSecVpnSession: /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/
     * ipsec-vpn-services/default/sessions/L3VPN_<l3vpn-id>.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L3Vpn
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param localeServiceId (required)
     * @param l3vpnId (required)
     * @param l3Vpn (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String l3vpnId, com.vmware.nsx_policy.model.L3Vpn l3Vpn, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L3Vpn> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
