/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_0s.locale_services.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_0s.locale_services;

public interface ServiceInstances extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_0s.locale_services.ServiceInstancesTypes {

    /**
     * Delete policy service instance
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId);

    /**
     * Delete policy service instance
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete policy service instance
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete policy service instance
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read service instance
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @return com.vmware.nsx_policy.model.PolicyServiceInstance
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyServiceInstance get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId);

    /**
     * Read service instance
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyServiceInstance
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyServiceInstance get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read service instance
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyServiceInstance
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyServiceInstance> asyncCallback);

    /**
     * Read service instance
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyServiceInstance
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyServiceInstance> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read all service instance objects under a tier-0
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.PolicyServiceInstanceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyServiceInstanceListResult list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Read all service instance objects under a tier-0
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyServiceInstanceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyServiceInstanceListResult list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read all service instance objects under a tier-0
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyServiceInstanceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyServiceInstanceListResult> asyncCallback);

    /**
     * Read all service instance objects under a tier-0
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyServiceInstanceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyServiceInstanceListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create Service Instance. Please note that, only display_name, description and
     * deployment_spec_name are allowed to be modified in an exisiting entity. If the
     * deployment spec name is changed, it will trigger the upgrade operation for the
     * SVMs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param policyServiceInstance (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.nsx_policy.model.PolicyServiceInstance policyServiceInstance);

    /**
     * Create Service Instance. Please note that, only display_name, description and
     * deployment_spec_name are allowed to be modified in an exisiting entity. If the
     * deployment spec name is changed, it will trigger the upgrade operation for the
     * SVMs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param policyServiceInstance (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.nsx_policy.model.PolicyServiceInstance policyServiceInstance, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create Service Instance. Please note that, only display_name, description and
     * deployment_spec_name are allowed to be modified in an exisiting entity. If the
     * deployment spec name is changed, it will trigger the upgrade operation for the
     * SVMs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param policyServiceInstance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.nsx_policy.model.PolicyServiceInstance policyServiceInstance, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create Service Instance. Please note that, only display_name, description and
     * deployment_spec_name are allowed to be modified in an exisiting entity. If the
     * deployment spec name is changed, it will trigger the upgrade operation for the
     * SVMs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param policyServiceInstance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.nsx_policy.model.PolicyServiceInstance policyServiceInstance, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Use this API when an alarm complaining JWT expiry is raised while deploying
     * partner service VM. The OVF for partner service needs to be downloaded from
     * partner services provider. It might be possible that the authentication token
     * for this communication is expired when the service VM deployment starts. That
     * will either require re-login through UI or use of this API. Certain
     * authentication and authorization steps are internally processed in order to
     * enable communication with partner service provider. This API offers the
     * functionality to re-establish communication with partner services provider. This
     * API needs open id and access token to be passed as headers. Those can be
     * obtained from CSP authorize API. Please make sure to pass headers -
     * Authorization:<Bearer ACCESS_TOKEN> and X-NSX-OpenId:<OPEN_ID>.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void reauth(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId);

    /**
     * Use this API when an alarm complaining JWT expiry is raised while deploying
     * partner service VM. The OVF for partner service needs to be downloaded from
     * partner services provider. It might be possible that the authentication token
     * for this communication is expired when the service VM deployment starts. That
     * will either require re-login through UI or use of this API. Certain
     * authentication and authorization steps are internally processed in order to
     * enable communication with partner service provider. This API offers the
     * functionality to re-establish communication with partner services provider. This
     * API needs open id and access token to be passed as headers. Those can be
     * obtained from CSP authorize API. Please make sure to pass headers -
     * Authorization:<Bearer ACCESS_TOKEN> and X-NSX-OpenId:<OPEN_ID>.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void reauth(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Use this API when an alarm complaining JWT expiry is raised while deploying
     * partner service VM. The OVF for partner service needs to be downloaded from
     * partner services provider. It might be possible that the authentication token
     * for this communication is expired when the service VM deployment starts. That
     * will either require re-login through UI or use of this API. Certain
     * authentication and authorization steps are internally processed in order to
     * enable communication with partner service provider. This API offers the
     * functionality to re-establish communication with partner services provider. This
     * API needs open id and access token to be passed as headers. Those can be
     * obtained from CSP authorize API. Please make sure to pass headers -
     * Authorization:<Bearer ACCESS_TOKEN> and X-NSX-OpenId:<OPEN_ID>.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void reauth(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Use this API when an alarm complaining JWT expiry is raised while deploying
     * partner service VM. The OVF for partner service needs to be downloaded from
     * partner services provider. It might be possible that the authentication token
     * for this communication is expired when the service VM deployment starts. That
     * will either require re-login through UI or use of this API. Certain
     * authentication and authorization steps are internally processed in order to
     * enable communication with partner service provider. This API offers the
     * functionality to re-establish communication with partner services provider. This
     * API needs open id and access token to be passed as headers. Those can be
     * obtained from CSP authorize API. Please make sure to pass headers -
     * Authorization:<Bearer ACCESS_TOKEN> and X-NSX-OpenId:<OPEN_ID>.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void reauth(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create service instance. Please note that, only display_name, description and
     * deployment_spec_name are allowed to be modified in an exisiting entity. If the
     * deployment spec name is changed, it will trigger the upgrade operation for the
     * SVMs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param policyServiceInstance (required)
     * @return com.vmware.nsx_policy.model.PolicyServiceInstance
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyServiceInstance update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.nsx_policy.model.PolicyServiceInstance policyServiceInstance);

    /**
     * Create service instance. Please note that, only display_name, description and
     * deployment_spec_name are allowed to be modified in an exisiting entity. If the
     * deployment spec name is changed, it will trigger the upgrade operation for the
     * SVMs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param policyServiceInstance (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyServiceInstance
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyServiceInstance update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.nsx_policy.model.PolicyServiceInstance policyServiceInstance, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create service instance. Please note that, only display_name, description and
     * deployment_spec_name are allowed to be modified in an exisiting entity. If the
     * deployment spec name is changed, it will trigger the upgrade operation for the
     * SVMs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyServiceInstance
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param policyServiceInstance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.nsx_policy.model.PolicyServiceInstance policyServiceInstance, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyServiceInstance> asyncCallback);

    /**
     * Create service instance. Please note that, only display_name, description and
     * deployment_spec_name are allowed to be modified in an exisiting entity. If the
     * deployment spec name is changed, it will trigger the upgrade operation for the
     * SVMs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyServiceInstance
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param policyServiceInstance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, com.vmware.nsx_policy.model.PolicyServiceInstance policyServiceInstance, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyServiceInstance> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
