/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_1s.dns_forwarder.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_1s.dns_forwarder;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_1s.dns_forwarder.StatusTypes {

    /**
     * Get current status of tier-1 DNS forwarder. - no enforcement point path
     * specified: Status will be evaluated on each enforcement point. -
     * {enforcement_point_path}: Status will be evaluated only on the given enforcement
     * point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id Tier-1 id (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @return com.vmware.nsx_policy.model.AggregateDNSForwarderStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.AggregateDNSForwarderStatus get(java.lang.String tier1Id, java.lang.String enforcementPointPath);

    /**
     * Get current status of tier-1 DNS forwarder. - no enforcement point path
     * specified: Status will be evaluated on each enforcement point. -
     * {enforcement_point_path}: Status will be evaluated only on the given enforcement
     * point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id Tier-1 id (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.AggregateDNSForwarderStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.AggregateDNSForwarderStatus get(java.lang.String tier1Id, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get current status of tier-1 DNS forwarder. - no enforcement point path
     * specified: Status will be evaluated on each enforcement point. -
     * {enforcement_point_path}: Status will be evaluated only on the given enforcement
     * point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.AggregateDNSForwarderStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 id (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.AggregateDNSForwarderStatus> asyncCallback);

    /**
     * Get current status of tier-1 DNS forwarder. - no enforcement point path
     * specified: Status will be evaluated on each enforcement point. -
     * {enforcement_point_path}: Status will be evaluated only on the given enforcement
     * point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.AggregateDNSForwarderStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 id (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.AggregateDNSForwarderStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
