/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_1s.segments.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_1s.segments;

public interface DhcpStaticBindingConfigs extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_1s.segments.DhcpStaticBindingConfigsTypes {

    /**
     * Delete DHCP static binding
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId);

    /**
     * Delete DHCP static binding
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete DHCP static binding
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete DHCP static binding
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read DHCP static binding
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @return com.vmware.nsx_policy.model.DhcpStaticBindingConfig
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId);

    /**
     * Read DHCP static binding
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.DhcpStaticBindingConfig
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read DHCP static binding
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Read DHCP static binding
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Paginated list of all DHCP static binding instances
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Paginated list of all DHCP static binding instances
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Paginated list of all DHCP static binding instances
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult> asyncCallback);

    /**
     * Paginated list of all DHCP static binding instances
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If binding with the binding-id is not already present, create a new DHCP static
     * binding instance. If it already exists, replace the existing DHCP static binding
     * instance with specified attributes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param dhcpStaticBindingConfig (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.Structure dhcpStaticBindingConfig);

    /**
     * If binding with the binding-id is not already present, create a new DHCP static
     * binding instance. If it already exists, replace the existing DHCP static binding
     * instance with specified attributes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param dhcpStaticBindingConfig (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.Structure dhcpStaticBindingConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If binding with the binding-id is not already present, create a new DHCP static
     * binding instance. If it already exists, replace the existing DHCP static binding
     * instance with specified attributes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param dhcpStaticBindingConfig (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.Structure dhcpStaticBindingConfig, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If binding with the binding-id is not already present, create a new DHCP static
     * binding instance. If it already exists, replace the existing DHCP static binding
     * instance with specified attributes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param dhcpStaticBindingConfig (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.Structure dhcpStaticBindingConfig, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If binding with the binding-id is not already present, create a new DHCP static
     * binding instance. If it already exists, replace the existing DHCP static binding
     * instance with this object.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param dhcpStaticBindingConfig (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @return com.vmware.nsx_policy.model.DhcpStaticBindingConfig
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.Structure dhcpStaticBindingConfig);

    /**
     * If binding with the binding-id is not already present, create a new DHCP static
     * binding instance. If it already exists, replace the existing DHCP static binding
     * instance with this object.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param dhcpStaticBindingConfig (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.DhcpStaticBindingConfig
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.Structure dhcpStaticBindingConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If binding with the binding-id is not already present, create a new DHCP static
     * binding instance. If it already exists, replace the existing DHCP static binding
     * instance with this object.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param dhcpStaticBindingConfig (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.Structure dhcpStaticBindingConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * If binding with the binding-id is not already present, create a new DHCP static
     * binding instance. If it already exists, replace the existing DHCP static binding
     * instance with this object.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param bindingId (required)
     * @param dhcpStaticBindingConfig (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.DhcpStaticBindingConfig}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String bindingId, com.vmware.vapi.bindings.Structure dhcpStaticBindingConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
