/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * configuration parameters for Bridge Profile
 */
public final class BridgeProfileConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String bridgeProfilePath;

    private java.lang.String uplinkTeamingPolicyName;

    private java.util.List<java.lang.String> vlanIds;

    private java.lang.String vlanTransportZonePath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public BridgeProfileConfig() {
    }

    protected BridgeProfileConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Same bridge profile can be configured on different segments. Each bridge profile
     * on a segment must unique.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBridgeProfilePath() {
        return this.bridgeProfilePath;
    }

    /**
     * Same bridge profile can be configured on different segments. Each bridge profile
     * on a segment must unique.
     *
     * @param bridgeProfilePath New value for the property.
     */
    public void setBridgeProfilePath(java.lang.String bridgeProfilePath) {
        this.bridgeProfilePath = bridgeProfilePath;
    }

    /**
     * The name of the switching uplink teaming policy for the bridge endpoint. This
     * name corresponds to one fot he switching uplink teaming policy names listed in
     * teh transport zone. When this property is not specified, the teaming policy is
     * assigned by MP.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUplinkTeamingPolicyName() {
        return this.uplinkTeamingPolicyName;
    }

    /**
     * The name of the switching uplink teaming policy for the bridge endpoint. This
     * name corresponds to one fot he switching uplink teaming policy names listed in
     * teh transport zone. When this property is not specified, the teaming policy is
     * assigned by MP.
     *
     * @param uplinkTeamingPolicyName New value for the property.
     */
    public void setUplinkTeamingPolicyName(java.lang.String uplinkTeamingPolicyName) {
        this.uplinkTeamingPolicyName = uplinkTeamingPolicyName;
    }

    /**
     * VLAN specification for bridge endpoint. Either VLAN ID or VLAN ranges can be
     * specified. Not both.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getVlanIds() {
        return this.vlanIds;
    }

    /**
     * VLAN specification for bridge endpoint. Either VLAN ID or VLAN ranges can be
     * specified. Not both.
     *
     * @param vlanIds New value for the property.
     */
    public void setVlanIds(java.util.List<java.lang.String> vlanIds) {
        this.vlanIds = vlanIds;
    }

    /**
     * VLAN transport zone should belong to the enforcment-point as the transport zone
     * specified in the segment.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVlanTransportZonePath() {
        return this.vlanTransportZonePath;
    }

    /**
     * VLAN transport zone should belong to the enforcment-point as the transport zone
     * specified in the segment.
     *
     * @param vlanTransportZonePath New value for the property.
     */
    public void setVlanTransportZonePath(java.lang.String vlanTransportZonePath) {
        this.vlanTransportZonePath = vlanTransportZonePath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.bridgeProfileConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("bridge_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bridgeProfilePath, this._getType().getField("bridge_profile_path")));
        structValue.setField("uplink_teaming_policy_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uplinkTeamingPolicyName, this._getType().getField("uplink_teaming_policy_name")));
        structValue.setField("vlan_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vlanIds, this._getType().getField("vlan_ids")));
        structValue.setField("vlan_transport_zone_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vlanTransportZonePath, this._getType().getField("vlan_transport_zone_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.bridgeProfileConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.bridgeProfileConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static BridgeProfileConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new BridgeProfileConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static BridgeProfileConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new BridgeProfileConfig(structValue);
    }

    /**
     * Builder class for {@link BridgeProfileConfig}.
     */
    public static final class Builder {
        private java.lang.String bridgeProfilePath;
        private java.lang.String uplinkTeamingPolicyName;
        private java.util.List<java.lang.String> vlanIds;
        private java.lang.String vlanTransportZonePath;

        /**
         * Constructor with parameters for the required properties of
         * {@link BridgeProfileConfig}.
         */
        public Builder() {
        }

        /**
         * Same bridge profile can be configured on different segments. Each bridge profile
         * on a segment must unique.
         *
         * @param bridgeProfilePath New value for the property.
         */
        public Builder setBridgeProfilePath(java.lang.String bridgeProfilePath) {
            this.bridgeProfilePath = bridgeProfilePath;
            return this;
        }

        /**
         * The name of the switching uplink teaming policy for the bridge endpoint. This
         * name corresponds to one fot he switching uplink teaming policy names listed in
         * teh transport zone. When this property is not specified, the teaming policy is
         * assigned by MP.
         *
         * @param uplinkTeamingPolicyName New value for the property.
         */
        public Builder setUplinkTeamingPolicyName(java.lang.String uplinkTeamingPolicyName) {
            this.uplinkTeamingPolicyName = uplinkTeamingPolicyName;
            return this;
        }

        /**
         * VLAN specification for bridge endpoint. Either VLAN ID or VLAN ranges can be
         * specified. Not both.
         *
         * @param vlanIds New value for the property.
         */
        public Builder setVlanIds(java.util.List<java.lang.String> vlanIds) {
            this.vlanIds = vlanIds;
            return this;
        }

        /**
         * VLAN transport zone should belong to the enforcment-point as the transport zone
         * specified in the segment.
         *
         * @param vlanTransportZonePath New value for the property.
         */
        public Builder setVlanTransportZonePath(java.lang.String vlanTransportZonePath) {
            this.vlanTransportZonePath = vlanTransportZonePath;
            return this;
        }

        public BridgeProfileConfig build() {
            BridgeProfileConfig result = new BridgeProfileConfig();
            result.setBridgeProfilePath(this.bridgeProfilePath);
            result.setUplinkTeamingPolicyName(this.uplinkTeamingPolicyName);
            result.setVlanIds(this.vlanIds);
            result.setVlanTransportZonePath(this.vlanTransportZonePath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("bridge_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bridge_profile_path",
                                                                                "bridgeProfilePath",
                                                                                "getBridgeProfilePath",
                                                                                "setBridgeProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uplink_teaming_policy_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uplink_teaming_policy_name",
                                                                                "uplinkTeamingPolicyName",
                                                                                "getUplinkTeamingPolicyName",
                                                                                "setUplinkTeamingPolicyName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vlan_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vlan_ids",
                                                                                "vlanIds",
                                                                                "getVlanIds",
                                                                                "setVlanIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vlan_transport_zone_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vlan_transport_zone_path",
                                                                                "vlanTransportZonePath",
                                                                                "getVlanTransportZonePath",
                                                                                "setVlanTransportZonePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.bridge_profile_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.BridgeProfileConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

