/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Result of prechecks run for onboarding standby Global Manager or remote site.
 * The checks include NSX version compatibility with active Global Manager, Round
 * Trip Time (RTT), etc. Note that some of checks like RTT are soft limits.
 */
public final class CompatibilityCheckResult implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String localNsxVersion;

    private java.lang.String nsxVersion;

    private java.lang.Long rtt;

    private java.lang.Boolean rttExceeded;

    private java.lang.Boolean versionCompatible;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CompatibilityCheckResult() {
    }

    protected CompatibilityCheckResult(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Local Site NSX version where active Global Mananger is running.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocalNsxVersion() {
        return this.localNsxVersion;
    }

    /**
     * Local Site NSX version where active Global Mananger is running.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param localNsxVersion New value for the property.
     */
    public void setLocalNsxVersion(java.lang.String localNsxVersion) {
        this.localNsxVersion = localNsxVersion;
    }

    /**
     * Remote Site NSX version.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxVersion() {
        return this.nsxVersion;
    }

    /**
     * Remote Site NSX version.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nsxVersion New value for the property.
     */
    public void setNsxVersion(java.lang.String nsxVersion) {
        this.nsxVersion = nsxVersion;
    }

    /**
     * Round trip time to the remote Site or Global Manager from active Global Manager.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRtt() {
        return this.rtt;
    }

    /**
     * Round trip time to the remote Site or Global Manager from active Global Manager.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rtt New value for the property.
     */
    public void setRtt(java.lang.Long rtt) {
        this.rtt = rtt;
    }

    /**
     * Flag to indicate if RTT to remote Site exceeds the recommended limit.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRttExceeded() {
        return this.rttExceeded;
    }

    /**
     * Flag to indicate if RTT to remote Site exceeds the recommended limit.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rttExceeded New value for the property.
     */
    public void setRttExceeded(java.lang.Boolean rttExceeded) {
        this.rttExceeded = rttExceeded;
    }

    /**
     * Flag to indicate if remote Site NSX version is compatible with active Global
     * Manager.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVersionCompatible() {
        return this.versionCompatible;
    }

    /**
     * Flag to indicate if remote Site NSX version is compatible with active Global
     * Manager.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param versionCompatible New value for the property.
     */
    public void setVersionCompatible(java.lang.Boolean versionCompatible) {
        this.versionCompatible = versionCompatible;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.compatibilityCheckResult;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("local_nsx_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localNsxVersion, this._getType().getField("local_nsx_version")));
        structValue.setField("nsx_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxVersion, this._getType().getField("nsx_version")));
        structValue.setField("rtt",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rtt, this._getType().getField("rtt")));
        structValue.setField("rtt_exceeded",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rttExceeded, this._getType().getField("rtt_exceeded")));
        structValue.setField("version_compatible",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.versionCompatible, this._getType().getField("version_compatible")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.compatibilityCheckResult;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.compatibilityCheckResult.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CompatibilityCheckResult _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CompatibilityCheckResult(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CompatibilityCheckResult _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CompatibilityCheckResult(structValue);
    }

    /**
     * Builder class for {@link CompatibilityCheckResult}.
     */
    public static final class Builder {
        private java.lang.String localNsxVersion;
        private java.lang.String nsxVersion;
        private java.lang.Long rtt;
        private java.lang.Boolean rttExceeded;
        private java.lang.Boolean versionCompatible;

        /**
         * Constructor with parameters for the required properties of
         * {@link CompatibilityCheckResult}.
         */
        public Builder() {
        }

        /**
         * Local Site NSX version where active Global Mananger is running.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param localNsxVersion New value for the property.
         */
        public Builder setLocalNsxVersion(java.lang.String localNsxVersion) {
            this.localNsxVersion = localNsxVersion;
            return this;
        }

        /**
         * Remote Site NSX version.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nsxVersion New value for the property.
         */
        public Builder setNsxVersion(java.lang.String nsxVersion) {
            this.nsxVersion = nsxVersion;
            return this;
        }

        /**
         * Round trip time to the remote Site or Global Manager from active Global Manager.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rtt New value for the property.
         */
        public Builder setRtt(java.lang.Long rtt) {
            this.rtt = rtt;
            return this;
        }

        /**
         * Flag to indicate if RTT to remote Site exceeds the recommended limit.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rttExceeded New value for the property.
         */
        public Builder setRttExceeded(java.lang.Boolean rttExceeded) {
            this.rttExceeded = rttExceeded;
            return this;
        }

        /**
         * Flag to indicate if remote Site NSX version is compatible with active Global
         * Manager.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param versionCompatible New value for the property.
         */
        public Builder setVersionCompatible(java.lang.Boolean versionCompatible) {
            this.versionCompatible = versionCompatible;
            return this;
        }

        public CompatibilityCheckResult build() {
            CompatibilityCheckResult result = new CompatibilityCheckResult();
            result.setLocalNsxVersion(this.localNsxVersion);
            result.setNsxVersion(this.nsxVersion);
            result.setRtt(this.rtt);
            result.setRttExceeded(this.rttExceeded);
            result.setVersionCompatible(this.versionCompatible);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("local_nsx_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_nsx_version",
                                                                                "localNsxVersion",
                                                                                "getLocalNsxVersion",
                                                                                "setLocalNsxVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsx_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsx_version",
                                                                                "nsxVersion",
                                                                                "getNsxVersion",
                                                                                "setNsxVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rtt", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rtt",
                                                                                "rtt",
                                                                                "getRtt",
                                                                                "setRtt");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rtt_exceeded", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rtt_exceeded",
                                                                                "rttExceeded",
                                                                                "getRttExceeded",
                                                                                "setRttExceeded");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("version_compatible", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("version_compatible",
                                                                                "versionCompatible",
                                                                                "getVersionCompatible",
                                                                                "setVersionCompatible");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.compatibility_check_result",
                                                            fields,
                                                            com.vmware.nsx_policy.model.CompatibilityCheckResult.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

