/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * DHCP config. This dhcp configuration can be overriden per subnet.
 */
public final class DhcpConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String dhcpRelayConfigPath;

    private com.vmware.nsx_policy.model.DnsClientConfig dnsClientConfig;

    private java.lang.Boolean enableDhcp;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DhcpConfig() {
    }

    protected DhcpConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Policy path of DHCP-relay-config. If configured then all the subnets will be
     * configured with the DHCP relay server. If not specified, then the local DHCP
     * server will be configured for all connected subnets.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDhcpRelayConfigPath() {
        return this.dhcpRelayConfigPath;
    }

    /**
     * Policy path of DHCP-relay-config. If configured then all the subnets will be
     * configured with the DHCP relay server. If not specified, then the local DHCP
     * server will be configured for all connected subnets.
     *
     * @param dhcpRelayConfigPath New value for the property.
     */
    public void setDhcpRelayConfigPath(java.lang.String dhcpRelayConfigPath) {
        this.dhcpRelayConfigPath = dhcpRelayConfigPath;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.DnsClientConfig getDnsClientConfig() {
        return this.dnsClientConfig;
    }

    /**
     *
     *
     * @param dnsClientConfig New value for the property.
     */
    public void setDnsClientConfig(com.vmware.nsx_policy.model.DnsClientConfig dnsClientConfig) {
        this.dnsClientConfig = dnsClientConfig;
    }

    /**
     * If enabled, the DHCP server will be configured based on IP address type. If
     * disabled then neither DHCP server nor relay shall be configured.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableDhcp() {
        return this.enableDhcp;
    }

    /**
     * If enabled, the DHCP server will be configured based on IP address type. If
     * disabled then neither DHCP server nor relay shall be configured.
     *
     * @param enableDhcp New value for the property.
     */
    public void setEnableDhcp(java.lang.Boolean enableDhcp) {
        this.enableDhcp = enableDhcp;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.dhcpConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dhcp_relay_config_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpRelayConfigPath, this._getType().getField("dhcp_relay_config_path")));
        structValue.setField("dns_client_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsClientConfig, this._getType().getField("dns_client_config")));
        structValue.setField("enable_dhcp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableDhcp, this._getType().getField("enable_dhcp")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.dhcpConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.dhcpConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DhcpConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DhcpConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DhcpConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DhcpConfig(structValue);
    }

    /**
     * Builder class for {@link DhcpConfig}.
     */
    public static final class Builder {
        private java.lang.String dhcpRelayConfigPath;
        private com.vmware.nsx_policy.model.DnsClientConfig dnsClientConfig;
        private java.lang.Boolean enableDhcp;

        /**
         * Constructor with parameters for the required properties of
         * {@link DhcpConfig}.
         */
        public Builder() {
        }

        /**
         * Policy path of DHCP-relay-config. If configured then all the subnets will be
         * configured with the DHCP relay server. If not specified, then the local DHCP
         * server will be configured for all connected subnets.
         *
         * @param dhcpRelayConfigPath New value for the property.
         */
        public Builder setDhcpRelayConfigPath(java.lang.String dhcpRelayConfigPath) {
            this.dhcpRelayConfigPath = dhcpRelayConfigPath;
            return this;
        }

        /**
         *
         *
         * @param dnsClientConfig New value for the property.
         */
        public Builder setDnsClientConfig(com.vmware.nsx_policy.model.DnsClientConfig dnsClientConfig) {
            this.dnsClientConfig = dnsClientConfig;
            return this;
        }

        /**
         * If enabled, the DHCP server will be configured based on IP address type. If
         * disabled then neither DHCP server nor relay shall be configured.
         *
         * @param enableDhcp New value for the property.
         */
        public Builder setEnableDhcp(java.lang.Boolean enableDhcp) {
            this.enableDhcp = enableDhcp;
            return this;
        }

        public DhcpConfig build() {
            DhcpConfig result = new DhcpConfig();
            result.setDhcpRelayConfigPath(this.dhcpRelayConfigPath);
            result.setDnsClientConfig(this.dnsClientConfig);
            result.setEnableDhcp(this.enableDhcp);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dhcp_relay_config_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_relay_config_path",
                                                                                "dhcpRelayConfigPath",
                                                                                "getDhcpRelayConfigPath",
                                                                                "setDhcpRelayConfigPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_client_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.dnsClientConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_client_config",
                                                                                "dnsClientConfig",
                                                                                "getDnsClientConfig",
                                                                                "setDnsClientConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_dhcp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_dhcp",
                                                                                "enableDhcp",
                                                                                "getEnableDhcp",
                                                                                "setEnableDhcp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.dhcp_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.DhcpConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

