/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Directory domain synchronization statistics
 */
public final class DirectoryDomainSyncStats implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CURRENT_STATE_IDLE = "IDLE";

    public static final java.lang.String CURRENT_STATE_FULL_SYNC = "FULL_SYNC";

    public static final java.lang.String CURRENT_STATE_DELTA_SYNC = "DELTA_SYNC";

    public static final java.lang.String CURRENT_STATE_SELECTIVE_FULL_SYNC = "SELECTIVE_FULL_SYNC";

    public static final java.lang.String CURRENT_STATE_SELECTIVE_DELTA_SYNC = "SELECTIVE_DELTA_SYNC";

    public static final java.lang.String PREV_SYNC_STATUS_SUCCESS = "SUCCESS";

    public static final java.lang.String PREV_SYNC_STATUS_FAILURE = "FAILURE";

    public static final java.lang.String PREV_SYNC_STATUS_UNKNOWN = "UNKNOWN";

    public static final java.lang.String PREV_SYNC_TYPE_IDLE = "IDLE";

    public static final java.lang.String PREV_SYNC_TYPE_FULL_SYNC = "FULL_SYNC";

    public static final java.lang.String PREV_SYNC_TYPE_DELTA_SYNC = "DELTA_SYNC";

    public static final java.lang.String PREV_SYNC_TYPE_SELECTIVE_FULL_SYNC = "SELECTIVE_FULL_SYNC";

    public static final java.lang.String PREV_SYNC_TYPE_SELECTIVE_DELTA_SYNC = "SELECTIVE_DELTA_SYNC";

    private java.lang.Long avgDeltaSyncTime;

    private java.lang.Long avgFullSyncTime;

    private java.lang.String currentState;

    private java.lang.Long currentStateBeginTime;

    private java.lang.Long numDeltaSync;

    private java.lang.Long numFullSync;

    private java.lang.Long prevSyncEndTime;

    private java.lang.String prevSyncError;

    private java.lang.String prevSyncStatus;

    private java.lang.String prevSyncType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DirectoryDomainSyncStats() {
    }

    protected DirectoryDomainSyncStats(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * All the historical delta sync are counted in calculating the average delta sync
     * time in milliseconds. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAvgDeltaSyncTime() {
        return this.avgDeltaSyncTime;
    }

    /**
     * All the historical delta sync are counted in calculating the average delta sync
     * time in milliseconds. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param avgDeltaSyncTime New value for the property.
     */
    public void setAvgDeltaSyncTime(java.lang.Long avgDeltaSyncTime) {
        this.avgDeltaSyncTime = avgDeltaSyncTime;
    }

    /**
     * All the historical full sync are counted in calculating the average full sync
     * time in milliseconds. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAvgFullSyncTime() {
        return this.avgFullSyncTime;
    }

    /**
     * All the historical full sync are counted in calculating the average full sync
     * time in milliseconds. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param avgFullSyncTime New value for the property.
     */
    public void setAvgFullSyncTime(java.lang.Long avgFullSyncTime) {
        this.avgFullSyncTime = avgFullSyncTime;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_IDLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_FULL_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_DELTA_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_SELECTIVE_FULL_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_SELECTIVE_DELTA_SYNC}</li>
     * </ul> Current running state of the directory domain in synchronization life
     * cycle. It could be one of the following five states. SELECTIVE_FULL_SYNC and
     * SELECTIVE_DELTA_SYNC are sync states for selective sync.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCurrentState() {
        return this.currentState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_IDLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_FULL_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_DELTA_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_SELECTIVE_FULL_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_SELECTIVE_DELTA_SYNC}</li>
     * </ul> Current running state of the directory domain in synchronization life
     * cycle. It could be one of the following five states. SELECTIVE_FULL_SYNC and
     * SELECTIVE_DELTA_SYNC are sync states for selective sync.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentState New value for the property.
     */
    public void setCurrentState(java.lang.String currentState) {
        this.currentState = currentState;
    }

    /**
     * Since what time the current state has begun. The time is expressed in
     * millisecond epoch time. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentStateBeginTime() {
        return this.currentStateBeginTime;
    }

    /**
     * Since what time the current state has begun. The time is expressed in
     * millisecond epoch time. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentStateBeginTime New value for the property.
     */
    public void setCurrentStateBeginTime(java.lang.Long currentStateBeginTime) {
        this.currentStateBeginTime = currentStateBeginTime;
    }

    /**
     * number of successful historical delta sync initiated either by system or by API
     * request. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumDeltaSync() {
        return this.numDeltaSync;
    }

    /**
     * number of successful historical delta sync initiated either by system or by API
     * request. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param numDeltaSync New value for the property.
     */
    public void setNumDeltaSync(java.lang.Long numDeltaSync) {
        this.numDeltaSync = numDeltaSync;
    }

    /**
     * number of successful historical full sync initiated either by system or by API
     * request. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumFullSync() {
        return this.numFullSync;
    }

    /**
     * number of successful historical full sync initiated either by system or by API
     * request. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param numFullSync New value for the property.
     */
    public void setNumFullSync(java.lang.Long numFullSync) {
        this.numFullSync = numFullSync;
    }

    /**
     * Directory domain previous sync ending time expressed in millisecond epoch time.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPrevSyncEndTime() {
        return this.prevSyncEndTime;
    }

    /**
     * Directory domain previous sync ending time expressed in millisecond epoch time.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param prevSyncEndTime New value for the property.
     */
    public void setPrevSyncEndTime(java.lang.Long prevSyncEndTime) {
        this.prevSyncEndTime = prevSyncEndTime;
    }

    /**
     * Directory domain previous sync status error if last status was failure.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrevSyncError() {
        return this.prevSyncError;
    }

    /**
     * Directory domain previous sync status error if last status was failure.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param prevSyncError New value for the property.
     */
    public void setPrevSyncError(java.lang.String prevSyncError) {
        this.prevSyncError = prevSyncError;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_FAILURE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_UNKNOWN}</li>
     * </ul> Directory domain previous sync status. It could be one of the following
     * two states.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrevSyncStatus() {
        return this.prevSyncStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_FAILURE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_UNKNOWN}</li>
     * </ul> Directory domain previous sync status. It could be one of the following
     * two states.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param prevSyncStatus New value for the property.
     */
    public void setPrevSyncStatus(java.lang.String prevSyncStatus) {
        this.prevSyncStatus = prevSyncStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_IDLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_FULL_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_DELTA_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_SELECTIVE_FULL_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_SELECTIVE_DELTA_SYNC}</li>
     * </ul> Directory domain previous sync type. It could be one of the following five
     * states. Right after the directory domain is configured, this field is set to
     * IDLE.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrevSyncType() {
        return this.prevSyncType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_IDLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_FULL_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_DELTA_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_SELECTIVE_FULL_SYNC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_SELECTIVE_DELTA_SYNC}</li>
     * </ul> Directory domain previous sync type. It could be one of the following five
     * states. Right after the directory domain is configured, this field is set to
     * IDLE.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param prevSyncType New value for the property.
     */
    public void setPrevSyncType(java.lang.String prevSyncType) {
        this.prevSyncType = prevSyncType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.directoryDomainSyncStats;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("avg_delta_sync_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.avgDeltaSyncTime, this._getType().getField("avg_delta_sync_time")));
        structValue.setField("avg_full_sync_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.avgFullSyncTime, this._getType().getField("avg_full_sync_time")));
        structValue.setField("current_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentState, this._getType().getField("current_state")));
        structValue.setField("current_state_begin_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentStateBeginTime, this._getType().getField("current_state_begin_time")));
        structValue.setField("num_delta_sync",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numDeltaSync, this._getType().getField("num_delta_sync")));
        structValue.setField("num_full_sync",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numFullSync, this._getType().getField("num_full_sync")));
        structValue.setField("prev_sync_end_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prevSyncEndTime, this._getType().getField("prev_sync_end_time")));
        structValue.setField("prev_sync_error",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prevSyncError, this._getType().getField("prev_sync_error")));
        structValue.setField("prev_sync_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prevSyncStatus, this._getType().getField("prev_sync_status")));
        structValue.setField("prev_sync_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prevSyncType, this._getType().getField("prev_sync_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.directoryDomainSyncStats;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.directoryDomainSyncStats.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DirectoryDomainSyncStats _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DirectoryDomainSyncStats(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DirectoryDomainSyncStats _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DirectoryDomainSyncStats(structValue);
    }

    /**
     * Builder class for {@link DirectoryDomainSyncStats}.
     */
    public static final class Builder {
        private java.lang.Long avgDeltaSyncTime;
        private java.lang.Long avgFullSyncTime;
        private java.lang.String currentState;
        private java.lang.Long currentStateBeginTime;
        private java.lang.Long numDeltaSync;
        private java.lang.Long numFullSync;
        private java.lang.Long prevSyncEndTime;
        private java.lang.String prevSyncError;
        private java.lang.String prevSyncStatus;
        private java.lang.String prevSyncType;

        /**
         * Constructor with parameters for the required properties of
         * {@link DirectoryDomainSyncStats}.
         */
        public Builder() {
        }

        /**
         * All the historical delta sync are counted in calculating the average delta sync
         * time in milliseconds. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param avgDeltaSyncTime New value for the property.
         */
        public Builder setAvgDeltaSyncTime(java.lang.Long avgDeltaSyncTime) {
            this.avgDeltaSyncTime = avgDeltaSyncTime;
            return this;
        }

        /**
         * All the historical full sync are counted in calculating the average full sync
         * time in milliseconds. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param avgFullSyncTime New value for the property.
         */
        public Builder setAvgFullSyncTime(java.lang.Long avgFullSyncTime) {
            this.avgFullSyncTime = avgFullSyncTime;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_IDLE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_FULL_SYNC}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_DELTA_SYNC}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_SELECTIVE_FULL_SYNC}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#CURRENT_STATE_SELECTIVE_DELTA_SYNC}</li>
         * </ul> Current running state of the directory domain in synchronization life
         * cycle. It could be one of the following five states. SELECTIVE_FULL_SYNC and
         * SELECTIVE_DELTA_SYNC are sync states for selective sync.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentState New value for the property.
         */
        public Builder setCurrentState(java.lang.String currentState) {
            this.currentState = currentState;
            return this;
        }

        /**
         * Since what time the current state has begun. The time is expressed in
         * millisecond epoch time. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentStateBeginTime New value for the property.
         */
        public Builder setCurrentStateBeginTime(java.lang.Long currentStateBeginTime) {
            this.currentStateBeginTime = currentStateBeginTime;
            return this;
        }

        /**
         * number of successful historical delta sync initiated either by system or by API
         * request. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param numDeltaSync New value for the property.
         */
        public Builder setNumDeltaSync(java.lang.Long numDeltaSync) {
            this.numDeltaSync = numDeltaSync;
            return this;
        }

        /**
         * number of successful historical full sync initiated either by system or by API
         * request. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param numFullSync New value for the property.
         */
        public Builder setNumFullSync(java.lang.Long numFullSync) {
            this.numFullSync = numFullSync;
            return this;
        }

        /**
         * Directory domain previous sync ending time expressed in millisecond epoch time.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param prevSyncEndTime New value for the property.
         */
        public Builder setPrevSyncEndTime(java.lang.Long prevSyncEndTime) {
            this.prevSyncEndTime = prevSyncEndTime;
            return this;
        }

        /**
         * Directory domain previous sync status error if last status was failure.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param prevSyncError New value for the property.
         */
        public Builder setPrevSyncError(java.lang.String prevSyncError) {
            this.prevSyncError = prevSyncError;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_SUCCESS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_FAILURE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_STATUS_UNKNOWN}</li>
         * </ul> Directory domain previous sync status. It could be one of the following
         * two states.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param prevSyncStatus New value for the property.
         */
        public Builder setPrevSyncStatus(java.lang.String prevSyncStatus) {
            this.prevSyncStatus = prevSyncStatus;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_IDLE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_FULL_SYNC}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_DELTA_SYNC}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_SELECTIVE_FULL_SYNC}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.DirectoryDomainSyncStats#PREV_SYNC_TYPE_SELECTIVE_DELTA_SYNC}</li>
         * </ul> Directory domain previous sync type. It could be one of the following five
         * states. Right after the directory domain is configured, this field is set to
         * IDLE.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param prevSyncType New value for the property.
         */
        public Builder setPrevSyncType(java.lang.String prevSyncType) {
            this.prevSyncType = prevSyncType;
            return this;
        }

        public DirectoryDomainSyncStats build() {
            DirectoryDomainSyncStats result = new DirectoryDomainSyncStats();
            result.setAvgDeltaSyncTime(this.avgDeltaSyncTime);
            result.setAvgFullSyncTime(this.avgFullSyncTime);
            result.setCurrentState(this.currentState);
            result.setCurrentStateBeginTime(this.currentStateBeginTime);
            result.setNumDeltaSync(this.numDeltaSync);
            result.setNumFullSync(this.numFullSync);
            result.setPrevSyncEndTime(this.prevSyncEndTime);
            result.setPrevSyncError(this.prevSyncError);
            result.setPrevSyncStatus(this.prevSyncStatus);
            result.setPrevSyncType(this.prevSyncType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("avg_delta_sync_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("avg_delta_sync_time",
                                                                                "avgDeltaSyncTime",
                                                                                "getAvgDeltaSyncTime",
                                                                                "setAvgDeltaSyncTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("avg_full_sync_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("avg_full_sync_time",
                                                                                "avgFullSyncTime",
                                                                                "getAvgFullSyncTime",
                                                                                "setAvgFullSyncTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_state",
                                                                                "currentState",
                                                                                "getCurrentState",
                                                                                "setCurrentState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_state_begin_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_state_begin_time",
                                                                                "currentStateBeginTime",
                                                                                "getCurrentStateBeginTime",
                                                                                "setCurrentStateBeginTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("num_delta_sync", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_delta_sync",
                                                                                "numDeltaSync",
                                                                                "getNumDeltaSync",
                                                                                "setNumDeltaSync");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("num_full_sync", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_full_sync",
                                                                                "numFullSync",
                                                                                "getNumFullSync",
                                                                                "setNumFullSync");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prev_sync_end_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prev_sync_end_time",
                                                                                "prevSyncEndTime",
                                                                                "getPrevSyncEndTime",
                                                                                "setPrevSyncEndTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prev_sync_error", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prev_sync_error",
                                                                                "prevSyncError",
                                                                                "getPrevSyncError",
                                                                                "setPrevSyncError");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prev_sync_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prev_sync_status",
                                                                                "prevSyncStatus",
                                                                                "getPrevSyncStatus",
                                                                                "setPrevSyncStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prev_sync_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prev_sync_type",
                                                                                "prevSyncType",
                                                                                "getPrevSyncType",
                                                                                "setPrevSyncType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.directory_domain_sync_stats",
                                                            fields,
                                                            com.vmware.nsx_policy.model.DirectoryDomainSyncStats.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

