/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * The Event is the criterion or criteria applied to the source and, when met,
 * prompt Policy to run the action. All Reaction Events are constructed with
 * reference to the object, the \"source\", that is logically deemed to be the
 * object upon which the Event in question initially occurred upon. Some example
 * events include: - New object was created. - Change in realization state. -
 * Specific API is called.
 */
public final class Event implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.nsx_policy.model.Criterion> criteria;

    private com.vmware.vapi.bindings.Structure source;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public Event() {
    }

    protected Event(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Criteria applied to the source and, if satisfied, would trigger the action.
     * Criteria is composed of criterions. In order for the Criteria to be met, only
     * one of the criterion must be fulfilled (implicit OR).
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Criterion> getCriteria() {
        return this.criteria;
    }

    /**
     * Criteria applied to the source and, if satisfied, would trigger the action.
     * Criteria is composed of criterions. In order for the Criteria to be met, only
     * one of the criterion must be fulfilled (implicit OR).
     *
     * @param criteria New value for the property.
     */
    public void setCriteria(java.util.List<com.vmware.nsx_policy.model.Criterion> criteria) {
        this.criteria = criteria;
    }

    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.Source}. When methods return a value of this class
     * as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx_policy.model.Source}.
     */
    public com.vmware.vapi.bindings.Structure getSource() {
        return this.source;
    }

    /**
     *
     *
     * @param source New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.Source}. When methods return a value of this class
     * as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx_policy.model.Source}.
     */
    public void setSource(com.vmware.vapi.bindings.Structure source) {
        this.source = source;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.event;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("criteria",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.criteria, this._getType().getField("criteria")));
        structValue.setField("source",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.source, this._getType().getField("source")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.event;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.event.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Event _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Event(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Event _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Event(structValue);
    }

    /**
     * Builder class for {@link Event}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.Criterion> criteria;
        private com.vmware.vapi.bindings.Structure source;

        /**
         * Constructor with parameters for the required properties of
         * {@link Event}.
         */
        public Builder() {
        }

        /**
         * Criteria applied to the source and, if satisfied, would trigger the action.
         * Criteria is composed of criterions. In order for the Criteria to be met, only
         * one of the criterion must be fulfilled (implicit OR).
         *
         * @param criteria New value for the property.
         */
        public Builder setCriteria(java.util.List<com.vmware.nsx_policy.model.Criterion> criteria) {
            this.criteria = criteria;
            return this;
        }

        /**
         *
         *
         * @param source New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.Source}. When methods return a value of this class
         * as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx_policy.model.Source}.
         */
        public Builder setSource(com.vmware.vapi.bindings.Structure source) {
            this.source = source;
            return this;
        }

        public Event build() {
            Event result = new Event();
            result.setCriteria(this.criteria);
            result.setSource(this.source);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("criteria", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.criterion; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("criteria",
                                                                                "criteria",
                                                                                "getCriteria",
                                                                                "setCriteria");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.source; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source",
                                                                                "source",
                                                                                "getSource",
                                                                                "setSource");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.event",
                                                            fields,
                                                            com.vmware.nsx_policy.model.Event.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

