/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Provides insights into details of a specific queue in the flows. For example
 * Global Manager to Local Manager flow, there is a queue on the Global Manager for
 * sending and a queue on Local Manager for receiving.
 */
public final class FederationQueueInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String TYPE_TRANSMITTER = "TRANSMITTER";

    public static final java.lang.String TYPE_RECEIVER = "RECEIVER";

    private java.lang.Long currentSize;

    private java.lang.Long maxSize;

    private java.lang.String name;

    private java.lang.String namespace;

    private java.lang.String type;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public FederationQueueInfo() {
    }

    protected FederationQueueInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Number of messages in the queue format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentSize() {
        return this.currentSize;
    }

    /**
     * Number of messages in the queue format: int64
     *
     * @param currentSize New value for the property.
     */
    public void setCurrentSize(java.lang.Long currentSize) {
        this.currentSize = currentSize;
    }

    /**
     * Maixmum capacity of the queue format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxSize() {
        return this.maxSize;
    }

    /**
     * Maixmum capacity of the queue format: int64
     *
     * @param maxSize New value for the property.
     */
    public void setMaxSize(java.lang.Long maxSize) {
        this.maxSize = maxSize;
    }

    /**
     * Queue name
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Queue name
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Every persistent queue has name and namespace. For more debugging like dumping
     * queue, namespace is needed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNamespace() {
        return this.namespace;
    }

    /**
     * Every persistent queue has name and namespace. For more debugging like dumping
     * queue, namespace is needed.
     *
     * @param namespace New value for the property.
     */
    public void setNamespace(java.lang.String namespace) {
        this.namespace = namespace;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.FederationQueueInfo#TYPE_TRANSMITTER}</li> <li>
     * {@link com.vmware.nsx_policy.model.FederationQueueInfo#TYPE_RECEIVER}</li> </ul>
     * Queue type - sender or receiver side
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.FederationQueueInfo#TYPE_TRANSMITTER}</li> <li>
     * {@link com.vmware.nsx_policy.model.FederationQueueInfo#TYPE_RECEIVER}</li> </ul>
     * Queue type - sender or receiver side
     *
     * @param type New value for the property.
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.federationQueueInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("current_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentSize, this._getType().getField("current_size")));
        structValue.setField("max_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxSize, this._getType().getField("max_size")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("namespace",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.namespace, this._getType().getField("namespace")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.federationQueueInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.federationQueueInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static FederationQueueInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new FederationQueueInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static FederationQueueInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new FederationQueueInfo(structValue);
    }

    /**
     * Builder class for {@link FederationQueueInfo}.
     */
    public static final class Builder {
        private java.lang.Long currentSize;
        private java.lang.Long maxSize;
        private java.lang.String name;
        private java.lang.String namespace;
        private java.lang.String type;

        /**
         * Constructor with parameters for the required properties of
         * {@link FederationQueueInfo}.
         */
        public Builder() {
        }

        /**
         * Number of messages in the queue format: int64
         *
         * @param currentSize New value for the property.
         */
        public Builder setCurrentSize(java.lang.Long currentSize) {
            this.currentSize = currentSize;
            return this;
        }

        /**
         * Maixmum capacity of the queue format: int64
         *
         * @param maxSize New value for the property.
         */
        public Builder setMaxSize(java.lang.Long maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        /**
         * Queue name
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Every persistent queue has name and namespace. For more debugging like dumping
         * queue, namespace is needed.
         *
         * @param namespace New value for the property.
         */
        public Builder setNamespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.FederationQueueInfo#TYPE_TRANSMITTER}</li> <li>
         * {@link com.vmware.nsx_policy.model.FederationQueueInfo#TYPE_RECEIVER}</li> </ul>
         * Queue type - sender or receiver side
         *
         * @param type New value for the property.
         */
        public Builder setType(java.lang.String type) {
            this.type = type;
            return this;
        }

        public FederationQueueInfo build() {
            FederationQueueInfo result = new FederationQueueInfo();
            result.setCurrentSize(this.currentSize);
            result.setMaxSize(this.maxSize);
            result.setName(this.name);
            result.setNamespace(this.namespace);
            result.setType(this.type);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("current_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_size",
                                                                                "currentSize",
                                                                                "getCurrentSize",
                                                                                "setCurrentSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_size",
                                                                                "maxSize",
                                                                                "getMaxSize",
                                                                                "setMaxSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("namespace", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("namespace",
                                                                                "namespace",
                                                                                "getNamespace",
                                                                                "setNamespace");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.federation_queue_info",
                                                            fields,
                                                            com.vmware.nsx_policy.model.FederationQueueInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

