/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Header of a widget that provides additional information. This will be shown at
 * the container level. It includes details as label value pairs.
 */
public final class Header implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CONTENT_ALIGNMENT_LEFT = "LEFT";

    public static final java.lang.String CONTENT_ALIGNMENT_RIGHT = "RIGHT";

    private java.lang.String condition;

    private java.lang.String contentAlignment;

    private java.util.List<com.vmware.nsx_policy.model.WidgetItem> subHeaderWidgets;

    private java.util.List<com.vmware.nsx_policy.model.PropertyItem> subHeaders;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public Header() {
    }

    protected Header(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * If the condition is met then the header will be applied. Examples of expression
     * syntax are provided under 'example_request' section of
     * 'CreateWidgetConfiguration' API.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCondition() {
        return this.condition;
    }

    /**
     * If the condition is met then the header will be applied. Examples of expression
     * syntax are provided under 'example_request' section of
     * 'CreateWidgetConfiguration' API.
     *
     * @param condition New value for the property.
     */
    public void setCondition(java.lang.String condition) {
        this.condition = condition;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.Header#CONTENT_ALIGNMENT_LEFT}</li> <li> {@link
     * com.vmware.nsx_policy.model.Header#CONTENT_ALIGNMENT_RIGHT}</li> </ul> Alignment
     * of header labels.
     *
     * @return The current value of the property.
     */
    public java.lang.String getContentAlignment() {
        return this.contentAlignment;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.Header#CONTENT_ALIGNMENT_LEFT}</li> <li> {@link
     * com.vmware.nsx_policy.model.Header#CONTENT_ALIGNMENT_RIGHT}</li> </ul> Alignment
     * of header labels.
     *
     * @param contentAlignment New value for the property.
     */
    public void setContentAlignment(java.lang.String contentAlignment) {
        this.contentAlignment = contentAlignment;
    }

    /**
     * An array of widgets which will appear inside the container header Instead of
     * 'sub_headers' property use this property.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.WidgetItem> getSubHeaderWidgets() {
        return this.subHeaderWidgets;
    }

    /**
     * An array of widgets which will appear inside the container header Instead of
     * 'sub_headers' property use this property.
     *
     * @param subHeaderWidgets New value for the property.
     */
    public void setSubHeaderWidgets(java.util.List<com.vmware.nsx_policy.model.WidgetItem> subHeaderWidgets) {
        this.subHeaderWidgets = subHeaderWidgets;
    }

    /**
     * An array of label-value properties. This field is deprecated instead used
     * 'sub_header_widgets' property to define header widgets.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx_policy.model.PropertyItem> getSubHeaders() {
        return this.subHeaders;
    }

    /**
     * An array of label-value properties. This field is deprecated instead used
     * 'sub_header_widgets' property to define header widgets.
     *
     * @param subHeaders New value for the property.
     */
    @Deprecated
    public void setSubHeaders(java.util.List<com.vmware.nsx_policy.model.PropertyItem> subHeaders) {
        this.subHeaders = subHeaders;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.header;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("condition",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.condition, this._getType().getField("condition")));
        structValue.setField("content_alignment",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.contentAlignment, this._getType().getField("content_alignment")));
        structValue.setField("sub_header_widgets",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subHeaderWidgets, this._getType().getField("sub_header_widgets")));
        structValue.setField("sub_headers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subHeaders, this._getType().getField("sub_headers")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.header;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.header.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Header _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Header(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Header _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Header(structValue);
    }

    /**
     * Builder class for {@link Header}.
     */
    public static final class Builder {
        private java.lang.String condition;
        private java.lang.String contentAlignment;
        private java.util.List<com.vmware.nsx_policy.model.WidgetItem> subHeaderWidgets;
        private java.util.List<com.vmware.nsx_policy.model.PropertyItem> subHeaders;

        /**
         * Constructor with parameters for the required properties of
         * {@link Header}.
         */
        public Builder() {
        }

        /**
         * If the condition is met then the header will be applied. Examples of expression
         * syntax are provided under 'example_request' section of
         * 'CreateWidgetConfiguration' API.
         *
         * @param condition New value for the property.
         */
        public Builder setCondition(java.lang.String condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.Header#CONTENT_ALIGNMENT_LEFT}</li> <li> {@link
         * com.vmware.nsx_policy.model.Header#CONTENT_ALIGNMENT_RIGHT}</li> </ul> Alignment
         * of header labels.
         *
         * @param contentAlignment New value for the property.
         */
        public Builder setContentAlignment(java.lang.String contentAlignment) {
            this.contentAlignment = contentAlignment;
            return this;
        }

        /**
         * An array of widgets which will appear inside the container header Instead of
         * 'sub_headers' property use this property.
         *
         * @param subHeaderWidgets New value for the property.
         */
        public Builder setSubHeaderWidgets(java.util.List<com.vmware.nsx_policy.model.WidgetItem> subHeaderWidgets) {
            this.subHeaderWidgets = subHeaderWidgets;
            return this;
        }

        /**
         * An array of label-value properties. This field is deprecated instead used
         * 'sub_header_widgets' property to define header widgets.
         *
         * @param subHeaders New value for the property.
         */
        public Builder setSubHeaders(java.util.List<com.vmware.nsx_policy.model.PropertyItem> subHeaders) {
            this.subHeaders = subHeaders;
            return this;
        }

        public Header build() {
            Header result = new Header();
            result.setCondition(this.condition);
            result.setContentAlignment(this.contentAlignment);
            result.setSubHeaderWidgets(this.subHeaderWidgets);
            result.setSubHeaders(this.subHeaders);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("condition", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("condition",
                                                                                "condition",
                                                                                "getCondition",
                                                                                "setCondition");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("content_alignment", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("content_alignment",
                                                                                "contentAlignment",
                                                                                "getContentAlignment",
                                                                                "setContentAlignment");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sub_header_widgets", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.widgetItem; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sub_header_widgets",
                                                                                "subHeaderWidgets",
                                                                                "getSubHeaderWidgets",
                                                                                "setSubHeaderWidgets");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sub_headers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.propertyItem; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sub_headers",
                                                                                "subHeaders",
                                                                                "getSubHeaders",
                                                                                "setSubHeaders");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.header",
                                                            fields,
                                                            com.vmware.nsx_policy.model.Header.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

