/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Intersite gateway configuration.
 */
public final class IntersiteGatewayConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<java.lang.String> fallbackSites;

    private java.lang.String intersiteTransitSubnet;

    private java.lang.Long lastAdminActiveEpoch;

    private java.lang.String primarySitePath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IntersiteGatewayConfig() {
    }

    protected IntersiteGatewayConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Fallback site to be used as new primary site on current primary site failure.
     * Disaster recovery must be initiated via API/UI. Fallback site configuration is
     * supported only for T0 gateway. T1 gateway will follow T0 gateway's primary site
     * during disaster recovery.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getFallbackSites() {
        return this.fallbackSites;
    }

    /**
     * Fallback site to be used as new primary site on current primary site failure.
     * Disaster recovery must be initiated via API/UI. Fallback site configuration is
     * supported only for T0 gateway. T1 gateway will follow T0 gateway's primary site
     * during disaster recovery.
     *
     * @param fallbackSites New value for the property.
     */
    public void setFallbackSites(java.util.List<java.lang.String> fallbackSites) {
        this.fallbackSites = fallbackSites;
    }

    /**
     * IPv4 subnet for inter-site transit segment connecting service routers across
     * sites for stretched gateway. For IPv6 link local subnet is auto configured.
     * format: ip-cidr-block
     *
     * @return The current value of the property.
     */
    public java.lang.String getIntersiteTransitSubnet() {
        return this.intersiteTransitSubnet;
    }

    /**
     * IPv4 subnet for inter-site transit segment connecting service routers across
     * sites for stretched gateway. For IPv6 link local subnet is auto configured.
     * format: ip-cidr-block
     *
     * @param intersiteTransitSubnet New value for the property.
     */
    public void setIntersiteTransitSubnet(java.lang.String intersiteTransitSubnet) {
        this.intersiteTransitSubnet = intersiteTransitSubnet;
    }

    /**
     * Epoch(in seconds) is auto updated based on system current timestamp when primary
     * locale service is updated. It is used for resolving conflict during site
     * failover. If system clock not in sync then User can optionally override this.
     * New value must be higher than the current value. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastAdminActiveEpoch() {
        return this.lastAdminActiveEpoch;
    }

    /**
     * Epoch(in seconds) is auto updated based on system current timestamp when primary
     * locale service is updated. It is used for resolving conflict during site
     * failover. If system clock not in sync then User can optionally override this.
     * New value must be higher than the current value. format: int64
     *
     * @param lastAdminActiveEpoch New value for the property.
     */
    public void setLastAdminActiveEpoch(java.lang.Long lastAdminActiveEpoch) {
        this.lastAdminActiveEpoch = lastAdminActiveEpoch;
    }

    /**
     * Primary egress site for gateway. T0/T1 gateway in Active/Standby mode supports
     * stateful services on primary site. In this mode primary site must be set if
     * gateway is stretched to more than one site. For T0 gateway in Active/Active
     * primary site is optional field. If set then secondary site prefers routes
     * learned from primary over locally learned routes. This field is not applicable
     * for T1 gateway with no services.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrimarySitePath() {
        return this.primarySitePath;
    }

    /**
     * Primary egress site for gateway. T0/T1 gateway in Active/Standby mode supports
     * stateful services on primary site. In this mode primary site must be set if
     * gateway is stretched to more than one site. For T0 gateway in Active/Active
     * primary site is optional field. If set then secondary site prefers routes
     * learned from primary over locally learned routes. This field is not applicable
     * for T1 gateway with no services.
     *
     * @param primarySitePath New value for the property.
     */
    public void setPrimarySitePath(java.lang.String primarySitePath) {
        this.primarySitePath = primarySitePath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.intersiteGatewayConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("fallback_sites",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fallbackSites, this._getType().getField("fallback_sites")));
        structValue.setField("intersite_transit_subnet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.intersiteTransitSubnet, this._getType().getField("intersite_transit_subnet")));
        structValue.setField("last_admin_active_epoch",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastAdminActiveEpoch, this._getType().getField("last_admin_active_epoch")));
        structValue.setField("primary_site_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.primarySitePath, this._getType().getField("primary_site_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.intersiteGatewayConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.intersiteGatewayConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IntersiteGatewayConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IntersiteGatewayConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IntersiteGatewayConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IntersiteGatewayConfig(structValue);
    }

    /**
     * Builder class for {@link IntersiteGatewayConfig}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> fallbackSites;
        private java.lang.String intersiteTransitSubnet;
        private java.lang.Long lastAdminActiveEpoch;
        private java.lang.String primarySitePath;

        /**
         * Constructor with parameters for the required properties of
         * {@link IntersiteGatewayConfig}.
         */
        public Builder() {
        }

        /**
         * Fallback site to be used as new primary site on current primary site failure.
         * Disaster recovery must be initiated via API/UI. Fallback site configuration is
         * supported only for T0 gateway. T1 gateway will follow T0 gateway's primary site
         * during disaster recovery.
         *
         * @param fallbackSites New value for the property.
         */
        public Builder setFallbackSites(java.util.List<java.lang.String> fallbackSites) {
            this.fallbackSites = fallbackSites;
            return this;
        }

        /**
         * IPv4 subnet for inter-site transit segment connecting service routers across
         * sites for stretched gateway. For IPv6 link local subnet is auto configured.
         * format: ip-cidr-block
         *
         * @param intersiteTransitSubnet New value for the property.
         */
        public Builder setIntersiteTransitSubnet(java.lang.String intersiteTransitSubnet) {
            this.intersiteTransitSubnet = intersiteTransitSubnet;
            return this;
        }

        /**
         * Epoch(in seconds) is auto updated based on system current timestamp when primary
         * locale service is updated. It is used for resolving conflict during site
         * failover. If system clock not in sync then User can optionally override this.
         * New value must be higher than the current value. format: int64
         *
         * @param lastAdminActiveEpoch New value for the property.
         */
        public Builder setLastAdminActiveEpoch(java.lang.Long lastAdminActiveEpoch) {
            this.lastAdminActiveEpoch = lastAdminActiveEpoch;
            return this;
        }

        /**
         * Primary egress site for gateway. T0/T1 gateway in Active/Standby mode supports
         * stateful services on primary site. In this mode primary site must be set if
         * gateway is stretched to more than one site. For T0 gateway in Active/Active
         * primary site is optional field. If set then secondary site prefers routes
         * learned from primary over locally learned routes. This field is not applicable
         * for T1 gateway with no services.
         *
         * @param primarySitePath New value for the property.
         */
        public Builder setPrimarySitePath(java.lang.String primarySitePath) {
            this.primarySitePath = primarySitePath;
            return this;
        }

        public IntersiteGatewayConfig build() {
            IntersiteGatewayConfig result = new IntersiteGatewayConfig();
            result.setFallbackSites(this.fallbackSites);
            result.setIntersiteTransitSubnet(this.intersiteTransitSubnet);
            result.setLastAdminActiveEpoch(this.lastAdminActiveEpoch);
            result.setPrimarySitePath(this.primarySitePath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("fallback_sites", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fallback_sites",
                                                                                "fallbackSites",
                                                                                "getFallbackSites",
                                                                                "setFallbackSites");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("intersite_transit_subnet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("intersite_transit_subnet",
                                                                                "intersiteTransitSubnet",
                                                                                "getIntersiteTransitSubnet",
                                                                                "setIntersiteTransitSubnet");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_admin_active_epoch", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_admin_active_epoch",
                                                                                "lastAdminActiveEpoch",
                                                                                "getLastAdminActiveEpoch",
                                                                                "setLastAdminActiveEpoch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("primary_site_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("primary_site_path",
                                                                                "primarySitePath",
                                                                                "getPrimarySitePath",
                                                                                "setPrimarySitePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.intersite_gateway_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.IntersiteGatewayConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

