/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * The capacity contains basic information and load balancer entity usages and
 * capacity for the given edge node.
 */
public final class LBEdgeNodeUsage implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBEdgeNodeUsage";

    public static final java.lang.String FORM_FACTOR_SMALL_VIRTUAL_MACHINE = "SMALL_VIRTUAL_MACHINE";

    public static final java.lang.String FORM_FACTOR_MEDIUM_VIRTUAL_MACHINE = "MEDIUM_VIRTUAL_MACHINE";

    public static final java.lang.String FORM_FACTOR_LARGE_VIRTUAL_MACHINE = "LARGE_VIRTUAL_MACHINE";

    public static final java.lang.String FORM_FACTOR_XLARGE_VIRTUAL_MACHINE = "XLARGE_VIRTUAL_MACHINE";

    public static final java.lang.String FORM_FACTOR_PHYSICAL_MACHINE = "PHYSICAL_MACHINE";

    public static final java.lang.String SEVERITY_GREEN = "GREEN";

    public static final java.lang.String SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String SEVERITY_RED = "RED";

    private java.lang.Long currentLargeLoadBalancerCount;

    private java.lang.Long currentLoadBalancerCredits;

    private java.lang.Long currentMediumLoadBalancerCount;

    private java.lang.Long currentPoolCount;

    private java.lang.Long currentPoolMemberCount;

    private java.lang.Long currentSmallLoadBalancerCount;

    private java.lang.Long currentVirtualServerCount;

    private java.lang.Long currentXlargeLoadBalancerCount;

    private java.lang.String edgeClusterPath;

    private java.lang.String formFactor;

    private java.lang.Long loadBalancerCreditCapacity;

    private java.lang.Long poolMemberCapacity;

    private java.lang.Long remainingLargeLoadBalancerCount;

    private java.lang.Long remainingMediumLoadBalancerCount;

    private java.lang.Long remainingSmallLoadBalancerCount;

    private java.lang.Long remainingXlargeLoadBalancerCount;

    private java.lang.String severity;

    private java.lang.Double usagePercentage;

    private java.lang.String nodePath;

    private final java.lang.String resourceType = "LBEdgeNodeUsage";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBEdgeNodeUsage() {
    }

    protected LBEdgeNodeUsage(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The count of large load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentLargeLoadBalancerCount() {
        return this.currentLargeLoadBalancerCount;
    }

    /**
     * The count of large load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentLargeLoadBalancerCount New value for the property.
     */
    public void setCurrentLargeLoadBalancerCount(java.lang.Long currentLargeLoadBalancerCount) {
        this.currentLargeLoadBalancerCount = currentLargeLoadBalancerCount;
    }

    /**
     * The current load balancer credits means the current credits used on the node.
     * For example, configuring a medium load balancer on a node consumes 10 credits.
     * If there are 2 medium instances configured on a node, the current credit number
     * is 2 * 10 = 20. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentLoadBalancerCredits() {
        return this.currentLoadBalancerCredits;
    }

    /**
     * The current load balancer credits means the current credits used on the node.
     * For example, configuring a medium load balancer on a node consumes 10 credits.
     * If there are 2 medium instances configured on a node, the current credit number
     * is 2 * 10 = 20. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentLoadBalancerCredits New value for the property.
     */
    public void setCurrentLoadBalancerCredits(java.lang.Long currentLoadBalancerCredits) {
        this.currentLoadBalancerCredits = currentLoadBalancerCredits;
    }

    /**
     * The count of medium load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentMediumLoadBalancerCount() {
        return this.currentMediumLoadBalancerCount;
    }

    /**
     * The count of medium load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentMediumLoadBalancerCount New value for the property.
     */
    public void setCurrentMediumLoadBalancerCount(java.lang.Long currentMediumLoadBalancerCount) {
        this.currentMediumLoadBalancerCount = currentMediumLoadBalancerCount;
    }

    /**
     * The count of pools configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolCount() {
        return this.currentPoolCount;
    }

    /**
     * The count of pools configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolCount New value for the property.
     */
    public void setCurrentPoolCount(java.lang.Long currentPoolCount) {
        this.currentPoolCount = currentPoolCount;
    }

    /**
     * The count of pool members configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolMemberCount() {
        return this.currentPoolMemberCount;
    }

    /**
     * The count of pool members configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolMemberCount New value for the property.
     */
    public void setCurrentPoolMemberCount(java.lang.Long currentPoolMemberCount) {
        this.currentPoolMemberCount = currentPoolMemberCount;
    }

    /**
     * The count of small load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentSmallLoadBalancerCount() {
        return this.currentSmallLoadBalancerCount;
    }

    /**
     * The count of small load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentSmallLoadBalancerCount New value for the property.
     */
    public void setCurrentSmallLoadBalancerCount(java.lang.Long currentSmallLoadBalancerCount) {
        this.currentSmallLoadBalancerCount = currentSmallLoadBalancerCount;
    }

    /**
     * The count of virtual servers configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentVirtualServerCount() {
        return this.currentVirtualServerCount;
    }

    /**
     * The count of virtual servers configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentVirtualServerCount New value for the property.
     */
    public void setCurrentVirtualServerCount(java.lang.Long currentVirtualServerCount) {
        this.currentVirtualServerCount = currentVirtualServerCount;
    }

    /**
     * The count of xlarge load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentXlargeLoadBalancerCount() {
        return this.currentXlargeLoadBalancerCount;
    }

    /**
     * The count of xlarge load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentXlargeLoadBalancerCount New value for the property.
     */
    public void setCurrentXlargeLoadBalancerCount(java.lang.Long currentXlargeLoadBalancerCount) {
        this.currentXlargeLoadBalancerCount = currentXlargeLoadBalancerCount;
    }

    /**
     * The path of edge cluster which contains the edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEdgeClusterPath() {
        return this.edgeClusterPath;
    }

    /**
     * The path of edge cluster which contains the edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param edgeClusterPath New value for the property.
     */
    public void setEdgeClusterPath(java.lang.String edgeClusterPath) {
        this.edgeClusterPath = edgeClusterPath;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_SMALL_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_MEDIUM_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_LARGE_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_XLARGE_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_PHYSICAL_MACHINE}</li>
     * </ul> The form factor of the given edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFormFactor() {
        return this.formFactor;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_SMALL_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_MEDIUM_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_LARGE_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_XLARGE_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_PHYSICAL_MACHINE}</li>
     * </ul> The form factor of the given edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param formFactor New value for the property.
     */
    public void setFormFactor(java.lang.String formFactor) {
        this.formFactor = formFactor;
    }

    /**
     * The load balancer credit capacity means the maximum credits which can be used
     * for load balancer configuration for the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLoadBalancerCreditCapacity() {
        return this.loadBalancerCreditCapacity;
    }

    /**
     * The load balancer credit capacity means the maximum credits which can be used
     * for load balancer configuration for the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param loadBalancerCreditCapacity New value for the property.
     */
    public void setLoadBalancerCreditCapacity(java.lang.Long loadBalancerCreditCapacity) {
        this.loadBalancerCreditCapacity = loadBalancerCreditCapacity;
    }

    /**
     * Pool member capacity means maximum number of pool members which can be
     * configured on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPoolMemberCapacity() {
        return this.poolMemberCapacity;
    }

    /**
     * Pool member capacity means maximum number of pool members which can be
     * configured on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolMemberCapacity New value for the property.
     */
    public void setPoolMemberCapacity(java.lang.Long poolMemberCapacity) {
        this.poolMemberCapacity = poolMemberCapacity;
    }

    /**
     * The remaining count of large load balancer services which can be configured on
     * the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingLargeLoadBalancerCount() {
        return this.remainingLargeLoadBalancerCount;
    }

    /**
     * The remaining count of large load balancer services which can be configured on
     * the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingLargeLoadBalancerCount New value for the property.
     */
    public void setRemainingLargeLoadBalancerCount(java.lang.Long remainingLargeLoadBalancerCount) {
        this.remainingLargeLoadBalancerCount = remainingLargeLoadBalancerCount;
    }

    /**
     * The remaining count of medium load balancer services which can be configured on
     * the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingMediumLoadBalancerCount() {
        return this.remainingMediumLoadBalancerCount;
    }

    /**
     * The remaining count of medium load balancer services which can be configured on
     * the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingMediumLoadBalancerCount New value for the property.
     */
    public void setRemainingMediumLoadBalancerCount(java.lang.Long remainingMediumLoadBalancerCount) {
        this.remainingMediumLoadBalancerCount = remainingMediumLoadBalancerCount;
    }

    /**
     * The remaining count of small load balancer services which can be configured on
     * the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingSmallLoadBalancerCount() {
        return this.remainingSmallLoadBalancerCount;
    }

    /**
     * The remaining count of small load balancer services which can be configured on
     * the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingSmallLoadBalancerCount New value for the property.
     */
    public void setRemainingSmallLoadBalancerCount(java.lang.Long remainingSmallLoadBalancerCount) {
        this.remainingSmallLoadBalancerCount = remainingSmallLoadBalancerCount;
    }

    /**
     * The remaining count of xlarge load balancer services which can be configured on
     * the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingXlargeLoadBalancerCount() {
        return this.remainingXlargeLoadBalancerCount;
    }

    /**
     * The remaining count of xlarge load balancer services which can be configured on
     * the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingXlargeLoadBalancerCount New value for the property.
     */
    public void setRemainingXlargeLoadBalancerCount(java.lang.Long remainingXlargeLoadBalancerCount) {
        this.remainingXlargeLoadBalancerCount = remainingXlargeLoadBalancerCount;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_RED}</li> </ul> The
     * severity calculation is based on current credit usage percentage of load
     * balancer for one node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSeverity() {
        return this.severity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_RED}</li> </ul> The
     * severity calculation is based on current credit usage percentage of load
     * balancer for one node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param severity New value for the property.
     */
    public void setSeverity(java.lang.String severity) {
        this.severity = severity;
    }

    /**
     * The usage percentage of the edge node for load balancer. The value is the larger
     * value between load balancer credit usage percentage and pool member usage
     * percentage for the edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getUsagePercentage() {
        return this.usagePercentage;
    }

    /**
     * The usage percentage of the edge node for load balancer. The value is the larger
     * value between load balancer credit usage percentage and pool member usage
     * percentage for the edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param usagePercentage New value for the property.
     */
    public void setUsagePercentage(java.lang.Double usagePercentage) {
        this.usagePercentage = usagePercentage;
    }

    /**
     * The property identifies the node path for load balancer node usage. For example,
     * node_path=/infra/sites/default/enforcement-points/default
     * /edge-clusters/85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes
     * /86e077c0-449f-11e9-87c8-02004eb37029.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNodePath() {
        return this.nodePath;
    }

    /**
     * The property identifies the node path for load balancer node usage. For example,
     * node_path=/infra/sites/default/enforcement-points/default
     * /edge-clusters/85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes
     * /86e077c0-449f-11e9-87c8-02004eb37029.
     *
     * @param nodePath New value for the property.
     */
    public void setNodePath(java.lang.String nodePath) {
        this.nodePath = nodePath;
    }

    /**
     * The property identifies the load balancer node usage type.
     * The value of this property is automatically populated to {@code "LBEdgeNodeUsage"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBEdgeNodeUsage;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("current_large_load_balancer_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentLargeLoadBalancerCount, this._getType().getField("current_large_load_balancer_count")));
        structValue.setField("current_load_balancer_credits",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentLoadBalancerCredits, this._getType().getField("current_load_balancer_credits")));
        structValue.setField("current_medium_load_balancer_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentMediumLoadBalancerCount, this._getType().getField("current_medium_load_balancer_count")));
        structValue.setField("current_pool_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolCount, this._getType().getField("current_pool_count")));
        structValue.setField("current_pool_member_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolMemberCount, this._getType().getField("current_pool_member_count")));
        structValue.setField("current_small_load_balancer_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentSmallLoadBalancerCount, this._getType().getField("current_small_load_balancer_count")));
        structValue.setField("current_virtual_server_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentVirtualServerCount, this._getType().getField("current_virtual_server_count")));
        structValue.setField("current_xlarge_load_balancer_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentXlargeLoadBalancerCount, this._getType().getField("current_xlarge_load_balancer_count")));
        structValue.setField("edge_cluster_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.edgeClusterPath, this._getType().getField("edge_cluster_path")));
        structValue.setField("form_factor",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.formFactor, this._getType().getField("form_factor")));
        structValue.setField("load_balancer_credit_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.loadBalancerCreditCapacity, this._getType().getField("load_balancer_credit_capacity")));
        structValue.setField("pool_member_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolMemberCapacity, this._getType().getField("pool_member_capacity")));
        structValue.setField("remaining_large_load_balancer_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingLargeLoadBalancerCount, this._getType().getField("remaining_large_load_balancer_count")));
        structValue.setField("remaining_medium_load_balancer_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingMediumLoadBalancerCount, this._getType().getField("remaining_medium_load_balancer_count")));
        structValue.setField("remaining_small_load_balancer_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingSmallLoadBalancerCount, this._getType().getField("remaining_small_load_balancer_count")));
        structValue.setField("remaining_xlarge_load_balancer_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingXlargeLoadBalancerCount, this._getType().getField("remaining_xlarge_load_balancer_count")));
        structValue.setField("severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.severity, this._getType().getField("severity")));
        structValue.setField("usage_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.usagePercentage, this._getType().getField("usage_percentage")));
        structValue.setField("node_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodePath, this._getType().getField("node_path")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBEdgeNodeUsage;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBEdgeNodeUsage.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBEdgeNodeUsage _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBEdgeNodeUsage(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBEdgeNodeUsage _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBEdgeNodeUsage(structValue);
    }

    /**
     * Builder class for {@link LBEdgeNodeUsage}.
     */
    public static final class Builder {
        private java.lang.Long currentLargeLoadBalancerCount;
        private java.lang.Long currentLoadBalancerCredits;
        private java.lang.Long currentMediumLoadBalancerCount;
        private java.lang.Long currentPoolCount;
        private java.lang.Long currentPoolMemberCount;
        private java.lang.Long currentSmallLoadBalancerCount;
        private java.lang.Long currentVirtualServerCount;
        private java.lang.Long currentXlargeLoadBalancerCount;
        private java.lang.String edgeClusterPath;
        private java.lang.String formFactor;
        private java.lang.Long loadBalancerCreditCapacity;
        private java.lang.Long poolMemberCapacity;
        private java.lang.Long remainingLargeLoadBalancerCount;
        private java.lang.Long remainingMediumLoadBalancerCount;
        private java.lang.Long remainingSmallLoadBalancerCount;
        private java.lang.Long remainingXlargeLoadBalancerCount;
        private java.lang.String severity;
        private java.lang.Double usagePercentage;
        private java.lang.String nodePath;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBEdgeNodeUsage}.
         */
        public Builder() {
        }

        /**
         * The count of large load balancer services configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentLargeLoadBalancerCount New value for the property.
         */
        public Builder setCurrentLargeLoadBalancerCount(java.lang.Long currentLargeLoadBalancerCount) {
            this.currentLargeLoadBalancerCount = currentLargeLoadBalancerCount;
            return this;
        }

        /**
         * The current load balancer credits means the current credits used on the node.
         * For example, configuring a medium load balancer on a node consumes 10 credits.
         * If there are 2 medium instances configured on a node, the current credit number
         * is 2 * 10 = 20. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentLoadBalancerCredits New value for the property.
         */
        public Builder setCurrentLoadBalancerCredits(java.lang.Long currentLoadBalancerCredits) {
            this.currentLoadBalancerCredits = currentLoadBalancerCredits;
            return this;
        }

        /**
         * The count of medium load balancer services configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentMediumLoadBalancerCount New value for the property.
         */
        public Builder setCurrentMediumLoadBalancerCount(java.lang.Long currentMediumLoadBalancerCount) {
            this.currentMediumLoadBalancerCount = currentMediumLoadBalancerCount;
            return this;
        }

        /**
         * The count of pools configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolCount New value for the property.
         */
        public Builder setCurrentPoolCount(java.lang.Long currentPoolCount) {
            this.currentPoolCount = currentPoolCount;
            return this;
        }

        /**
         * The count of pool members configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolMemberCount New value for the property.
         */
        public Builder setCurrentPoolMemberCount(java.lang.Long currentPoolMemberCount) {
            this.currentPoolMemberCount = currentPoolMemberCount;
            return this;
        }

        /**
         * The count of small load balancer services configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentSmallLoadBalancerCount New value for the property.
         */
        public Builder setCurrentSmallLoadBalancerCount(java.lang.Long currentSmallLoadBalancerCount) {
            this.currentSmallLoadBalancerCount = currentSmallLoadBalancerCount;
            return this;
        }

        /**
         * The count of virtual servers configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentVirtualServerCount New value for the property.
         */
        public Builder setCurrentVirtualServerCount(java.lang.Long currentVirtualServerCount) {
            this.currentVirtualServerCount = currentVirtualServerCount;
            return this;
        }

        /**
         * The count of xlarge load balancer services configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentXlargeLoadBalancerCount New value for the property.
         */
        public Builder setCurrentXlargeLoadBalancerCount(java.lang.Long currentXlargeLoadBalancerCount) {
            this.currentXlargeLoadBalancerCount = currentXlargeLoadBalancerCount;
            return this;
        }

        /**
         * The path of edge cluster which contains the edge node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param edgeClusterPath New value for the property.
         */
        public Builder setEdgeClusterPath(java.lang.String edgeClusterPath) {
            this.edgeClusterPath = edgeClusterPath;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_SMALL_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_MEDIUM_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_LARGE_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_XLARGE_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBEdgeNodeUsage#FORM_FACTOR_PHYSICAL_MACHINE}</li>
         * </ul> The form factor of the given edge node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param formFactor New value for the property.
         */
        public Builder setFormFactor(java.lang.String formFactor) {
            this.formFactor = formFactor;
            return this;
        }

        /**
         * The load balancer credit capacity means the maximum credits which can be used
         * for load balancer configuration for the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param loadBalancerCreditCapacity New value for the property.
         */
        public Builder setLoadBalancerCreditCapacity(java.lang.Long loadBalancerCreditCapacity) {
            this.loadBalancerCreditCapacity = loadBalancerCreditCapacity;
            return this;
        }

        /**
         * Pool member capacity means maximum number of pool members which can be
         * configured on the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolMemberCapacity New value for the property.
         */
        public Builder setPoolMemberCapacity(java.lang.Long poolMemberCapacity) {
            this.poolMemberCapacity = poolMemberCapacity;
            return this;
        }

        /**
         * The remaining count of large load balancer services which can be configured on
         * the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingLargeLoadBalancerCount New value for the property.
         */
        public Builder setRemainingLargeLoadBalancerCount(java.lang.Long remainingLargeLoadBalancerCount) {
            this.remainingLargeLoadBalancerCount = remainingLargeLoadBalancerCount;
            return this;
        }

        /**
         * The remaining count of medium load balancer services which can be configured on
         * the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingMediumLoadBalancerCount New value for the property.
         */
        public Builder setRemainingMediumLoadBalancerCount(java.lang.Long remainingMediumLoadBalancerCount) {
            this.remainingMediumLoadBalancerCount = remainingMediumLoadBalancerCount;
            return this;
        }

        /**
         * The remaining count of small load balancer services which can be configured on
         * the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingSmallLoadBalancerCount New value for the property.
         */
        public Builder setRemainingSmallLoadBalancerCount(java.lang.Long remainingSmallLoadBalancerCount) {
            this.remainingSmallLoadBalancerCount = remainingSmallLoadBalancerCount;
            return this;
        }

        /**
         * The remaining count of xlarge load balancer services which can be configured on
         * the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingXlargeLoadBalancerCount New value for the property.
         */
        public Builder setRemainingXlargeLoadBalancerCount(java.lang.Long remainingXlargeLoadBalancerCount) {
            this.remainingXlargeLoadBalancerCount = remainingXlargeLoadBalancerCount;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_GREEN}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_ORANGE}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBEdgeNodeUsage#SEVERITY_RED}</li> </ul> The
         * severity calculation is based on current credit usage percentage of load
         * balancer for one node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param severity New value for the property.
         */
        public Builder setSeverity(java.lang.String severity) {
            this.severity = severity;
            return this;
        }

        /**
         * The usage percentage of the edge node for load balancer. The value is the larger
         * value between load balancer credit usage percentage and pool member usage
         * percentage for the edge node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param usagePercentage New value for the property.
         */
        public Builder setUsagePercentage(java.lang.Double usagePercentage) {
            this.usagePercentage = usagePercentage;
            return this;
        }

        /**
         * The property identifies the node path for load balancer node usage. For example,
         * node_path=/infra/sites/default/enforcement-points/default
         * /edge-clusters/85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes
         * /86e077c0-449f-11e9-87c8-02004eb37029.
         *
         * @param nodePath New value for the property.
         */
        public Builder setNodePath(java.lang.String nodePath) {
            this.nodePath = nodePath;
            return this;
        }

        public LBEdgeNodeUsage build() {
            LBEdgeNodeUsage result = new LBEdgeNodeUsage();
            result.setCurrentLargeLoadBalancerCount(this.currentLargeLoadBalancerCount);
            result.setCurrentLoadBalancerCredits(this.currentLoadBalancerCredits);
            result.setCurrentMediumLoadBalancerCount(this.currentMediumLoadBalancerCount);
            result.setCurrentPoolCount(this.currentPoolCount);
            result.setCurrentPoolMemberCount(this.currentPoolMemberCount);
            result.setCurrentSmallLoadBalancerCount(this.currentSmallLoadBalancerCount);
            result.setCurrentVirtualServerCount(this.currentVirtualServerCount);
            result.setCurrentXlargeLoadBalancerCount(this.currentXlargeLoadBalancerCount);
            result.setEdgeClusterPath(this.edgeClusterPath);
            result.setFormFactor(this.formFactor);
            result.setLoadBalancerCreditCapacity(this.loadBalancerCreditCapacity);
            result.setPoolMemberCapacity(this.poolMemberCapacity);
            result.setRemainingLargeLoadBalancerCount(this.remainingLargeLoadBalancerCount);
            result.setRemainingMediumLoadBalancerCount(this.remainingMediumLoadBalancerCount);
            result.setRemainingSmallLoadBalancerCount(this.remainingSmallLoadBalancerCount);
            result.setRemainingXlargeLoadBalancerCount(this.remainingXlargeLoadBalancerCount);
            result.setSeverity(this.severity);
            result.setUsagePercentage(this.usagePercentage);
            result.setNodePath(this.nodePath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("current_large_load_balancer_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_large_load_balancer_count",
                                                                                "currentLargeLoadBalancerCount",
                                                                                "getCurrentLargeLoadBalancerCount",
                                                                                "setCurrentLargeLoadBalancerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_load_balancer_credits", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_load_balancer_credits",
                                                                                "currentLoadBalancerCredits",
                                                                                "getCurrentLoadBalancerCredits",
                                                                                "setCurrentLoadBalancerCredits");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_medium_load_balancer_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_medium_load_balancer_count",
                                                                                "currentMediumLoadBalancerCount",
                                                                                "getCurrentMediumLoadBalancerCount",
                                                                                "setCurrentMediumLoadBalancerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_pool_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_count",
                                                                                "currentPoolCount",
                                                                                "getCurrentPoolCount",
                                                                                "setCurrentPoolCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_pool_member_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_member_count",
                                                                                "currentPoolMemberCount",
                                                                                "getCurrentPoolMemberCount",
                                                                                "setCurrentPoolMemberCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_small_load_balancer_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_small_load_balancer_count",
                                                                                "currentSmallLoadBalancerCount",
                                                                                "getCurrentSmallLoadBalancerCount",
                                                                                "setCurrentSmallLoadBalancerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_virtual_server_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_virtual_server_count",
                                                                                "currentVirtualServerCount",
                                                                                "getCurrentVirtualServerCount",
                                                                                "setCurrentVirtualServerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_xlarge_load_balancer_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_xlarge_load_balancer_count",
                                                                                "currentXlargeLoadBalancerCount",
                                                                                "getCurrentXlargeLoadBalancerCount",
                                                                                "setCurrentXlargeLoadBalancerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("edge_cluster_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("edge_cluster_path",
                                                                                "edgeClusterPath",
                                                                                "getEdgeClusterPath",
                                                                                "setEdgeClusterPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("form_factor", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("form_factor",
                                                                                "formFactor",
                                                                                "getFormFactor",
                                                                                "setFormFactor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("load_balancer_credit_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("load_balancer_credit_capacity",
                                                                                "loadBalancerCreditCapacity",
                                                                                "getLoadBalancerCreditCapacity",
                                                                                "setLoadBalancerCreditCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_member_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_member_capacity",
                                                                                "poolMemberCapacity",
                                                                                "getPoolMemberCapacity",
                                                                                "setPoolMemberCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_large_load_balancer_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_large_load_balancer_count",
                                                                                "remainingLargeLoadBalancerCount",
                                                                                "getRemainingLargeLoadBalancerCount",
                                                                                "setRemainingLargeLoadBalancerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_medium_load_balancer_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_medium_load_balancer_count",
                                                                                "remainingMediumLoadBalancerCount",
                                                                                "getRemainingMediumLoadBalancerCount",
                                                                                "setRemainingMediumLoadBalancerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_small_load_balancer_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_small_load_balancer_count",
                                                                                "remainingSmallLoadBalancerCount",
                                                                                "getRemainingSmallLoadBalancerCount",
                                                                                "setRemainingSmallLoadBalancerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_xlarge_load_balancer_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_xlarge_load_balancer_count",
                                                                                "remainingXlargeLoadBalancerCount",
                                                                                "getRemainingXlargeLoadBalancerCount",
                                                                                "setRemainingXlargeLoadBalancerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("severity",
                                                                                "severity",
                                                                                "getSeverity",
                                                                                "setSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("usage_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("usage_percentage",
                                                                                "usagePercentage",
                                                                                "getUsagePercentage",
                                                                                "setUsagePercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_path",
                                                                                "nodePath",
                                                                                "getNodePath",
                                                                                "setNodePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_edge_node_usage",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBEdgeNodeUsage.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "LBEdgeNodeUsage");
    }
}

