/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * This action is used to select a pool for matched HTTP request messages. The pool
 * is specified by path. The matched HTTP request messages are forwarded to the
 * specified pool.
 */
public final class LBSelectPoolAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBSelectPoolAction";

    private java.lang.String poolId;

    private final java.lang.String type = "LBSelectPoolAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBSelectPoolAction() {
    }

    protected LBSelectPoolAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Path of load balancer pool.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPoolId() {
        return this.poolId;
    }

    /**
     * Path of load balancer pool.
     *
     * @param poolId New value for the property.
     */
    public void setPoolId(java.lang.String poolId) {
        this.poolId = poolId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBSELECTPOOLACTION}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREJECTACTION}</li> <li>
     * {@link com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREDIRECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBJWTAUTHACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBCONNECTIONDROPACTION}</li> </ul>
     * The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LBSelectPoolAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBSelectPoolAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("pool_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolId, this._getType().getField("pool_id")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBSelectPoolAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBSelectPoolAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBSelectPoolAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBSelectPoolAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBSelectPoolAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBSelectPoolAction(structValue);
    }

    /**
     * Builder class for {@link LBSelectPoolAction}.
     */
    public static final class Builder {
        private java.lang.String poolId;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBSelectPoolAction}.
         */
        public Builder() {
        }

        /**
         * Path of load balancer pool.
         *
         * @param poolId New value for the property.
         */
        public Builder setPoolId(java.lang.String poolId) {
            this.poolId = poolId;
            return this;
        }

        public LBSelectPoolAction build() {
            LBSelectPoolAction result = new LBSelectPoolAction();
            result.setPoolId(this.poolId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("pool_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_id",
                                                                                "poolId",
                                                                                "getPoolId",
                                                                                "setPoolId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_select_pool_action",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBSelectPoolAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LBSelectPoolAction");
    }
}

