/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Server SSL profile binding. LBServerSslProfileBinding is deprecated as NSX-T
 * Load Balancer is deprecated.
 */
public final class LBServerSslProfileBinding implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SERVER_AUTH_REQUIRED = "REQUIRED";

    public static final java.lang.String SERVER_AUTH_IGNORE = "IGNORE";

    public static final java.lang.String SERVER_AUTH_AUTO_APPLY = "AUTO_APPLY";

    private java.lang.Long certificateChainDepth;

    private java.lang.String clientCertificatePath;

    private java.lang.String serverAuth;

    private java.util.List<java.lang.String> serverAuthCaPaths;

    private java.util.List<java.lang.String> serverAuthCrlPaths;

    private java.lang.String sslProfilePath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBServerSslProfileBinding() {
    }

    protected LBServerSslProfileBinding(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Authentication depth is used to set the verification depth in the server
     * certificates chain. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCertificateChainDepth() {
        return this.certificateChainDepth;
    }

    /**
     * Authentication depth is used to set the verification depth in the server
     * certificates chain. format: int64
     *
     * @param certificateChainDepth New value for the property.
     */
    public void setCertificateChainDepth(java.lang.Long certificateChainDepth) {
        this.certificateChainDepth = certificateChainDepth;
    }

    /**
     * To support client authentication (load balancer acting as a client
     * authenticating to the backend server), client certificate can be specified in
     * the server-side SSL profile binding
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientCertificatePath() {
        return this.clientCertificatePath;
    }

    /**
     * To support client authentication (load balancer acting as a client
     * authenticating to the backend server), client certificate can be specified in
     * the server-side SSL profile binding
     *
     * @param clientCertificatePath New value for the property.
     */
    public void setClientCertificatePath(java.lang.String clientCertificatePath) {
        this.clientCertificatePath = clientCertificatePath;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_REQUIRED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_IGNORE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_AUTO_APPLY}</li>
     * </ul> Server authentication mode.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerAuth() {
        return this.serverAuth;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_REQUIRED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_IGNORE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_AUTO_APPLY}</li>
     * </ul> Server authentication mode.
     *
     * @param serverAuth New value for the property.
     */
    public void setServerAuth(java.lang.String serverAuth) {
        this.serverAuth = serverAuth;
    }

    /**
     * If server auth type is REQUIRED, server certificate must be signed by one of the
     * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
     * signed certificates are specified.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getServerAuthCaPaths() {
        return this.serverAuthCaPaths;
    }

    /**
     * If server auth type is REQUIRED, server certificate must be signed by one of the
     * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
     * signed certificates are specified.
     *
     * @param serverAuthCaPaths New value for the property.
     */
    public void setServerAuthCaPaths(java.util.List<java.lang.String> serverAuthCaPaths) {
        this.serverAuthCaPaths = serverAuthCaPaths;
    }

    /**
     * A Certificate Revocation List (CRL) can be specified in the server-side SSL
     * profile binding to disallow compromised server certificates.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getServerAuthCrlPaths() {
        return this.serverAuthCrlPaths;
    }

    /**
     * A Certificate Revocation List (CRL) can be specified in the server-side SSL
     * profile binding to disallow compromised server certificates.
     *
     * @param serverAuthCrlPaths New value for the property.
     */
    public void setServerAuthCrlPaths(java.util.List<java.lang.String> serverAuthCrlPaths) {
        this.serverAuthCrlPaths = serverAuthCrlPaths;
    }

    /**
     * Server SSL profile defines reusable, application-independent server side SSL
     * properties.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSslProfilePath() {
        return this.sslProfilePath;
    }

    /**
     * Server SSL profile defines reusable, application-independent server side SSL
     * properties.
     *
     * @param sslProfilePath New value for the property.
     */
    public void setSslProfilePath(java.lang.String sslProfilePath) {
        this.sslProfilePath = sslProfilePath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBServerSslProfileBinding;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certificate_chain_depth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificateChainDepth, this._getType().getField("certificate_chain_depth")));
        structValue.setField("client_certificate_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientCertificatePath, this._getType().getField("client_certificate_path")));
        structValue.setField("server_auth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverAuth, this._getType().getField("server_auth")));
        structValue.setField("server_auth_ca_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverAuthCaPaths, this._getType().getField("server_auth_ca_paths")));
        structValue.setField("server_auth_crl_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverAuthCrlPaths, this._getType().getField("server_auth_crl_paths")));
        structValue.setField("ssl_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sslProfilePath, this._getType().getField("ssl_profile_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBServerSslProfileBinding;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBServerSslProfileBinding.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBServerSslProfileBinding _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBServerSslProfileBinding(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBServerSslProfileBinding _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBServerSslProfileBinding(structValue);
    }

    /**
     * Builder class for {@link LBServerSslProfileBinding}.
     */
    public static final class Builder {
        private java.lang.Long certificateChainDepth;
        private java.lang.String clientCertificatePath;
        private java.lang.String serverAuth;
        private java.util.List<java.lang.String> serverAuthCaPaths;
        private java.util.List<java.lang.String> serverAuthCrlPaths;
        private java.lang.String sslProfilePath;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBServerSslProfileBinding}.
         */
        public Builder() {
        }

        /**
         * Authentication depth is used to set the verification depth in the server
         * certificates chain. format: int64
         *
         * @param certificateChainDepth New value for the property.
         */
        public Builder setCertificateChainDepth(java.lang.Long certificateChainDepth) {
            this.certificateChainDepth = certificateChainDepth;
            return this;
        }

        /**
         * To support client authentication (load balancer acting as a client
         * authenticating to the backend server), client certificate can be specified in
         * the server-side SSL profile binding
         *
         * @param clientCertificatePath New value for the property.
         */
        public Builder setClientCertificatePath(java.lang.String clientCertificatePath) {
            this.clientCertificatePath = clientCertificatePath;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_REQUIRED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_IGNORE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBServerSslProfileBinding#SERVER_AUTH_AUTO_APPLY}</li>
         * </ul> Server authentication mode.
         *
         * @param serverAuth New value for the property.
         */
        public Builder setServerAuth(java.lang.String serverAuth) {
            this.serverAuth = serverAuth;
            return this;
        }

        /**
         * If server auth type is REQUIRED, server certificate must be signed by one of the
         * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
         * signed certificates are specified.
         *
         * @param serverAuthCaPaths New value for the property.
         */
        public Builder setServerAuthCaPaths(java.util.List<java.lang.String> serverAuthCaPaths) {
            this.serverAuthCaPaths = serverAuthCaPaths;
            return this;
        }

        /**
         * A Certificate Revocation List (CRL) can be specified in the server-side SSL
         * profile binding to disallow compromised server certificates.
         *
         * @param serverAuthCrlPaths New value for the property.
         */
        public Builder setServerAuthCrlPaths(java.util.List<java.lang.String> serverAuthCrlPaths) {
            this.serverAuthCrlPaths = serverAuthCrlPaths;
            return this;
        }

        /**
         * Server SSL profile defines reusable, application-independent server side SSL
         * properties.
         *
         * @param sslProfilePath New value for the property.
         */
        public Builder setSslProfilePath(java.lang.String sslProfilePath) {
            this.sslProfilePath = sslProfilePath;
            return this;
        }

        public LBServerSslProfileBinding build() {
            LBServerSslProfileBinding result = new LBServerSslProfileBinding();
            result.setCertificateChainDepth(this.certificateChainDepth);
            result.setClientCertificatePath(this.clientCertificatePath);
            result.setServerAuth(this.serverAuth);
            result.setServerAuthCaPaths(this.serverAuthCaPaths);
            result.setServerAuthCrlPaths(this.serverAuthCrlPaths);
            result.setSslProfilePath(this.sslProfilePath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certificate_chain_depth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate_chain_depth",
                                                                                "certificateChainDepth",
                                                                                "getCertificateChainDepth",
                                                                                "setCertificateChainDepth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_certificate_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_certificate_path",
                                                                                "clientCertificatePath",
                                                                                "getClientCertificatePath",
                                                                                "setClientCertificatePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_auth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_auth",
                                                                                "serverAuth",
                                                                                "getServerAuth",
                                                                                "setServerAuth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_auth_ca_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_auth_ca_paths",
                                                                                "serverAuthCaPaths",
                                                                                "getServerAuthCaPaths",
                                                                                "setServerAuthCaPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_auth_crl_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_auth_crl_paths",
                                                                                "serverAuthCrlPaths",
                                                                                "getServerAuthCrlPaths",
                                                                                "setServerAuthCrlPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ssl_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ssl_profile_path",
                                                                                "sslProfilePath",
                                                                                "getSslProfilePath",
                                                                                "setSslProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_server_ssl_profile_binding",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBServerSslProfileBinding.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

