/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Describes the capacity and current usage of virtual servers, pools and pool
 * members for the given load balancer service.
 */
public final class LBServiceUsage implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBServiceUsage";

    public static final java.lang.String SERVICE_SIZE_SMALL = "SMALL";

    public static final java.lang.String SERVICE_SIZE_MEDIUM = "MEDIUM";

    public static final java.lang.String SERVICE_SIZE_LARGE = "LARGE";

    public static final java.lang.String SERVICE_SIZE_XLARGE = "XLARGE";

    public static final java.lang.String SERVICE_SIZE_DLB = "DLB";

    public static final java.lang.String SEVERITY_GREEN = "GREEN";

    public static final java.lang.String SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String SEVERITY_RED = "RED";

    private java.lang.Long currentPoolCount;

    private java.lang.Long currentPoolMemberCount;

    private java.lang.Long currentVirtualServerCount;

    private java.lang.Long lastUpdateTimestamp;

    private java.lang.Long poolCapacity;

    private java.lang.Long poolMemberCapacity;

    private java.lang.String servicePath;

    private java.lang.String serviceSize;

    private java.lang.String severity;

    private java.lang.Double usagePercentage;

    private java.lang.Long virtualServerCapacity;

    private com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm;

    private java.lang.String enforcementPointPath;

    private final java.lang.String resourceType = "LBServiceUsage";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBServiceUsage() {
    }

    protected LBServiceUsage(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The current number of pools which has been configured in the given load balancer
     * service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolCount() {
        return this.currentPoolCount;
    }

    /**
     * The current number of pools which has been configured in the given load balancer
     * service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolCount New value for the property.
     */
    public void setCurrentPoolCount(java.lang.Long currentPoolCount) {
        this.currentPoolCount = currentPoolCount;
    }

    /**
     * The current number of pool members which has been configured in the given load
     * balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolMemberCount() {
        return this.currentPoolMemberCount;
    }

    /**
     * The current number of pool members which has been configured in the given load
     * balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolMemberCount New value for the property.
     */
    public void setCurrentPoolMemberCount(java.lang.Long currentPoolMemberCount) {
        this.currentPoolMemberCount = currentPoolMemberCount;
    }

    /**
     * The current number of virtual servers which has been configured in the given
     * load balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentVirtualServerCount() {
        return this.currentVirtualServerCount;
    }

    /**
     * The current number of virtual servers which has been configured in the given
     * load balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentVirtualServerCount New value for the property.
     */
    public void setCurrentVirtualServerCount(java.lang.Long currentVirtualServerCount) {
        this.currentVirtualServerCount = currentVirtualServerCount;
    }

    /**
     * Timestamp when the data was last updated. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    /**
     * Timestamp when the data was last updated. format: int64
     *
     * @param lastUpdateTimestamp New value for the property.
     */
    public void setLastUpdateTimestamp(java.lang.Long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    /**
     * Pool capacity means maximum number of pools which could be configured in the
     * given load balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPoolCapacity() {
        return this.poolCapacity;
    }

    /**
     * Pool capacity means maximum number of pools which could be configured in the
     * given load balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolCapacity New value for the property.
     */
    public void setPoolCapacity(java.lang.Long poolCapacity) {
        this.poolCapacity = poolCapacity;
    }

    /**
     * Pool member capacity means maximum number of pool members which could be
     * configured in the given load balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPoolMemberCapacity() {
        return this.poolMemberCapacity;
    }

    /**
     * Pool member capacity means maximum number of pool members which could be
     * configured in the given load balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolMemberCapacity New value for the property.
     */
    public void setPoolMemberCapacity(java.lang.Long poolMemberCapacity) {
        this.poolMemberCapacity = poolMemberCapacity;
    }

    /**
     * LBService object path.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServicePath() {
        return this.servicePath;
    }

    /**
     * LBService object path.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param servicePath New value for the property.
     */
    public void setServicePath(java.lang.String servicePath) {
        this.servicePath = servicePath;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_SMALL}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_MEDIUM}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_LARGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_XLARGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_DLB}</li> </ul> The size
     * of load balancer service.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceSize() {
        return this.serviceSize;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_SMALL}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_MEDIUM}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_LARGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_XLARGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_DLB}</li> </ul> The size
     * of load balancer service.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serviceSize New value for the property.
     */
    public void setServiceSize(java.lang.String serviceSize) {
        this.serviceSize = serviceSize;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_RED}</li> </ul> The severity
     * calculation is based on the largest usage percentage from virtual servers, pools
     * and pool members for one load balancer service.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSeverity() {
        return this.severity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_RED}</li> </ul> The severity
     * calculation is based on the largest usage percentage from virtual servers, pools
     * and pool members for one load balancer service.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param severity New value for the property.
     */
    public void setSeverity(java.lang.String severity) {
        this.severity = severity;
    }

    /**
     * The usage percentage is the largest usage percentage from virtual servers, pools
     * and pool members for the load balancer service. If the property
     * relax_scale_validation is set as true for LBService, it is possible that the
     * value is larger than 100.0. For example, if SMALL LBS is deployed on MEDIUM edge
     * node and configured with MEDIUM LBS virtual server scale number, LBS usage
     * percentage is shown larger than 100.0.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getUsagePercentage() {
        return this.usagePercentage;
    }

    /**
     * The usage percentage is the largest usage percentage from virtual servers, pools
     * and pool members for the load balancer service. If the property
     * relax_scale_validation is set as true for LBService, it is possible that the
     * value is larger than 100.0. For example, if SMALL LBS is deployed on MEDIUM edge
     * node and configured with MEDIUM LBS virtual server scale number, LBS usage
     * percentage is shown larger than 100.0.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param usagePercentage New value for the property.
     */
    public void setUsagePercentage(java.lang.Double usagePercentage) {
        this.usagePercentage = usagePercentage;
    }

    /**
     * Virtual server capacity means maximum number of virtual servers which could be
     * configured in the given load balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getVirtualServerCapacity() {
        return this.virtualServerCapacity;
    }

    /**
     * Virtual server capacity means maximum number of virtual servers which could be
     * configured in the given load balancer service. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param virtualServerCapacity New value for the property.
     */
    public void setVirtualServerCapacity(java.lang.Long virtualServerCapacity) {
        this.virtualServerCapacity = virtualServerCapacity;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.PolicyRuntimeAlarm getAlarm() {
        return this.alarm;
    }

    /**
     *
     *
     * @param alarm New value for the property.
     */
    public void setAlarm(com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm) {
        this.alarm = alarm;
    }

    /**
     * Policy Path referencing the enforcement point where the info is fetched.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEnforcementPointPath() {
        return this.enforcementPointPath;
    }

    /**
     * Policy Path referencing the enforcement point where the info is fetched.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param enforcementPointPath New value for the property.
     */
    public void setEnforcementPointPath(java.lang.String enforcementPointPath) {
        this.enforcementPointPath = enforcementPointPath;
    }

    /**
     *
     * The value of this property is automatically populated to {@code "LBServiceUsage"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBServiceUsage;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("current_pool_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolCount, this._getType().getField("current_pool_count")));
        structValue.setField("current_pool_member_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolMemberCount, this._getType().getField("current_pool_member_count")));
        structValue.setField("current_virtual_server_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentVirtualServerCount, this._getType().getField("current_virtual_server_count")));
        structValue.setField("last_update_timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastUpdateTimestamp, this._getType().getField("last_update_timestamp")));
        structValue.setField("pool_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolCapacity, this._getType().getField("pool_capacity")));
        structValue.setField("pool_member_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolMemberCapacity, this._getType().getField("pool_member_capacity")));
        structValue.setField("service_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.servicePath, this._getType().getField("service_path")));
        structValue.setField("service_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceSize, this._getType().getField("service_size")));
        structValue.setField("severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.severity, this._getType().getField("severity")));
        structValue.setField("usage_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.usagePercentage, this._getType().getField("usage_percentage")));
        structValue.setField("virtual_server_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.virtualServerCapacity, this._getType().getField("virtual_server_capacity")));
        structValue.setField("alarm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.alarm, this._getType().getField("alarm")));
        structValue.setField("enforcement_point_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enforcementPointPath, this._getType().getField("enforcement_point_path")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBServiceUsage;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBServiceUsage.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBServiceUsage _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBServiceUsage(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBServiceUsage _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBServiceUsage(structValue);
    }

    /**
     * Builder class for {@link LBServiceUsage}.
     */
    public static final class Builder {
        private java.lang.Long currentPoolCount;
        private java.lang.Long currentPoolMemberCount;
        private java.lang.Long currentVirtualServerCount;
        private java.lang.Long lastUpdateTimestamp;
        private java.lang.Long poolCapacity;
        private java.lang.Long poolMemberCapacity;
        private java.lang.String servicePath;
        private java.lang.String serviceSize;
        private java.lang.String severity;
        private java.lang.Double usagePercentage;
        private java.lang.Long virtualServerCapacity;
        private com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm;
        private java.lang.String enforcementPointPath;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBServiceUsage}.
         */
        public Builder() {
        }

        /**
         * The current number of pools which has been configured in the given load balancer
         * service. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolCount New value for the property.
         */
        public Builder setCurrentPoolCount(java.lang.Long currentPoolCount) {
            this.currentPoolCount = currentPoolCount;
            return this;
        }

        /**
         * The current number of pool members which has been configured in the given load
         * balancer service. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolMemberCount New value for the property.
         */
        public Builder setCurrentPoolMemberCount(java.lang.Long currentPoolMemberCount) {
            this.currentPoolMemberCount = currentPoolMemberCount;
            return this;
        }

        /**
         * The current number of virtual servers which has been configured in the given
         * load balancer service. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentVirtualServerCount New value for the property.
         */
        public Builder setCurrentVirtualServerCount(java.lang.Long currentVirtualServerCount) {
            this.currentVirtualServerCount = currentVirtualServerCount;
            return this;
        }

        /**
         * Timestamp when the data was last updated. format: int64
         *
         * @param lastUpdateTimestamp New value for the property.
         */
        public Builder setLastUpdateTimestamp(java.lang.Long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        /**
         * Pool capacity means maximum number of pools which could be configured in the
         * given load balancer service. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolCapacity New value for the property.
         */
        public Builder setPoolCapacity(java.lang.Long poolCapacity) {
            this.poolCapacity = poolCapacity;
            return this;
        }

        /**
         * Pool member capacity means maximum number of pool members which could be
         * configured in the given load balancer service. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolMemberCapacity New value for the property.
         */
        public Builder setPoolMemberCapacity(java.lang.Long poolMemberCapacity) {
            this.poolMemberCapacity = poolMemberCapacity;
            return this;
        }

        /**
         * LBService object path.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param servicePath New value for the property.
         */
        public Builder setServicePath(java.lang.String servicePath) {
            this.servicePath = servicePath;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_SMALL}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_MEDIUM}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_LARGE}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_XLARGE}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsage#SERVICE_SIZE_DLB}</li> </ul> The size
         * of load balancer service.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serviceSize New value for the property.
         */
        public Builder setServiceSize(java.lang.String serviceSize) {
            this.serviceSize = serviceSize;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_GREEN}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_ORANGE}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsage#SEVERITY_RED}</li> </ul> The severity
         * calculation is based on the largest usage percentage from virtual servers, pools
         * and pool members for one load balancer service.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param severity New value for the property.
         */
        public Builder setSeverity(java.lang.String severity) {
            this.severity = severity;
            return this;
        }

        /**
         * The usage percentage is the largest usage percentage from virtual servers, pools
         * and pool members for the load balancer service. If the property
         * relax_scale_validation is set as true for LBService, it is possible that the
         * value is larger than 100.0. For example, if SMALL LBS is deployed on MEDIUM edge
         * node and configured with MEDIUM LBS virtual server scale number, LBS usage
         * percentage is shown larger than 100.0.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param usagePercentage New value for the property.
         */
        public Builder setUsagePercentage(java.lang.Double usagePercentage) {
            this.usagePercentage = usagePercentage;
            return this;
        }

        /**
         * Virtual server capacity means maximum number of virtual servers which could be
         * configured in the given load balancer service. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param virtualServerCapacity New value for the property.
         */
        public Builder setVirtualServerCapacity(java.lang.Long virtualServerCapacity) {
            this.virtualServerCapacity = virtualServerCapacity;
            return this;
        }

        /**
         *
         *
         * @param alarm New value for the property.
         */
        public Builder setAlarm(com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm) {
            this.alarm = alarm;
            return this;
        }

        /**
         * Policy Path referencing the enforcement point where the info is fetched.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param enforcementPointPath New value for the property.
         */
        public Builder setEnforcementPointPath(java.lang.String enforcementPointPath) {
            this.enforcementPointPath = enforcementPointPath;
            return this;
        }

        public LBServiceUsage build() {
            LBServiceUsage result = new LBServiceUsage();
            result.setCurrentPoolCount(this.currentPoolCount);
            result.setCurrentPoolMemberCount(this.currentPoolMemberCount);
            result.setCurrentVirtualServerCount(this.currentVirtualServerCount);
            result.setLastUpdateTimestamp(this.lastUpdateTimestamp);
            result.setPoolCapacity(this.poolCapacity);
            result.setPoolMemberCapacity(this.poolMemberCapacity);
            result.setServicePath(this.servicePath);
            result.setServiceSize(this.serviceSize);
            result.setSeverity(this.severity);
            result.setUsagePercentage(this.usagePercentage);
            result.setVirtualServerCapacity(this.virtualServerCapacity);
            result.setAlarm(this.alarm);
            result.setEnforcementPointPath(this.enforcementPointPath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("current_pool_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_count",
                                                                                "currentPoolCount",
                                                                                "getCurrentPoolCount",
                                                                                "setCurrentPoolCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_pool_member_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_member_count",
                                                                                "currentPoolMemberCount",
                                                                                "getCurrentPoolMemberCount",
                                                                                "setCurrentPoolMemberCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_virtual_server_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_virtual_server_count",
                                                                                "currentVirtualServerCount",
                                                                                "getCurrentVirtualServerCount",
                                                                                "setCurrentVirtualServerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_update_timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_update_timestamp",
                                                                                "lastUpdateTimestamp",
                                                                                "getLastUpdateTimestamp",
                                                                                "setLastUpdateTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_capacity",
                                                                                "poolCapacity",
                                                                                "getPoolCapacity",
                                                                                "setPoolCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_member_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_member_capacity",
                                                                                "poolMemberCapacity",
                                                                                "getPoolMemberCapacity",
                                                                                "setPoolMemberCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_path",
                                                                                "servicePath",
                                                                                "getServicePath",
                                                                                "setServicePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_size",
                                                                                "serviceSize",
                                                                                "getServiceSize",
                                                                                "setServiceSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("severity",
                                                                                "severity",
                                                                                "getSeverity",
                                                                                "setSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("usage_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("usage_percentage",
                                                                                "usagePercentage",
                                                                                "getUsagePercentage",
                                                                                "setUsagePercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("virtual_server_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("virtual_server_capacity",
                                                                                "virtualServerCapacity",
                                                                                "getVirtualServerCapacity",
                                                                                "setVirtualServerCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("alarm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.policyRuntimeAlarm; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("alarm",
                                                                                "alarm",
                                                                                "getAlarm",
                                                                                "setAlarm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enforcement_point_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enforcement_point_path",
                                                                                "enforcementPointPath",
                                                                                "getEnforcementPointPath",
                                                                                "setEnforcementPointPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_service_usage",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBServiceUsage.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "LBServiceUsage");
    }
}

