/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Detail about one error encountered during a probe.
 */
public final class LdapProbeError implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ERROR_TYPE_BASE_DN_NOT_FOUND = "BASE_DN_NOT_FOUND";

    public static final java.lang.String ERROR_TYPE_BIND_DN_AND_PASSWORD_REQUIRED = "BIND_DN_AND_PASSWORD_REQUIRED";

    public static final java.lang.String ERROR_TYPE_BIND_DN_INVALID = "BIND_DN_INVALID";

    public static final java.lang.String ERROR_TYPE_CERTIFICATE_HOSTNAME_MISMATCH_ERROR = "CERTIFICATE_HOSTNAME_MISMATCH_ERROR";

    public static final java.lang.String ERROR_TYPE_CERTIFICATE_MISMATCH_ERROR = "CERTIFICATE_MISMATCH_ERROR";

    public static final java.lang.String ERROR_TYPE_CONNECTION_REFUSED = "CONNECTION_REFUSED";

    public static final java.lang.String ERROR_TYPE_CONNECTION_TIMEOUT = "CONNECTION_TIMEOUT";

    public static final java.lang.String ERROR_TYPE_GENERAL_ERROR = "GENERAL_ERROR";

    public static final java.lang.String ERROR_TYPE_INVALID_CONFIGURED_CERTIFICATE = "INVALID_CONFIGURED_CERTIFICATE";

    public static final java.lang.String ERROR_TYPE_INVALID_CREDENTIALS = "INVALID_CREDENTIALS";

    public static final java.lang.String ERROR_TYPE_SSL_HANDSHAKE_ERROR = "SSL_HANDSHAKE_ERROR";

    public static final java.lang.String ERROR_TYPE_STARTTLS_FAILED = "STARTTLS_FAILED";

    public static final java.lang.String ERROR_TYPE_UNKNOWN_HOST = "UNKNOWN_HOST";

    public static final java.lang.String ERROR_TYPE_NO_ROUTE_TO_HOST = "NO_ROUTE_TO_HOST";

    public static final java.lang.String ERROR_TYPE_BIND_EXCEPTION = "BIND_EXCEPTION";

    public static final java.lang.String ERROR_TYPE_PORT_UNREACHABLE = "PORT_UNREACHABLE";

    public static final java.lang.String ERROR_TYPE_BASE_DN_NOT_WITHIN_DOMAIN = "BASE_DN_NOT_WITHIN_DOMAIN";

    public static final java.lang.String ERROR_TYPE_LDAP_SERVER_DISABLED = "LDAP_SERVER_DISABLED";

    private java.lang.String errorType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LdapProbeError() {
    }

    protected LdapProbeError(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BASE_DN_NOT_FOUND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_DN_AND_PASSWORD_REQUIRED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_DN_INVALID}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CERTIFICATE_HOSTNAME_MISMATCH_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CERTIFICATE_MISMATCH_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CONNECTION_REFUSED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CONNECTION_TIMEOUT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_GENERAL_ERROR}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_INVALID_CONFIGURED_CERTIFICATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_INVALID_CREDENTIALS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_SSL_HANDSHAKE_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_STARTTLS_FAILED}</li> <li>
     * {@link com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_UNKNOWN_HOST}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_NO_ROUTE_TO_HOST}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_EXCEPTION}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_PORT_UNREACHABLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BASE_DN_NOT_WITHIN_DOMAIN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_LDAP_SERVER_DISABLED}</li>
     * </ul> The cause of the error. BASE_DN_NOT_FOUND: The configured base DN does not
     * exist on the LDAP server or is not readable. BIND_DN_AND_PASSWORD_REQUIRED: This
     * server is configured to require a bind DN and password. Please add these to your
     * LDAP server configuration. BIND_DN_INVALID: The bind DN or username provided is
     * not valid on the LDAP server. Check that the bind DN is correct. This error may
     * also indicate that the base DN in your configuration is incorrect.
     * CERTIFICATE_HOSTNAME_MISMATCH_ERROR: The hostname configured for the LDAP server
     * does not match the hostname in the server's certificate subject or alternative
     * subject names. Be sure that the hostname you configure in NSX Manager matches
     * one of those names. CERTIFICATE_MISMATCH_ERROR: The certificate presented by the
     * LDAP server did not match the certificate in the configuration on the NSX
     * Manager. CONNECTION_REFUSED: The connection was refused when contacting the LDAP
     * server. Ensure that the LDAP server is running and that you are using the
     * correct ip/hostname. CONNECTION_TIMEOUT: The connection timed out when
     * contacting the LDAP server. Check the hostname/ip and any firewalls between the
     * NSX Manager and the LDAP server. GENERAL_ERROR: An undetermined error occurred.
     * INVALID_CONFIGURED_CERTIFICATE: The certificate configured for this LDAP server
     * is invalid and could not be decoded. Check that the PEM-formatted certificate
     * you provided is correct. INVALID_CREDENTIALS: The username and/or password are
     * incorrect. SSL_HANDSHAKE_ERROR: An error occurred while establishing a secure
     * connection with the LDAP server. Check that the LDAP server's certificate is
     * correct, and that it is using an SSL/TLS cipher suite that is compatible with
     * the NSX Manager. This error can also occur if the hostname you have configured
     * for the LDAP server does not match any of the hostnames in the Subject
     * Alternative Name records in the server certificate. STARTTLS_FAILED: Unable to
     * use StartTLS to upgrade the connection to use TLS. Ensure that the LDAP server
     * supports TLS and if not, use LDAP or LDAPS as the protocol. UNKNOWN_HOST: The
     * hostname of the LDAP server could not be resolved. NO_ROUTE_TO_HOST: There is no
     * network route to the host. BIND_EXCEPTION: A socket to the remote host could not
     * be opened. PORT_UNREACHABLE: The LDAP port is not open on the remote host.
     * BASE_DN_NOT_WITHIN_DOMAIN: For Active Directory, the base DN is not a subtree of
     * the Domain Component tree corresponding to the LDAP domain. For example, if the
     * domain is \"example.com\", the baseDN should be \"dc=example, dc=com\" or a
     * subtree like \"ou=Users,dc=example,dc=com\". LDAP_SERVER_DISABLED: The LDAP
     * server is marked as disabled in the NSX configuration and will not be used.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorType() {
        return this.errorType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BASE_DN_NOT_FOUND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_DN_AND_PASSWORD_REQUIRED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_DN_INVALID}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CERTIFICATE_HOSTNAME_MISMATCH_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CERTIFICATE_MISMATCH_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CONNECTION_REFUSED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CONNECTION_TIMEOUT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_GENERAL_ERROR}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_INVALID_CONFIGURED_CERTIFICATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_INVALID_CREDENTIALS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_SSL_HANDSHAKE_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_STARTTLS_FAILED}</li> <li>
     * {@link com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_UNKNOWN_HOST}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_NO_ROUTE_TO_HOST}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_EXCEPTION}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_PORT_UNREACHABLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BASE_DN_NOT_WITHIN_DOMAIN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_LDAP_SERVER_DISABLED}</li>
     * </ul> The cause of the error. BASE_DN_NOT_FOUND: The configured base DN does not
     * exist on the LDAP server or is not readable. BIND_DN_AND_PASSWORD_REQUIRED: This
     * server is configured to require a bind DN and password. Please add these to your
     * LDAP server configuration. BIND_DN_INVALID: The bind DN or username provided is
     * not valid on the LDAP server. Check that the bind DN is correct. This error may
     * also indicate that the base DN in your configuration is incorrect.
     * CERTIFICATE_HOSTNAME_MISMATCH_ERROR: The hostname configured for the LDAP server
     * does not match the hostname in the server's certificate subject or alternative
     * subject names. Be sure that the hostname you configure in NSX Manager matches
     * one of those names. CERTIFICATE_MISMATCH_ERROR: The certificate presented by the
     * LDAP server did not match the certificate in the configuration on the NSX
     * Manager. CONNECTION_REFUSED: The connection was refused when contacting the LDAP
     * server. Ensure that the LDAP server is running and that you are using the
     * correct ip/hostname. CONNECTION_TIMEOUT: The connection timed out when
     * contacting the LDAP server. Check the hostname/ip and any firewalls between the
     * NSX Manager and the LDAP server. GENERAL_ERROR: An undetermined error occurred.
     * INVALID_CONFIGURED_CERTIFICATE: The certificate configured for this LDAP server
     * is invalid and could not be decoded. Check that the PEM-formatted certificate
     * you provided is correct. INVALID_CREDENTIALS: The username and/or password are
     * incorrect. SSL_HANDSHAKE_ERROR: An error occurred while establishing a secure
     * connection with the LDAP server. Check that the LDAP server's certificate is
     * correct, and that it is using an SSL/TLS cipher suite that is compatible with
     * the NSX Manager. This error can also occur if the hostname you have configured
     * for the LDAP server does not match any of the hostnames in the Subject
     * Alternative Name records in the server certificate. STARTTLS_FAILED: Unable to
     * use StartTLS to upgrade the connection to use TLS. Ensure that the LDAP server
     * supports TLS and if not, use LDAP or LDAPS as the protocol. UNKNOWN_HOST: The
     * hostname of the LDAP server could not be resolved. NO_ROUTE_TO_HOST: There is no
     * network route to the host. BIND_EXCEPTION: A socket to the remote host could not
     * be opened. PORT_UNREACHABLE: The LDAP port is not open on the remote host.
     * BASE_DN_NOT_WITHIN_DOMAIN: For Active Directory, the base DN is not a subtree of
     * the Domain Component tree corresponding to the LDAP domain. For example, if the
     * domain is \"example.com\", the baseDN should be \"dc=example, dc=com\" or a
     * subtree like \"ou=Users,dc=example,dc=com\". LDAP_SERVER_DISABLED: The LDAP
     * server is marked as disabled in the NSX configuration and will not be used.
     *
     * @param errorType New value for the property.
     */
    public void setErrorType(java.lang.String errorType) {
        this.errorType = errorType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ldapProbeError;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("error_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorType, this._getType().getField("error_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ldapProbeError;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ldapProbeError.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LdapProbeError _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LdapProbeError(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LdapProbeError _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LdapProbeError(structValue);
    }

    /**
     * Builder class for {@link LdapProbeError}.
     */
    public static final class Builder {
        private java.lang.String errorType;

        /**
         * Constructor with parameters for the required properties of
         * {@link LdapProbeError}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BASE_DN_NOT_FOUND}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_DN_AND_PASSWORD_REQUIRED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_DN_INVALID}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CERTIFICATE_HOSTNAME_MISMATCH_ERROR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CERTIFICATE_MISMATCH_ERROR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CONNECTION_REFUSED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_CONNECTION_TIMEOUT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_GENERAL_ERROR}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_INVALID_CONFIGURED_CERTIFICATE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_INVALID_CREDENTIALS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_SSL_HANDSHAKE_ERROR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_STARTTLS_FAILED}</li> <li>
         * {@link com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_UNKNOWN_HOST}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_NO_ROUTE_TO_HOST}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BIND_EXCEPTION}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_PORT_UNREACHABLE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_BASE_DN_NOT_WITHIN_DOMAIN}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LdapProbeError#ERROR_TYPE_LDAP_SERVER_DISABLED}</li>
         * </ul> The cause of the error. BASE_DN_NOT_FOUND: The configured base DN does not
         * exist on the LDAP server or is not readable. BIND_DN_AND_PASSWORD_REQUIRED: This
         * server is configured to require a bind DN and password. Please add these to your
         * LDAP server configuration. BIND_DN_INVALID: The bind DN or username provided is
         * not valid on the LDAP server. Check that the bind DN is correct. This error may
         * also indicate that the base DN in your configuration is incorrect.
         * CERTIFICATE_HOSTNAME_MISMATCH_ERROR: The hostname configured for the LDAP server
         * does not match the hostname in the server's certificate subject or alternative
         * subject names. Be sure that the hostname you configure in NSX Manager matches
         * one of those names. CERTIFICATE_MISMATCH_ERROR: The certificate presented by the
         * LDAP server did not match the certificate in the configuration on the NSX
         * Manager. CONNECTION_REFUSED: The connection was refused when contacting the LDAP
         * server. Ensure that the LDAP server is running and that you are using the
         * correct ip/hostname. CONNECTION_TIMEOUT: The connection timed out when
         * contacting the LDAP server. Check the hostname/ip and any firewalls between the
         * NSX Manager and the LDAP server. GENERAL_ERROR: An undetermined error occurred.
         * INVALID_CONFIGURED_CERTIFICATE: The certificate configured for this LDAP server
         * is invalid and could not be decoded. Check that the PEM-formatted certificate
         * you provided is correct. INVALID_CREDENTIALS: The username and/or password are
         * incorrect. SSL_HANDSHAKE_ERROR: An error occurred while establishing a secure
         * connection with the LDAP server. Check that the LDAP server's certificate is
         * correct, and that it is using an SSL/TLS cipher suite that is compatible with
         * the NSX Manager. This error can also occur if the hostname you have configured
         * for the LDAP server does not match any of the hostnames in the Subject
         * Alternative Name records in the server certificate. STARTTLS_FAILED: Unable to
         * use StartTLS to upgrade the connection to use TLS. Ensure that the LDAP server
         * supports TLS and if not, use LDAP or LDAPS as the protocol. UNKNOWN_HOST: The
         * hostname of the LDAP server could not be resolved. NO_ROUTE_TO_HOST: There is no
         * network route to the host. BIND_EXCEPTION: A socket to the remote host could not
         * be opened. PORT_UNREACHABLE: The LDAP port is not open on the remote host.
         * BASE_DN_NOT_WITHIN_DOMAIN: For Active Directory, the base DN is not a subtree of
         * the Domain Component tree corresponding to the LDAP domain. For example, if the
         * domain is \"example.com\", the baseDN should be \"dc=example, dc=com\" or a
         * subtree like \"ou=Users,dc=example,dc=com\". LDAP_SERVER_DISABLED: The LDAP
         * server is marked as disabled in the NSX configuration and will not be used.
         *
         * @param errorType New value for the property.
         */
        public Builder setErrorType(java.lang.String errorType) {
            this.errorType = errorType;
            return this;
        }

        public LdapProbeError build() {
            LdapProbeError result = new LdapProbeError();
            result.setErrorType(this.errorType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("error_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_type",
                                                                                "errorType",
                                                                                "getErrorType",
                                                                                "setErrorType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ldap_probe_error",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LdapProbeError.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

