/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Neighbor discovery protocol header
 */
public final class NdpHeader implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MSG_TYPE_SOLICITATION = "NEIGHBOR_SOLICITATION";

    public static final java.lang.String MSG_TYPE_ADVERTISEMENT = "NEIGHBOR_ADVERTISEMENT";

    private java.lang.String dstIp;

    private java.lang.String msgType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NdpHeader() {
    }

    protected NdpHeader(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The IP address of the destination of the solicitation. It MUST NOT be a
     * multicast address. format: ipv6
     *
     * @return The current value of the property.
     */
    public java.lang.String getDstIp() {
        return this.dstIp;
    }

    /**
     * The IP address of the destination of the solicitation. It MUST NOT be a
     * multicast address. format: ipv6
     *
     * @param dstIp New value for the property.
     */
    public void setDstIp(java.lang.String dstIp) {
        this.dstIp = dstIp;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.NdpHeader#MSG_TYPE_SOLICITATION}</li> <li> {@link
     * com.vmware.nsx_policy.model.NdpHeader#MSG_TYPE_ADVERTISEMENT}</li> </ul> This
     * field specifies the type of the Neighbor discover message being sent.
     * NEIGHBOR_SOLICITATION - Neighbor Solicitation message to discover the link-layer
     * address of an on-link IPv6 node or to confirm a previously determined link-layer
     * address. NEIGHBOR_ADVERTISEMENT - Neighbor Advertisement message in response to
     * a Neighbor Solicitation message.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMsgType() {
        return this.msgType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.NdpHeader#MSG_TYPE_SOLICITATION}</li> <li> {@link
     * com.vmware.nsx_policy.model.NdpHeader#MSG_TYPE_ADVERTISEMENT}</li> </ul> This
     * field specifies the type of the Neighbor discover message being sent.
     * NEIGHBOR_SOLICITATION - Neighbor Solicitation message to discover the link-layer
     * address of an on-link IPv6 node or to confirm a previously determined link-layer
     * address. NEIGHBOR_ADVERTISEMENT - Neighbor Advertisement message in response to
     * a Neighbor Solicitation message.
     *
     * @param msgType New value for the property.
     */
    public void setMsgType(java.lang.String msgType) {
        this.msgType = msgType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ndpHeader;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dst_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dstIp, this._getType().getField("dst_ip")));
        structValue.setField("msg_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.msgType, this._getType().getField("msg_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ndpHeader;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ndpHeader.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NdpHeader _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NdpHeader(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NdpHeader _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NdpHeader(structValue);
    }

    /**
     * Builder class for {@link NdpHeader}.
     */
    public static final class Builder {
        private java.lang.String dstIp;
        private java.lang.String msgType;

        /**
         * Constructor with parameters for the required properties of
         * {@link NdpHeader}.
         */
        public Builder() {
        }

        /**
         * The IP address of the destination of the solicitation. It MUST NOT be a
         * multicast address. format: ipv6
         *
         * @param dstIp New value for the property.
         */
        public Builder setDstIp(java.lang.String dstIp) {
            this.dstIp = dstIp;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.NdpHeader#MSG_TYPE_SOLICITATION}</li> <li> {@link
         * com.vmware.nsx_policy.model.NdpHeader#MSG_TYPE_ADVERTISEMENT}</li> </ul> This
         * field specifies the type of the Neighbor discover message being sent.
         * NEIGHBOR_SOLICITATION - Neighbor Solicitation message to discover the link-layer
         * address of an on-link IPv6 node or to confirm a previously determined link-layer
         * address. NEIGHBOR_ADVERTISEMENT - Neighbor Advertisement message in response to
         * a Neighbor Solicitation message.
         *
         * @param msgType New value for the property.
         */
        public Builder setMsgType(java.lang.String msgType) {
            this.msgType = msgType;
            return this;
        }

        public NdpHeader build() {
            NdpHeader result = new NdpHeader();
            result.setDstIp(this.dstIp);
            result.setMsgType(this.msgType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dst_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dst_ip",
                                                                                "dstIp",
                                                                                "getDstIp",
                                                                                "setDstIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("msg_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("msg_type",
                                                                                "msgType",
                                                                                "getMsgType",
                                                                                "setMsgType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ndp_header",
                                                            fields,
                                                            com.vmware.nsx_policy.model.NdpHeader.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

