/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Base type for Online Diagnostic System runbook parameter.
 */
public final class OdsRunbookParameter implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "OdsRunbookParameter";

    public static final java.lang.String PARAMETER_TYPE_INTEGER = "INTEGER";

    public static final java.lang.String PARAMETER_TYPE_STRING = "STRING";

    public static final java.lang.String PARAMETER_TYPE_ENUM = "ENUM";

    public static final java.lang.String PARAMETER_TYPE_PATTERN = "PATTERN";

    public static final java.lang.String PARAMETER_TYPE_COMPOUND = "COMPOUND";

    public static final java.lang.String PARAMETER_TYPE_BOOLEAN = "BOOLEAN";

    public static final java.lang.String PARAMETER_TYPE_FLOAT = "FLOAT";

    private java.lang.String defaultValue;

    private java.lang.String max;

    private java.lang.String min;

    private java.lang.String name;

    private java.lang.Boolean optional;

    private final java.lang.String parameterType = "OdsRunbookParameter";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public OdsRunbookParameter() {
    }

    protected OdsRunbookParameter(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Runbook argument will be set to this value if not provided.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultValue() {
        return this.defaultValue;
    }

    /**
     * Runbook argument will be set to this value if not provided.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param defaultValue New value for the property.
     */
    public void setDefaultValue(java.lang.String defaultValue) {
        this.defaultValue = defaultValue;
    }

    /**
     * Runbook argument is not allowed to set value bigger than this.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMax() {
        return this.max;
    }

    /**
     * Runbook argument is not allowed to set value bigger than this.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param max New value for the property.
     */
    public void setMax(java.lang.String max) {
        this.max = max;
    }

    /**
     * Runbook argument is not allowed to set value smaller than this.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMin() {
        return this.min;
    }

    /**
     * Runbook argument is not allowed to set value smaller than this.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param min New value for the property.
     */
    public void setMin(java.lang.String min) {
        this.min = min;
    }

    /**
     * Runbook argument name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Runbook argument name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * The flag that indicates whether the argument is optional.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOptional() {
        return this.optional;
    }

    /**
     * The flag that indicates whether the argument is optional.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param optional New value for the property.
     */
    public void setOptional(java.lang.Boolean optional) {
        this.optional = optional;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookParameter#PARAMETER_TYPE_INTEGER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookParameter#PARAMETER_TYPE_STRING}</li> <li>
     * {@link com.vmware.nsx_policy.model.OdsRunbookParameter#PARAMETER_TYPE_ENUM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookParameter#PARAMETER_TYPE_PATTERN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookParameter#PARAMETER_TYPE_COMPOUND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookParameter#PARAMETER_TYPE_BOOLEAN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookParameter#PARAMETER_TYPE_FLOAT}</li> </ul>
     * Runbook parameter type. INTEGER - integer STRING - string ENUM - enumeration
     * PATTERN - string that matches certain regular expression COMPOUND - string that
     * is accepted by the validation of runbook BOOLEAN - boolean FLOAT - float
     * The value of this property is automatically populated to {@code "OdsRunbookParameter"}.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParameterType() {
        return this.parameterType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.odsRunbookParameter;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("default_value",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultValue, this._getType().getField("default_value")));
        structValue.setField("max",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.max, this._getType().getField("max")));
        structValue.setField("min",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.min, this._getType().getField("min")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("optional",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.optional, this._getType().getField("optional")));
        structValue.setField("parameter_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parameterType, this._getType().getField("parameter_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.odsRunbookParameter;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.odsRunbookParameter.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static OdsRunbookParameter _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new OdsRunbookParameter(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static OdsRunbookParameter _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new OdsRunbookParameter(structValue);
    }

    /**
     * Builder class for {@link OdsRunbookParameter}.
     */
    public static final class Builder {
        private java.lang.String defaultValue;
        private java.lang.String max;
        private java.lang.String min;
        private java.lang.String name;
        private java.lang.Boolean optional;

        /**
         * Constructor with parameters for the required properties of
         * {@link OdsRunbookParameter}.
         */
        public Builder() {
        }

        /**
         * Runbook argument will be set to this value if not provided.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param defaultValue New value for the property.
         */
        public Builder setDefaultValue(java.lang.String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        /**
         * Runbook argument is not allowed to set value bigger than this.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param max New value for the property.
         */
        public Builder setMax(java.lang.String max) {
            this.max = max;
            return this;
        }

        /**
         * Runbook argument is not allowed to set value smaller than this.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param min New value for the property.
         */
        public Builder setMin(java.lang.String min) {
            this.min = min;
            return this;
        }

        /**
         * Runbook argument name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * The flag that indicates whether the argument is optional.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param optional New value for the property.
         */
        public Builder setOptional(java.lang.Boolean optional) {
            this.optional = optional;
            return this;
        }

        public OdsRunbookParameter build() {
            OdsRunbookParameter result = new OdsRunbookParameter();
            result.setDefaultValue(this.defaultValue);
            result.setMax(this.max);
            result.setMin(this.min);
            result.setName(this.name);
            result.setOptional(this.optional);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("default_value", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_value",
                                                                                "defaultValue",
                                                                                "getDefaultValue",
                                                                                "setDefaultValue");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max",
                                                                                "max",
                                                                                "getMax",
                                                                                "setMax");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min",
                                                                                "min",
                                                                                "getMin",
                                                                                "setMin");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("optional", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("optional",
                                                                                "optional",
                                                                                "getOptional",
                                                                                "setOptional");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parameter_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parameter_type",
                                                                                "parameterType",
                                                                                "getParameterType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ods_runbook_parameter",
                                                            fields,
                                                            com.vmware.nsx_policy.model.OdsRunbookParameter.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "parameter_type",
                                                            "OdsRunbookParameter");
    }
}

