/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * OSPF Interface configuration.
 */
public final class PolicyInterfaceOspfConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String NETWORK_TYPE_BROADCAST = "BROADCAST";

    public static final java.lang.String NETWORK_TYPE_P2P = "P2P";

    private java.lang.String bfdPath;

    private java.lang.Long deadInterval;

    private java.lang.Boolean enableBfd;

    private java.lang.Boolean enabled;

    private java.lang.Long helloInterval;

    private java.lang.String networkType;

    private java.lang.String ospfArea;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PolicyInterfaceOspfConfig() {
    }

    protected PolicyInterfaceOspfConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * This filed is valid only if enable_bfd is set to TRUE. If enable_bfd flag is set
     * to TRUE, this profile will be applied to all OSPF peers in this interface. If
     * this field is empty, bfd_path will refer to Tier-0 global BFD profile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBfdPath() {
        return this.bfdPath;
    }

    /**
     * This filed is valid only if enable_bfd is set to TRUE. If enable_bfd flag is set
     * to TRUE, this profile will be applied to all OSPF peers in this interface. If
     * this field is empty, bfd_path will refer to Tier-0 global BFD profile.
     *
     * @param bfdPath New value for the property.
     */
    public void setBfdPath(java.lang.String bfdPath) {
        this.bfdPath = bfdPath;
    }

    /**
     * Specifies the number of seconds that router must wait before it declares a OSPF
     * neighbor router down because it has not received OSPF hello packet. OSPF dead
     * interval should be minimum 3 times greater than the hello interval format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDeadInterval() {
        return this.deadInterval;
    }

    /**
     * Specifies the number of seconds that router must wait before it declares a OSPF
     * neighbor router down because it has not received OSPF hello packet. OSPF dead
     * interval should be minimum 3 times greater than the hello interval format: int32
     *
     * @param deadInterval New value for the property.
     */
    public void setDeadInterval(java.lang.Long deadInterval) {
        this.deadInterval = deadInterval;
    }

    /**
     * Enable/Disable OSPF to register for BFD event. Use FALSE to disable BFD.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableBfd() {
        return this.enableBfd;
    }

    /**
     * Enable/Disable OSPF to register for BFD event. Use FALSE to disable BFD.
     *
     * @param enableBfd New value for the property.
     */
    public void setEnableBfd(java.lang.Boolean enableBfd) {
        this.enableBfd = enableBfd;
    }

    /**
     * enable/disable OSPF on the interface. If enabled flag not specified, defailt is
     * enable OSPF.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * enable/disable OSPF on the interface. If enabled flag not specified, defailt is
     * enable OSPF.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Specifies the interval between the hello packets that OSPF sends on this
     * interface. OSPF hello interval should be less than the dead interval format:
     * int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getHelloInterval() {
        return this.helloInterval;
    }

    /**
     * Specifies the interval between the hello packets that OSPF sends on this
     * interface. OSPF hello interval should be less than the dead interval format:
     * int32
     *
     * @param helloInterval New value for the property.
     */
    public void setHelloInterval(java.lang.Long helloInterval) {
        this.helloInterval = helloInterval;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyInterfaceOspfConfig#NETWORK_TYPE_BROADCAST}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyInterfaceOspfConfig#NETWORK_TYPE_P2P}</li>
     * </ul> Configure OSPF networkt type, default is BROADCAST network type
     *
     * @return The current value of the property.
     */
    public java.lang.String getNetworkType() {
        return this.networkType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyInterfaceOspfConfig#NETWORK_TYPE_BROADCAST}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyInterfaceOspfConfig#NETWORK_TYPE_P2P}</li>
     * </ul> Configure OSPF networkt type, default is BROADCAST network type
     *
     * @param networkType New value for the property.
     */
    public void setNetworkType(java.lang.String networkType) {
        this.networkType = networkType;
    }

    /**
     * Attache Tier0 Interface to specified OSPF Area. all peers.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOspfArea() {
        return this.ospfArea;
    }

    /**
     * Attache Tier0 Interface to specified OSPF Area. all peers.
     *
     * @param ospfArea New value for the property.
     */
    public void setOspfArea(java.lang.String ospfArea) {
        this.ospfArea = ospfArea;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyInterfaceOspfConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("bfd_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bfdPath, this._getType().getField("bfd_path")));
        structValue.setField("dead_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deadInterval, this._getType().getField("dead_interval")));
        structValue.setField("enable_bfd",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableBfd, this._getType().getField("enable_bfd")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("hello_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.helloInterval, this._getType().getField("hello_interval")));
        structValue.setField("network_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.networkType, this._getType().getField("network_type")));
        structValue.setField("ospf_area",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ospfArea, this._getType().getField("ospf_area")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyInterfaceOspfConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.policyInterfaceOspfConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PolicyInterfaceOspfConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyInterfaceOspfConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PolicyInterfaceOspfConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyInterfaceOspfConfig(structValue);
    }

    /**
     * Builder class for {@link PolicyInterfaceOspfConfig}.
     */
    public static final class Builder {
        private java.lang.String bfdPath;
        private java.lang.Long deadInterval;
        private java.lang.Boolean enableBfd;
        private java.lang.Boolean enabled;
        private java.lang.Long helloInterval;
        private java.lang.String networkType;
        private java.lang.String ospfArea;

        /**
         * Constructor with parameters for the required properties of
         * {@link PolicyInterfaceOspfConfig}.
         */
        public Builder() {
        }

        /**
         * This filed is valid only if enable_bfd is set to TRUE. If enable_bfd flag is set
         * to TRUE, this profile will be applied to all OSPF peers in this interface. If
         * this field is empty, bfd_path will refer to Tier-0 global BFD profile.
         *
         * @param bfdPath New value for the property.
         */
        public Builder setBfdPath(java.lang.String bfdPath) {
            this.bfdPath = bfdPath;
            return this;
        }

        /**
         * Specifies the number of seconds that router must wait before it declares a OSPF
         * neighbor router down because it has not received OSPF hello packet. OSPF dead
         * interval should be minimum 3 times greater than the hello interval format: int32
         *
         * @param deadInterval New value for the property.
         */
        public Builder setDeadInterval(java.lang.Long deadInterval) {
            this.deadInterval = deadInterval;
            return this;
        }

        /**
         * Enable/Disable OSPF to register for BFD event. Use FALSE to disable BFD.
         *
         * @param enableBfd New value for the property.
         */
        public Builder setEnableBfd(java.lang.Boolean enableBfd) {
            this.enableBfd = enableBfd;
            return this;
        }

        /**
         * enable/disable OSPF on the interface. If enabled flag not specified, defailt is
         * enable OSPF.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Specifies the interval between the hello packets that OSPF sends on this
         * interface. OSPF hello interval should be less than the dead interval format:
         * int32
         *
         * @param helloInterval New value for the property.
         */
        public Builder setHelloInterval(java.lang.Long helloInterval) {
            this.helloInterval = helloInterval;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyInterfaceOspfConfig#NETWORK_TYPE_BROADCAST}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyInterfaceOspfConfig#NETWORK_TYPE_P2P}</li>
         * </ul> Configure OSPF networkt type, default is BROADCAST network type
         *
         * @param networkType New value for the property.
         */
        public Builder setNetworkType(java.lang.String networkType) {
            this.networkType = networkType;
            return this;
        }

        /**
         * Attache Tier0 Interface to specified OSPF Area. all peers.
         *
         * @param ospfArea New value for the property.
         */
        public Builder setOspfArea(java.lang.String ospfArea) {
            this.ospfArea = ospfArea;
            return this;
        }

        public PolicyInterfaceOspfConfig build() {
            PolicyInterfaceOspfConfig result = new PolicyInterfaceOspfConfig();
            result.setBfdPath(this.bfdPath);
            result.setDeadInterval(this.deadInterval);
            result.setEnableBfd(this.enableBfd);
            result.setEnabled(this.enabled);
            result.setHelloInterval(this.helloInterval);
            result.setNetworkType(this.networkType);
            result.setOspfArea(this.ospfArea);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("bfd_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bfd_path",
                                                                                "bfdPath",
                                                                                "getBfdPath",
                                                                                "setBfdPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dead_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dead_interval",
                                                                                "deadInterval",
                                                                                "getDeadInterval",
                                                                                "setDeadInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_bfd", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_bfd",
                                                                                "enableBfd",
                                                                                "getEnableBfd",
                                                                                "setEnableBfd");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hello_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hello_interval",
                                                                                "helloInterval",
                                                                                "getHelloInterval",
                                                                                "setHelloInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("network_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("network_type",
                                                                                "networkType",
                                                                                "getNetworkType",
                                                                                "setNetworkType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ospf_area", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ospf_area",
                                                                                "ospfArea",
                                                                                "getOspfArea",
                                                                                "setOspfArea");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.policy_interface_ospf_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.PolicyInterfaceOspfConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

