/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Represents a NAT rule between source and destination at T0/T1 router.
 */
public final class PolicyNatRule implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ACTION_SNAT = "SNAT";

    public static final java.lang.String ACTION_DNAT = "DNAT";

    public static final java.lang.String ACTION_REFLEXIVE = "REFLEXIVE";

    public static final java.lang.String ACTION_NO_SNAT = "NO_SNAT";

    public static final java.lang.String ACTION_NO_DNAT = "NO_DNAT";

    public static final java.lang.String ACTION_NAT64 = "NAT64";

    public static final java.lang.String FIREWALL_MATCH_MATCH_EXTERNAL_ADDRESS = "MATCH_EXTERNAL_ADDRESS";

    public static final java.lang.String FIREWALL_MATCH_MATCH_INTERNAL_ADDRESS = "MATCH_INTERNAL_ADDRESS";

    public static final java.lang.String FIREWALL_MATCH_BYPASS = "BYPASS";

    public static final java.lang.String POLICY_BASED_VPN_MODE_BYPASS = "BYPASS";

    public static final java.lang.String POLICY_BASED_VPN_MODE_MATCH = "MATCH";

    private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx_policy.model.Tag> tags;

    private java.lang.String originSiteId;

    private java.lang.String ownerId;

    private java.lang.String parentPath;

    private java.lang.String path;

    private java.lang.String realizationId;

    private java.lang.String relativePath;

    private java.lang.String remotePath;

    private java.lang.String uniqueId;

    private java.util.List<com.vmware.vapi.bindings.Structure> children;

    private java.lang.Boolean markedForDelete;

    private java.lang.Boolean overridden;

    private java.lang.String action;

    private java.lang.String destinationNetwork;

    private java.lang.Boolean enabled;

    private java.lang.String firewallMatch;

    private java.lang.Boolean logging;

    private java.lang.String policyBasedVpnMode;

    private java.util.List<java.lang.String> scope;

    private java.lang.Long sequenceNumber;

    private java.lang.String service;

    private java.lang.String sourceNetwork;

    private java.lang.String translatedNetwork;

    private java.lang.String translatedPorts;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PolicyNatRule() {
    }

    protected PolicyNatRule(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginSiteId() {
        return this.originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param originSiteId New value for the property.
     */
    public void setOriginSiteId(java.lang.String originSiteId) {
        this.originSiteId = originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing whoes owns this object. This
     * is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOwnerId() {
        return this.ownerId;
    }

    /**
     * This is a UUID generated by the system for knowing whoes owns this object. This
     * is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ownerId New value for the property.
     */
    public void setOwnerId(java.lang.String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParentPath() {
        return this.parentPath;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param parentPath New value for the property.
     */
    public void setParentPath(java.lang.String parentPath) {
        this.parentPath = parentPath;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPath() {
        return this.path;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param path New value for the property.
     */
    public void setPath(java.lang.String path) {
        this.path = path;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated thier unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRealizationId() {
        return this.realizationId;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated thier unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param realizationId New value for the property.
     */
    public void setRealizationId(java.lang.String realizationId) {
        this.realizationId = realizationId;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param relativePath New value for the property.
     */
    public void setRelativePath(java.lang.String relativePath) {
        this.relativePath = relativePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the PMaaS
     * service, and path of the object on PMaaS service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemotePath() {
        return this.remotePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the PMaaS
     * service, and path of the object on PMaaS service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remotePath New value for the property.
     */
    public void setRemotePath(java.lang.String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entites in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUniqueId() {
        return this.uniqueId;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entites in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param uniqueId New value for the property.
     */
    public void setUniqueId(java.lang.String uniqueId) {
        this.uniqueId = uniqueId;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
     * value of this class as a return value, the property will contain all the
     * properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getChildren() {
        return this.children;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @param children New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
     * value of this class as a return value, the property will contain all the
     * properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
     */
    public void setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
        this.children = children;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMarkedForDelete() {
        return this.markedForDelete;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param markedForDelete New value for the property.
     */
    public void setMarkedForDelete(java.lang.Boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOverridden() {
        return this.overridden;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overridden New value for the property.
     */
    public void setOverridden(java.lang.Boolean overridden) {
        this.overridden = overridden;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_SNAT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_DNAT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_REFLEXIVE}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NO_SNAT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NO_DNAT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NAT64}</li> </ul> Source
     * NAT(SNAT) - translates a source IP address in an outbound packet so that the
     * packet appears to originate from a different network. SNAT is only supported
     * when the logical router is running in active-standby mode. Destination NAT(DNAT)
     * - translates the destination IP address of inbound packets so that packets are
     * delivered to a target address into another network. DNAT is only supported when
     * the logical router is running in active-standby mode. Reflexive NAT(REFLEXIVE) -
     * IP-Range and CIDR are supported to define the \"n\". The number of original
     * networks should be exactly the same as that of translated networks. The address
     * translation is deterministic. Reflexive is supported on both Active/Standby and
     * Active/Active LR. NO_SNAT and NO_DNAT - These do not have support for
     * translated_fields, only source_network and destination_network fields are
     * supported. NAT64 - translates an external IPv6 address to a internal IPv4
     * address.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAction() {
        return this.action;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_SNAT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_DNAT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_REFLEXIVE}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NO_SNAT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NO_DNAT}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NAT64}</li> </ul> Source
     * NAT(SNAT) - translates a source IP address in an outbound packet so that the
     * packet appears to originate from a different network. SNAT is only supported
     * when the logical router is running in active-standby mode. Destination NAT(DNAT)
     * - translates the destination IP address of inbound packets so that packets are
     * delivered to a target address into another network. DNAT is only supported when
     * the logical router is running in active-standby mode. Reflexive NAT(REFLEXIVE) -
     * IP-Range and CIDR are supported to define the \"n\". The number of original
     * networks should be exactly the same as that of translated networks. The address
     * translation is deterministic. Reflexive is supported on both Active/Standby and
     * Active/Active LR. NO_SNAT and NO_DNAT - These do not have support for
     * translated_fields, only source_network and destination_network fields are
     * supported. NAT64 - translates an external IPv6 address to a internal IPv4
     * address.
     *
     * @param action New value for the property.
     */
    public void setAction(java.lang.String action) {
        this.action = action;
    }

    /**
     * This supports single IP address or comma separated list of single IP addresses
     * or CIDR. This does not support IP range or IP sets. For DNAT and NO_DNAT rules,
     * this is a mandatory field, and represents the destination network for the
     * incoming packets. For other type of rules, optionally it can contain destination
     * network of outgoing packets. NULL value for this field represents ANY network.
     * For VPC DNAT NATRule, destination network address should be IPv4 address
     * allocated from External Block associated with VPC. format:
     * list-of-address-or-block-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getDestinationNetwork() {
        return this.destinationNetwork;
    }

    /**
     * This supports single IP address or comma separated list of single IP addresses
     * or CIDR. This does not support IP range or IP sets. For DNAT and NO_DNAT rules,
     * this is a mandatory field, and represents the destination network for the
     * incoming packets. For other type of rules, optionally it can contain destination
     * network of outgoing packets. NULL value for this field represents ANY network.
     * For VPC DNAT NATRule, destination network address should be IPv4 address
     * allocated from External Block associated with VPC. format:
     * list-of-address-or-block-or-range
     *
     * @param destinationNetwork New value for the property.
     */
    public void setDestinationNetwork(java.lang.String destinationNetwork) {
        this.destinationNetwork = destinationNetwork;
    }

    /**
     * The flag, which suggests whether the NAT rule is enabled or disabled. The
     * default is True.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * The flag, which suggests whether the NAT rule is enabled or disabled. The
     * default is True.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_MATCH_EXTERNAL_ADDRESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_MATCH_INTERNAL_ADDRESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_BYPASS}</li> </ul> It
     * indicates how the firewall matches the address after NATing if firewall stage is
     * not skipped. MATCH_EXTERNAL_ADDRESS indicates the firewall will be applied to
     * external address of a NAT rule. For SNAT, the external address is the translated
     * source address after NAT is done. For DNAT, the external address is the original
     * destination address before NAT is done. For REFLEXIVE, to egress traffic, the
     * firewall will be applied to the translated source address after NAT is done; To
     * ingress traffic, the firewall will be applied to the original destination
     * address before NAT is done. MATCH_INTERNAL_ADDRESS indicates the firewall will
     * be applied to internal address of a NAT rule. For SNAT, the internal address is
     * the original source address before NAT is done. For DNAT, the internal address
     * is the translated destination address after NAT is done. For REFLEXIVE, to
     * egress traffic, the firewall will be applied to the original source address
     * before NAT is done; To ingress traffic, the firewall will be applied to the
     * translated destination address after NAT is done. BYPASS indicates the firewall
     * stage will be skipped. For NO_SNAT or NO_DNAT, it must be BYPASS or leave it
     * unassigned
     *
     * @return The current value of the property.
     */
    public java.lang.String getFirewallMatch() {
        return this.firewallMatch;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_MATCH_EXTERNAL_ADDRESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_MATCH_INTERNAL_ADDRESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_BYPASS}</li> </ul> It
     * indicates how the firewall matches the address after NATing if firewall stage is
     * not skipped. MATCH_EXTERNAL_ADDRESS indicates the firewall will be applied to
     * external address of a NAT rule. For SNAT, the external address is the translated
     * source address after NAT is done. For DNAT, the external address is the original
     * destination address before NAT is done. For REFLEXIVE, to egress traffic, the
     * firewall will be applied to the translated source address after NAT is done; To
     * ingress traffic, the firewall will be applied to the original destination
     * address before NAT is done. MATCH_INTERNAL_ADDRESS indicates the firewall will
     * be applied to internal address of a NAT rule. For SNAT, the internal address is
     * the original source address before NAT is done. For DNAT, the internal address
     * is the translated destination address after NAT is done. For REFLEXIVE, to
     * egress traffic, the firewall will be applied to the original source address
     * before NAT is done; To ingress traffic, the firewall will be applied to the
     * translated destination address after NAT is done. BYPASS indicates the firewall
     * stage will be skipped. For NO_SNAT or NO_DNAT, it must be BYPASS or leave it
     * unassigned
     *
     * @param firewallMatch New value for the property.
     */
    public void setFirewallMatch(java.lang.String firewallMatch) {
        this.firewallMatch = firewallMatch;
    }

    /**
     * The flag, which suggests whether the logging of NAT rule is enabled or disabled.
     * The default is False.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getLogging() {
        return this.logging;
    }

    /**
     * The flag, which suggests whether the logging of NAT rule is enabled or disabled.
     * The default is False.
     *
     * @param logging New value for the property.
     */
    public void setLogging(java.lang.Boolean logging) {
        this.logging = logging;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#POLICY_BASED_VPN_MODE_BYPASS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#POLICY_BASED_VPN_MODE_MATCH}</li>
     * </ul> It indicates how the NSX edge applies Nat Policy for VPN traffic. It is
     * supported only for Nat Rule action type DNAT and NO_DNAT. For all other NAT
     * action, leave it unassigned. BYPASS - Default vpn mode. It indicates that Nat
     * policy will be applied to the inbound traffic on Routed Based VPN tunnel, if the
     * policy based VTI is in the \"scope\" for this rule. Default value will be set to
     * BYPASS if MATCH - It indicates that this NAT rule will only match the Policy
     * Based VPN traffic.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPolicyBasedVpnMode() {
        return this.policyBasedVpnMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#POLICY_BASED_VPN_MODE_BYPASS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyNatRule#POLICY_BASED_VPN_MODE_MATCH}</li>
     * </ul> It indicates how the NSX edge applies Nat Policy for VPN traffic. It is
     * supported only for Nat Rule action type DNAT and NO_DNAT. For all other NAT
     * action, leave it unassigned. BYPASS - Default vpn mode. It indicates that Nat
     * policy will be applied to the inbound traffic on Routed Based VPN tunnel, if the
     * policy based VTI is in the \"scope\" for this rule. Default value will be set to
     * BYPASS if MATCH - It indicates that this NAT rule will only match the Policy
     * Based VPN traffic.
     *
     * @param policyBasedVpnMode New value for the property.
     */
    public void setPolicyBasedVpnMode(java.lang.String policyBasedVpnMode) {
        this.policyBasedVpnMode = policyBasedVpnMode;
    }

    /**
     * Represents the array of policy paths of ProviderInterface or NetworkInterface or
     * labels of type ProviderInterface or NetworkInterface or IPSecVpnSession on which
     * the NAT rule should get enforced. The interfaces must belong to the same router
     * for which the NAT Rule is created.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getScope() {
        return this.scope;
    }

    /**
     * Represents the array of policy paths of ProviderInterface or NetworkInterface or
     * labels of type ProviderInterface or NetworkInterface or IPSecVpnSession on which
     * the NAT rule should get enforced. The interfaces must belong to the same router
     * for which the NAT Rule is created.
     *
     * @param scope New value for the property.
     */
    public void setScope(java.util.List<java.lang.String> scope) {
        this.scope = scope;
    }

    /**
     * The sequence_number decides the rule_priority of a NAT rule. Sequence_number and
     * rule_priority have 1:1 mapping.For each NAT section, there will be reserved
     * rule_priority numbers.The valid range of rule_priority number is from 0 to
     * 2147483647(MAX_INT). 1. INTERNAL section rule_priority reserved from 0 - 1023
     * (1024 rules) valid sequence_number range 0 - 1023 2. USER section rule_priority
     * reserved from 1024 - 2147482623 (2147481600 rules) valid sequence_number range 0
     * - 2147481599 3. DEFAULT section rule_priority reserved from 2147482624 -
     * 2147483647 (1024 rules) valid sequence_number range 0 - 1023 format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    /**
     * The sequence_number decides the rule_priority of a NAT rule. Sequence_number and
     * rule_priority have 1:1 mapping.For each NAT section, there will be reserved
     * rule_priority numbers.The valid range of rule_priority number is from 0 to
     * 2147483647(MAX_INT). 1. INTERNAL section rule_priority reserved from 0 - 1023
     * (1024 rules) valid sequence_number range 0 - 1023 2. USER section rule_priority
     * reserved from 1024 - 2147482623 (2147481600 rules) valid sequence_number range 0
     * - 2147481599 3. DEFAULT section rule_priority reserved from 2147482624 -
     * 2147483647 (1024 rules) valid sequence_number range 0 - 1023 format: int32
     *
     * @param sequenceNumber New value for the property.
     */
    public void setSequenceNumber(java.lang.Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * It represents the path of Service on which the NAT rule will be applied. If not
     * provided or if it is blank then Policy manager will consider it as ANY. Please
     * note, if this is a DNAT, the destination_port of the service will be realized on
     * NSX Manager as the translated_port. And if this is a SNAT, the destination_port
     * will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getService() {
        return this.service;
    }

    /**
     * It represents the path of Service on which the NAT rule will be applied. If not
     * provided or if it is blank then Policy manager will consider it as ANY. Please
     * note, if this is a DNAT, the destination_port of the service will be realized on
     * NSX Manager as the translated_port. And if this is a SNAT, the destination_port
     * will be ignored.
     *
     * @param service New value for the property.
     */
    public void setService(java.lang.String service) {
        this.service = service;
    }

    /**
     * This supports single IP address or comma separated list of single IP addresses
     * or CIDR. This does not support IP range or IP sets. For SNAT, NO_SNAT, NAT64 and
     * REFLEXIVE rules, this is a mandatory field and represents the source network of
     * the packets leaving the network. For DNAT and NO_DNAT rules, optionally it can
     * contain source network of incoming packets. NULL value for this field represents
     * ANY network. format: list-of-address-or-block-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getSourceNetwork() {
        return this.sourceNetwork;
    }

    /**
     * This supports single IP address or comma separated list of single IP addresses
     * or CIDR. This does not support IP range or IP sets. For SNAT, NO_SNAT, NAT64 and
     * REFLEXIVE rules, this is a mandatory field and represents the source network of
     * the packets leaving the network. For DNAT and NO_DNAT rules, optionally it can
     * contain source network of incoming packets. NULL value for this field represents
     * ANY network. format: list-of-address-or-block-or-range
     *
     * @param sourceNetwork New value for the property.
     */
    public void setSourceNetwork(java.lang.String sourceNetwork) {
        this.sourceNetwork = sourceNetwork;
    }

    /**
     * This supports single IP address or comma separated list of single IP addresses
     * or CIDR. If user specify the CIDR, this value is actually used as an IP pool
     * that includes both the subnet and broadcast addresses as valid for NAT
     * translations. This does not support IP range or IP sets. Comma separated list of
     * single IP addresses is not suported for DNAT and REFLEXIVE rules. For SNAT,
     * DNAT, NAT64 and REFLEXIVE rules, this ia a mandatory field, which represents the
     * translated network address. For NO_SNAT and NO_DNAT this should be empty. For
     * VPC SNAT and Refelexive NATRule, translated network address should be IPv4
     * address allocated from External Block associated with VPC. format:
     * list-of-address-or-block-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getTranslatedNetwork() {
        return this.translatedNetwork;
    }

    /**
     * This supports single IP address or comma separated list of single IP addresses
     * or CIDR. If user specify the CIDR, this value is actually used as an IP pool
     * that includes both the subnet and broadcast addresses as valid for NAT
     * translations. This does not support IP range or IP sets. Comma separated list of
     * single IP addresses is not suported for DNAT and REFLEXIVE rules. For SNAT,
     * DNAT, NAT64 and REFLEXIVE rules, this ia a mandatory field, which represents the
     * translated network address. For NO_SNAT and NO_DNAT this should be empty. For
     * VPC SNAT and Refelexive NATRule, translated network address should be IPv4
     * address allocated from External Block associated with VPC. format:
     * list-of-address-or-block-or-range
     *
     * @param translatedNetwork New value for the property.
     */
    public void setTranslatedNetwork(java.lang.String translatedNetwork) {
        this.translatedNetwork = translatedNetwork;
    }

    /**
     * Please note, if there is service configured in this NAT rule, the
     * translated_port will be realized on NSX Manager as the destination_port. If
     * there is no sevice configured, the port will be ignored. format: port-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getTranslatedPorts() {
        return this.translatedPorts;
    }

    /**
     * Please note, if there is service configured in this NAT rule, the
     * translated_port will be realized on NSX Manager as the destination_port. If
     * there is no sevice configured, the port will be ignored. format: port-or-range
     *
     * @param translatedPorts New value for the property.
     */
    public void setTranslatedPorts(java.lang.String translatedPorts) {
        this.translatedPorts = translatedPorts;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyNatRule;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("origin_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originSiteId, this._getType().getField("origin_site_id")));
        structValue.setField("owner_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ownerId, this._getType().getField("owner_id")));
        structValue.setField("parent_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parentPath, this._getType().getField("parent_path")));
        structValue.setField("path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.path, this._getType().getField("path")));
        structValue.setField("realization_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realizationId, this._getType().getField("realization_id")));
        structValue.setField("relative_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.relativePath, this._getType().getField("relative_path")));
        structValue.setField("remote_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remotePath, this._getType().getField("remote_path")));
        structValue.setField("unique_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uniqueId, this._getType().getField("unique_id")));
        structValue.setField("children",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.children, this._getType().getField("children")));
        structValue.setField("marked_for_delete",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markedForDelete, this._getType().getField("marked_for_delete")));
        structValue.setField("overridden",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overridden, this._getType().getField("overridden")));
        structValue.setField("action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.action, this._getType().getField("action")));
        structValue.setField("destination_network",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationNetwork, this._getType().getField("destination_network")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("firewall_match",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.firewallMatch, this._getType().getField("firewall_match")));
        structValue.setField("logging",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logging, this._getType().getField("logging")));
        structValue.setField("policy_based_vpn_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.policyBasedVpnMode, this._getType().getField("policy_based_vpn_mode")));
        structValue.setField("scope",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.scope, this._getType().getField("scope")));
        structValue.setField("sequence_number",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sequenceNumber, this._getType().getField("sequence_number")));
        structValue.setField("service",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.service, this._getType().getField("service")));
        structValue.setField("source_network",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceNetwork, this._getType().getField("source_network")));
        structValue.setField("translated_network",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.translatedNetwork, this._getType().getField("translated_network")));
        structValue.setField("translated_ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.translatedPorts, this._getType().getField("translated_ports")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyNatRule;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.policyNatRule.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PolicyNatRule _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyNatRule(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PolicyNatRule _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyNatRule(structValue);
    }

    /**
     * Builder class for {@link PolicyNatRule}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx_policy.model.Tag> tags;
        private java.lang.String originSiteId;
        private java.lang.String ownerId;
        private java.lang.String parentPath;
        private java.lang.String path;
        private java.lang.String realizationId;
        private java.lang.String relativePath;
        private java.lang.String remotePath;
        private java.lang.String uniqueId;
        private java.util.List<com.vmware.vapi.bindings.Structure> children;
        private java.lang.Boolean markedForDelete;
        private java.lang.Boolean overridden;
        private java.lang.String action;
        private java.lang.String destinationNetwork;
        private java.lang.Boolean enabled;
        private java.lang.String firewallMatch;
        private java.lang.Boolean logging;
        private java.lang.String policyBasedVpnMode;
        private java.util.List<java.lang.String> scope;
        private java.lang.Long sequenceNumber;
        private java.lang.String service;
        private java.lang.String sourceNetwork;
        private java.lang.String translatedNetwork;
        private java.lang.String translatedPorts;

        /**
         * Constructor with parameters for the required properties of
         * {@link PolicyNatRule}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing which site owns an object.
         * This is used in Pmaas
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param originSiteId New value for the property.
         */
        public Builder setOriginSiteId(java.lang.String originSiteId) {
            this.originSiteId = originSiteId;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing whoes owns this object. This
         * is used in Pmaas
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ownerId New value for the property.
         */
        public Builder setOwnerId(java.lang.String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Path of its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param parentPath New value for the property.
         */
        public Builder setParentPath(java.lang.String parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        /**
         * Absolute path of this object
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param path New value for the property.
         */
        public Builder setPath(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * This is a UUID generated by the system for realizing the entity object. In most
         * cases this should be same as 'unique_id' of the entity. However, in some cases
         * this can be different because of entities have migrated thier unique identifier
         * to NSX Policy intent objects later in the timeline and did not use unique_id for
         * realization. Realization id is helpful for users to debug data path to correlate
         * the configuration with corresponding intent.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param realizationId New value for the property.
         */
        public Builder setRealizationId(java.lang.String realizationId) {
            this.realizationId = realizationId;
            return this;
        }

        /**
         * Path relative from its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param relativePath New value for the property.
         */
        public Builder setRelativePath(java.lang.String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        /**
         * This is the path of the object on the local managers when queried on the PMaaS
         * service, and path of the object on PMaaS service when queried from the local
         * managers.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remotePath New value for the property.
         */
        public Builder setRemotePath(java.lang.String remotePath) {
            this.remotePath = remotePath;
            return this;
        }

        /**
         * This is a UUID generated by the GM/LM to uniquely identify entites in a
         * federated environment. For entities that are stretched across multiple sites,
         * the same ID will be used on all the stretched sites.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param uniqueId New value for the property.
         */
        public Builder setUniqueId(java.lang.String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        /**
         * Subtree for this type within policy tree containing nested elements. Note that
         * this type is applicable to be used in Hierarchical API only.
         *
         * @param children New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
         * value of this class as a return value, the property will contain all the
         * properties defined in {@link
         * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
         */
        public Builder setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
            this.children = children;
            return this;
        }

        /**
         * Intent objects are not directly deleted from the system when a delete is invoked
         * on them. They are marked for deletion and only when all the realized entities
         * for that intent object gets deleted, the intent object is deleted. Objects that
         * are marked for deletion are not returned in GET call. One can use the search API
         * to get these objects.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param markedForDelete New value for the property.
         */
        public Builder setMarkedForDelete(java.lang.Boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
            return this;
        }

        /**
         * Global intent objects cannot be modified by the user. However, certain global
         * intent objects can be overridden locally by use of this property. In such cases,
         * the overridden local values take precedence over the globally defined values for
         * the properties.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overridden New value for the property.
         */
        public Builder setOverridden(java.lang.Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_SNAT}</li> <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_DNAT}</li> <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_REFLEXIVE}</li> <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NO_SNAT}</li> <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NO_DNAT}</li> <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#ACTION_NAT64}</li> </ul> Source
         * NAT(SNAT) - translates a source IP address in an outbound packet so that the
         * packet appears to originate from a different network. SNAT is only supported
         * when the logical router is running in active-standby mode. Destination NAT(DNAT)
         * - translates the destination IP address of inbound packets so that packets are
         * delivered to a target address into another network. DNAT is only supported when
         * the logical router is running in active-standby mode. Reflexive NAT(REFLEXIVE) -
         * IP-Range and CIDR are supported to define the \"n\". The number of original
         * networks should be exactly the same as that of translated networks. The address
         * translation is deterministic. Reflexive is supported on both Active/Standby and
         * Active/Active LR. NO_SNAT and NO_DNAT - These do not have support for
         * translated_fields, only source_network and destination_network fields are
         * supported. NAT64 - translates an external IPv6 address to a internal IPv4
         * address.
         *
         * @param action New value for the property.
         */
        public Builder setAction(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * This supports single IP address or comma separated list of single IP addresses
         * or CIDR. This does not support IP range or IP sets. For DNAT and NO_DNAT rules,
         * this is a mandatory field, and represents the destination network for the
         * incoming packets. For other type of rules, optionally it can contain destination
         * network of outgoing packets. NULL value for this field represents ANY network.
         * For VPC DNAT NATRule, destination network address should be IPv4 address
         * allocated from External Block associated with VPC. format:
         * list-of-address-or-block-or-range
         *
         * @param destinationNetwork New value for the property.
         */
        public Builder setDestinationNetwork(java.lang.String destinationNetwork) {
            this.destinationNetwork = destinationNetwork;
            return this;
        }

        /**
         * The flag, which suggests whether the NAT rule is enabled or disabled. The
         * default is True.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_MATCH_EXTERNAL_ADDRESS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_MATCH_INTERNAL_ADDRESS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#FIREWALL_MATCH_BYPASS}</li> </ul> It
         * indicates how the firewall matches the address after NATing if firewall stage is
         * not skipped. MATCH_EXTERNAL_ADDRESS indicates the firewall will be applied to
         * external address of a NAT rule. For SNAT, the external address is the translated
         * source address after NAT is done. For DNAT, the external address is the original
         * destination address before NAT is done. For REFLEXIVE, to egress traffic, the
         * firewall will be applied to the translated source address after NAT is done; To
         * ingress traffic, the firewall will be applied to the original destination
         * address before NAT is done. MATCH_INTERNAL_ADDRESS indicates the firewall will
         * be applied to internal address of a NAT rule. For SNAT, the internal address is
         * the original source address before NAT is done. For DNAT, the internal address
         * is the translated destination address after NAT is done. For REFLEXIVE, to
         * egress traffic, the firewall will be applied to the original source address
         * before NAT is done; To ingress traffic, the firewall will be applied to the
         * translated destination address after NAT is done. BYPASS indicates the firewall
         * stage will be skipped. For NO_SNAT or NO_DNAT, it must be BYPASS or leave it
         * unassigned
         *
         * @param firewallMatch New value for the property.
         */
        public Builder setFirewallMatch(java.lang.String firewallMatch) {
            this.firewallMatch = firewallMatch;
            return this;
        }

        /**
         * The flag, which suggests whether the logging of NAT rule is enabled or disabled.
         * The default is False.
         *
         * @param logging New value for the property.
         */
        public Builder setLogging(java.lang.Boolean logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#POLICY_BASED_VPN_MODE_BYPASS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyNatRule#POLICY_BASED_VPN_MODE_MATCH}</li>
         * </ul> It indicates how the NSX edge applies Nat Policy for VPN traffic. It is
         * supported only for Nat Rule action type DNAT and NO_DNAT. For all other NAT
         * action, leave it unassigned. BYPASS - Default vpn mode. It indicates that Nat
         * policy will be applied to the inbound traffic on Routed Based VPN tunnel, if the
         * policy based VTI is in the \"scope\" for this rule. Default value will be set to
         * BYPASS if MATCH - It indicates that this NAT rule will only match the Policy
         * Based VPN traffic.
         *
         * @param policyBasedVpnMode New value for the property.
         */
        public Builder setPolicyBasedVpnMode(java.lang.String policyBasedVpnMode) {
            this.policyBasedVpnMode = policyBasedVpnMode;
            return this;
        }

        /**
         * Represents the array of policy paths of ProviderInterface or NetworkInterface or
         * labels of type ProviderInterface or NetworkInterface or IPSecVpnSession on which
         * the NAT rule should get enforced. The interfaces must belong to the same router
         * for which the NAT Rule is created.
         *
         * @param scope New value for the property.
         */
        public Builder setScope(java.util.List<java.lang.String> scope) {
            this.scope = scope;
            return this;
        }

        /**
         * The sequence_number decides the rule_priority of a NAT rule. Sequence_number and
         * rule_priority have 1:1 mapping.For each NAT section, there will be reserved
         * rule_priority numbers.The valid range of rule_priority number is from 0 to
         * 2147483647(MAX_INT). 1. INTERNAL section rule_priority reserved from 0 - 1023
         * (1024 rules) valid sequence_number range 0 - 1023 2. USER section rule_priority
         * reserved from 1024 - 2147482623 (2147481600 rules) valid sequence_number range 0
         * - 2147481599 3. DEFAULT section rule_priority reserved from 2147482624 -
         * 2147483647 (1024 rules) valid sequence_number range 0 - 1023 format: int32
         *
         * @param sequenceNumber New value for the property.
         */
        public Builder setSequenceNumber(java.lang.Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        /**
         * It represents the path of Service on which the NAT rule will be applied. If not
         * provided or if it is blank then Policy manager will consider it as ANY. Please
         * note, if this is a DNAT, the destination_port of the service will be realized on
         * NSX Manager as the translated_port. And if this is a SNAT, the destination_port
         * will be ignored.
         *
         * @param service New value for the property.
         */
        public Builder setService(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * This supports single IP address or comma separated list of single IP addresses
         * or CIDR. This does not support IP range or IP sets. For SNAT, NO_SNAT, NAT64 and
         * REFLEXIVE rules, this is a mandatory field and represents the source network of
         * the packets leaving the network. For DNAT and NO_DNAT rules, optionally it can
         * contain source network of incoming packets. NULL value for this field represents
         * ANY network. format: list-of-address-or-block-or-range
         *
         * @param sourceNetwork New value for the property.
         */
        public Builder setSourceNetwork(java.lang.String sourceNetwork) {
            this.sourceNetwork = sourceNetwork;
            return this;
        }

        /**
         * This supports single IP address or comma separated list of single IP addresses
         * or CIDR. If user specify the CIDR, this value is actually used as an IP pool
         * that includes both the subnet and broadcast addresses as valid for NAT
         * translations. This does not support IP range or IP sets. Comma separated list of
         * single IP addresses is not suported for DNAT and REFLEXIVE rules. For SNAT,
         * DNAT, NAT64 and REFLEXIVE rules, this ia a mandatory field, which represents the
         * translated network address. For NO_SNAT and NO_DNAT this should be empty. For
         * VPC SNAT and Refelexive NATRule, translated network address should be IPv4
         * address allocated from External Block associated with VPC. format:
         * list-of-address-or-block-or-range
         *
         * @param translatedNetwork New value for the property.
         */
        public Builder setTranslatedNetwork(java.lang.String translatedNetwork) {
            this.translatedNetwork = translatedNetwork;
            return this;
        }

        /**
         * Please note, if there is service configured in this NAT rule, the
         * translated_port will be realized on NSX Manager as the destination_port. If
         * there is no sevice configured, the port will be ignored. format: port-or-range
         *
         * @param translatedPorts New value for the property.
         */
        public Builder setTranslatedPorts(java.lang.String translatedPorts) {
            this.translatedPorts = translatedPorts;
            return this;
        }

        public PolicyNatRule build() {
            PolicyNatRule result = new PolicyNatRule();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setOriginSiteId(this.originSiteId);
            result.setOwnerId(this.ownerId);
            result.setParentPath(this.parentPath);
            result.setPath(this.path);
            result.setRealizationId(this.realizationId);
            result.setRelativePath(this.relativePath);
            result.setRemotePath(this.remotePath);
            result.setUniqueId(this.uniqueId);
            result.setChildren(this.children);
            result.setMarkedForDelete(this.markedForDelete);
            result.setOverridden(this.overridden);
            result.setAction(this.action);
            result.setDestinationNetwork(this.destinationNetwork);
            result.setEnabled(this.enabled);
            result.setFirewallMatch(this.firewallMatch);
            result.setLogging(this.logging);
            result.setPolicyBasedVpnMode(this.policyBasedVpnMode);
            result.setScope(this.scope);
            result.setSequenceNumber(this.sequenceNumber);
            result.setService(this.service);
            result.setSourceNetwork(this.sourceNetwork);
            result.setTranslatedNetwork(this.translatedNetwork);
            result.setTranslatedPorts(this.translatedPorts);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_site_id",
                                                                                "originSiteId",
                                                                                "getOriginSiteId",
                                                                                "setOriginSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("owner_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("owner_id",
                                                                                "ownerId",
                                                                                "getOwnerId",
                                                                                "setOwnerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parent_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parent_path",
                                                                                "parentPath",
                                                                                "getParentPath",
                                                                                "setParentPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("path",
                                                                                "path",
                                                                                "getPath",
                                                                                "setPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realization_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realization_id",
                                                                                "realizationId",
                                                                                "getRealizationId",
                                                                                "setRealizationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("relative_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("relative_path",
                                                                                "relativePath",
                                                                                "getRelativePath",
                                                                                "setRelativePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_path",
                                                                                "remotePath",
                                                                                "getRemotePath",
                                                                                "setRemotePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unique_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unique_id",
                                                                                "uniqueId",
                                                                                "getUniqueId",
                                                                                "setUniqueId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("children", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.childPolicyConfigResource; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("children",
                                                                                "children",
                                                                                "getChildren",
                                                                                "setChildren");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("marked_for_delete", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("marked_for_delete",
                                                                                "markedForDelete",
                                                                                "getMarkedForDelete",
                                                                                "setMarkedForDelete");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overridden", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overridden",
                                                                                "overridden",
                                                                                "getOverridden",
                                                                                "setOverridden");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("action",
                                                                                "action",
                                                                                "getAction",
                                                                                "setAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("destination_network", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_network",
                                                                                "destinationNetwork",
                                                                                "getDestinationNetwork",
                                                                                "setDestinationNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("firewall_match", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("firewall_match",
                                                                                "firewallMatch",
                                                                                "getFirewallMatch",
                                                                                "setFirewallMatch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("logging", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("logging",
                                                                                "logging",
                                                                                "getLogging",
                                                                                "setLogging");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("policy_based_vpn_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("policy_based_vpn_mode",
                                                                                "policyBasedVpnMode",
                                                                                "getPolicyBasedVpnMode",
                                                                                "setPolicyBasedVpnMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("scope", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("scope",
                                                                                "scope",
                                                                                "getScope",
                                                                                "setScope");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sequence_number", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sequence_number",
                                                                                "sequenceNumber",
                                                                                "getSequenceNumber",
                                                                                "setSequenceNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service",
                                                                                "service",
                                                                                "getService",
                                                                                "setService");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_network", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_network",
                                                                                "sourceNetwork",
                                                                                "getSourceNetwork",
                                                                                "setSourceNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("translated_network", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("translated_network",
                                                                                "translatedNetwork",
                                                                                "getTranslatedNetwork",
                                                                                "setTranslatedNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("translated_ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("translated_ports",
                                                                                "translatedPorts",
                                                                                "getTranslatedPorts",
                                                                                "setTranslatedPorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.policy_nat_rule",
                                                            fields,
                                                            com.vmware.nsx_policy.model.PolicyNatRule.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

