/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * A ResourceObject contains the path and properties of the resource that needs to
 * be shared.
 */
public final class ResourceObject implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean includeChildren;

    private java.lang.String resourcePath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ResourceObject() {
    }

    protected ResourceObject(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Whether the children of the shared resource_path are shared (true) or just the
     * entity represented by the path is shared (false). The default value is false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIncludeChildren() {
        return this.includeChildren;
    }

    /**
     * Whether the children of the shared resource_path are shared (true) or just the
     * entity represented by the path is shared (false). The default value is false.
     *
     * @param includeChildren New value for the property.
     */
    public void setIncludeChildren(java.lang.Boolean includeChildren) {
        this.includeChildren = includeChildren;
    }

    /**
     * Represents the path of the resource to be shared. The entity represented by this
     * shared resources is shared with all the Orgs or Projects contexts that the Share
     * container references.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourcePath() {
        return this.resourcePath;
    }

    /**
     * Represents the path of the resource to be shared. The entity represented by this
     * shared resources is shared with all the Orgs or Projects contexts that the Share
     * container references.
     *
     * @param resourcePath New value for the property.
     */
    public void setResourcePath(java.lang.String resourcePath) {
        this.resourcePath = resourcePath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.resourceObject;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("include_children",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.includeChildren, this._getType().getField("include_children")));
        structValue.setField("resource_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourcePath, this._getType().getField("resource_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.resourceObject;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.resourceObject.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ResourceObject _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ResourceObject(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ResourceObject _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ResourceObject(structValue);
    }

    /**
     * Builder class for {@link ResourceObject}.
     */
    public static final class Builder {
        private java.lang.Boolean includeChildren;
        private java.lang.String resourcePath;

        /**
         * Constructor with parameters for the required properties of
         * {@link ResourceObject}.
         */
        public Builder() {
        }

        /**
         * Whether the children of the shared resource_path are shared (true) or just the
         * entity represented by the path is shared (false). The default value is false.
         *
         * @param includeChildren New value for the property.
         */
        public Builder setIncludeChildren(java.lang.Boolean includeChildren) {
            this.includeChildren = includeChildren;
            return this;
        }

        /**
         * Represents the path of the resource to be shared. The entity represented by this
         * shared resources is shared with all the Orgs or Projects contexts that the Share
         * container references.
         *
         * @param resourcePath New value for the property.
         */
        public Builder setResourcePath(java.lang.String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public ResourceObject build() {
            ResourceObject result = new ResourceObject();
            result.setIncludeChildren(this.includeChildren);
            result.setResourcePath(this.resourcePath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("include_children", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("include_children",
                                                                                "includeChildren",
                                                                                "getIncludeChildren",
                                                                                "setIncludeChildren");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_path",
                                                                                "resourcePath",
                                                                                "getResourcePath",
                                                                                "setResourcePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.resource_object",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ResourceObject.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

