/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced configuration for Segment
 */
public final class SegmentAdvancedConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CONNECTIVITY_ON = "ON";

    public static final java.lang.String CONNECTIVITY_OFF = "OFF";

    public static final java.lang.String ORIGIN_TYPE_VCENTER = "VCENTER";

    public static final java.lang.String URPF_MODE_NONE = "NONE";

    public static final java.lang.String URPF_MODE_STRICT = "STRICT";

    private java.lang.String connectivity;

    private java.util.List<java.lang.String> addressPoolPaths;

    private java.lang.Boolean hybrid;

    private java.lang.Boolean interRouter;

    private java.lang.Boolean localEgress;

    private java.util.List<com.vmware.nsx_policy.model.LocalEgressRoutingEntry> localEgressRoutingPolicies;

    private java.lang.Boolean multicast;

    private java.lang.String ndraProfilePath;

    private java.lang.Boolean nodeLocalSwitch;

    private java.lang.String originId;

    private java.lang.String originType;

    private java.lang.String uplinkTeamingPolicyName;

    private java.lang.String urpfMode;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SegmentAdvancedConfig() {
    }

    protected SegmentAdvancedConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.SegmentAdvancedConfig#CONNECTIVITY_ON}</li> <li>
     * {@link com.vmware.nsx_policy.model.SegmentAdvancedConfig#CONNECTIVITY_OFF}</li>
     * </ul> Connectivity configuration to manually connect (ON) or disconnect (OFF)
     * Tier-0/Tier1 segment from corresponding gateway. This property does not apply to
     * VLAN backed segments. VLAN backed segments with connectivity OFF does not affect
     * its layer-2 connectivity.
     *
     * @return The current value of the property.
     */
    public java.lang.String getConnectivity() {
        return this.connectivity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.SegmentAdvancedConfig#CONNECTIVITY_ON}</li> <li>
     * {@link com.vmware.nsx_policy.model.SegmentAdvancedConfig#CONNECTIVITY_OFF}</li>
     * </ul> Connectivity configuration to manually connect (ON) or disconnect (OFF)
     * Tier-0/Tier1 segment from corresponding gateway. This property does not apply to
     * VLAN backed segments. VLAN backed segments with connectivity OFF does not affect
     * its layer-2 connectivity.
     *
     * @param connectivity New value for the property.
     */
    public void setConnectivity(java.lang.String connectivity) {
        this.connectivity = connectivity;
    }

    /**
     * Policy path to IP address pools.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAddressPoolPaths() {
        return this.addressPoolPaths;
    }

    /**
     * Policy path to IP address pools.
     *
     * @param addressPoolPaths New value for the property.
     */
    public void setAddressPoolPaths(java.util.List<java.lang.String> addressPoolPaths) {
        this.addressPoolPaths = addressPoolPaths;
    }

    /**
     * When set to true, all the ports created on this segment will behave in a hybrid
     * fashion. The hybrid port indicates to NSX that the VM intends to operate in
     * underlay mode, but retains the ability to forward egress traffic to the NSX
     * overlay network. This property is only applicable for segment created with
     * transport zone type OVERLAY_STANDARD. This property cannot be modified after
     * segment is created.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHybrid() {
        return this.hybrid;
    }

    /**
     * When set to true, all the ports created on this segment will behave in a hybrid
     * fashion. The hybrid port indicates to NSX that the VM intends to operate in
     * underlay mode, but retains the ability to forward egress traffic to the NSX
     * overlay network. This property is only applicable for segment created with
     * transport zone type OVERLAY_STANDARD. This property cannot be modified after
     * segment is created.
     *
     * @param hybrid New value for the property.
     */
    public void setHybrid(java.lang.Boolean hybrid) {
        this.hybrid = hybrid;
    }

    /**
     * When set to true, any port attached to this logical switch will not be visible
     * through VC/ESX UI
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getInterRouter() {
        return this.interRouter;
    }

    /**
     * When set to true, any port attached to this logical switch will not be visible
     * through VC/ESX UI
     *
     * @param interRouter New value for the property.
     */
    public void setInterRouter(java.lang.Boolean interRouter) {
        this.interRouter = interRouter;
    }

    /**
     * This property is used to enable proximity routing with local egress. When set to
     * true, logical router interface (downlink) connecting Segment to Tier0/Tier1
     * gateway is configured with prefix-length 32.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getLocalEgress() {
        return this.localEgress;
    }

    /**
     * This property is used to enable proximity routing with local egress. When set to
     * true, logical router interface (downlink) connecting Segment to Tier0/Tier1
     * gateway is configured with prefix-length 32.
     *
     * @param localEgress New value for the property.
     */
    public void setLocalEgress(java.lang.Boolean localEgress) {
        this.localEgress = localEgress;
    }

    /**
     * An ordered list of routing policies to forward traffic to the next hop.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.LocalEgressRoutingEntry> getLocalEgressRoutingPolicies() {
        return this.localEgressRoutingPolicies;
    }

    /**
     * An ordered list of routing policies to forward traffic to the next hop.
     *
     * @param localEgressRoutingPolicies New value for the property.
     */
    public void setLocalEgressRoutingPolicies(java.util.List<com.vmware.nsx_policy.model.LocalEgressRoutingEntry> localEgressRoutingPolicies) {
        this.localEgressRoutingPolicies = localEgressRoutingPolicies;
    }

    /**
     * Enable multicast on the downlink LRP created to connect the segment to
     * Tier0/Tier1 gateway.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMulticast() {
        return this.multicast;
    }

    /**
     * Enable multicast on the downlink LRP created to connect the segment to
     * Tier0/Tier1 gateway.
     *
     * @param multicast New value for the property.
     */
    public void setMulticast(java.lang.Boolean multicast) {
        this.multicast = multicast;
    }

    /**
     * This profile is applie dto the downlink logical router port created while
     * attaching this semgnet to tier-0 or tier-1. If this field is empty, NDRA profile
     * of the router is applied to the newly created port.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNdraProfilePath() {
        return this.ndraProfilePath;
    }

    /**
     * This profile is applie dto the downlink logical router port created while
     * attaching this semgnet to tier-0 or tier-1. If this field is empty, NDRA profile
     * of the router is applied to the newly created port.
     *
     * @param ndraProfilePath New value for the property.
     */
    public void setNdraProfilePath(java.lang.String ndraProfilePath) {
        this.ndraProfilePath = ndraProfilePath;
    }

    /**
     * A behaviour required for Firewall As A Service (FaaS) where the segment BUM
     * traffic is confined within the edge node that this segment belongs to.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getNodeLocalSwitch() {
        return this.nodeLocalSwitch;
    }

    /**
     * A behaviour required for Firewall As A Service (FaaS) where the segment BUM
     * traffic is confined within the edge node that this segment belongs to.
     *
     * @param nodeLocalSwitch New value for the property.
     */
    public void setNodeLocalSwitch(java.lang.Boolean nodeLocalSwitch) {
        this.nodeLocalSwitch = nodeLocalSwitch;
    }

    /**
     * ID populated by NSX when NSX on DVPG is used to indicate the source DVPG.
     * Currently, only DVPortgroups are identified as Discovered Segments. The
     * origin_id is the identifier of DVPortgroup from the source vCenter server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginId() {
        return this.originId;
    }

    /**
     * ID populated by NSX when NSX on DVPG is used to indicate the source DVPG.
     * Currently, only DVPortgroups are identified as Discovered Segments. The
     * origin_id is the identifier of DVPortgroup from the source vCenter server.
     *
     * @param originId New value for the property.
     */
    public void setOriginId(java.lang.String originId) {
        this.originId = originId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.SegmentAdvancedConfig#ORIGIN_TYPE_VCENTER}</li>
     * </ul> The type of source from where the DVPortgroup is discovered
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginType() {
        return this.originType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.SegmentAdvancedConfig#ORIGIN_TYPE_VCENTER}</li>
     * </ul> The type of source from where the DVPortgroup is discovered
     *
     * @param originType New value for the property.
     */
    public void setOriginType(java.lang.String originType) {
        this.originType = originType;
    }

    /**
     * The name of the switching uplink teaming policy for the Segment. This name
     * corresponds to one of the switching uplink teaming policy names listed in
     * TransportZone associated with the Segment. See transport_zone_path property
     * above for more details. When this property is not specified, the segment will
     * not have a teaming policy associated with it and the host switch's default
     * teaming policy will be used by MP.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUplinkTeamingPolicyName() {
        return this.uplinkTeamingPolicyName;
    }

    /**
     * The name of the switching uplink teaming policy for the Segment. This name
     * corresponds to one of the switching uplink teaming policy names listed in
     * TransportZone associated with the Segment. See transport_zone_path property
     * above for more details. When this property is not specified, the segment will
     * not have a teaming policy associated with it and the host switch's default
     * teaming policy will be used by MP.
     *
     * @param uplinkTeamingPolicyName New value for the property.
     */
    public void setUplinkTeamingPolicyName(java.lang.String uplinkTeamingPolicyName) {
        this.uplinkTeamingPolicyName = uplinkTeamingPolicyName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.SegmentAdvancedConfig#URPF_MODE_NONE}</li> <li>
     * {@link com.vmware.nsx_policy.model.SegmentAdvancedConfig#URPF_MODE_STRICT}</li>
     * </ul> This URPF mode is applied to the downlink logical router port created
     * while attaching this segment to tier-0 or tier-1.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUrpfMode() {
        return this.urpfMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.SegmentAdvancedConfig#URPF_MODE_NONE}</li> <li>
     * {@link com.vmware.nsx_policy.model.SegmentAdvancedConfig#URPF_MODE_STRICT}</li>
     * </ul> This URPF mode is applied to the downlink logical router port created
     * while attaching this segment to tier-0 or tier-1.
     *
     * @param urpfMode New value for the property.
     */
    public void setUrpfMode(java.lang.String urpfMode) {
        this.urpfMode = urpfMode;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.segmentAdvancedConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("connectivity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectivity, this._getType().getField("connectivity")));
        structValue.setField("address_pool_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.addressPoolPaths, this._getType().getField("address_pool_paths")));
        structValue.setField("hybrid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hybrid, this._getType().getField("hybrid")));
        structValue.setField("inter_router",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interRouter, this._getType().getField("inter_router")));
        structValue.setField("local_egress",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localEgress, this._getType().getField("local_egress")));
        structValue.setField("local_egress_routing_policies",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localEgressRoutingPolicies, this._getType().getField("local_egress_routing_policies")));
        structValue.setField("multicast",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.multicast, this._getType().getField("multicast")));
        structValue.setField("ndra_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ndraProfilePath, this._getType().getField("ndra_profile_path")));
        structValue.setField("node_local_switch",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeLocalSwitch, this._getType().getField("node_local_switch")));
        structValue.setField("origin_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originId, this._getType().getField("origin_id")));
        structValue.setField("origin_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originType, this._getType().getField("origin_type")));
        structValue.setField("uplink_teaming_policy_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uplinkTeamingPolicyName, this._getType().getField("uplink_teaming_policy_name")));
        structValue.setField("urpf_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.urpfMode, this._getType().getField("urpf_mode")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.segmentAdvancedConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.segmentAdvancedConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SegmentAdvancedConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SegmentAdvancedConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SegmentAdvancedConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SegmentAdvancedConfig(structValue);
    }

    /**
     * Builder class for {@link SegmentAdvancedConfig}.
     */
    public static final class Builder {
        private java.lang.String connectivity;
        private java.util.List<java.lang.String> addressPoolPaths;
        private java.lang.Boolean hybrid;
        private java.lang.Boolean interRouter;
        private java.lang.Boolean localEgress;
        private java.util.List<com.vmware.nsx_policy.model.LocalEgressRoutingEntry> localEgressRoutingPolicies;
        private java.lang.Boolean multicast;
        private java.lang.String ndraProfilePath;
        private java.lang.Boolean nodeLocalSwitch;
        private java.lang.String originId;
        private java.lang.String originType;
        private java.lang.String uplinkTeamingPolicyName;
        private java.lang.String urpfMode;

        /**
         * Constructor with parameters for the required properties of
         * {@link SegmentAdvancedConfig}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.SegmentAdvancedConfig#CONNECTIVITY_ON}</li> <li>
         * {@link com.vmware.nsx_policy.model.SegmentAdvancedConfig#CONNECTIVITY_OFF}</li>
         * </ul> Connectivity configuration to manually connect (ON) or disconnect (OFF)
         * Tier-0/Tier1 segment from corresponding gateway. This property does not apply to
         * VLAN backed segments. VLAN backed segments with connectivity OFF does not affect
         * its layer-2 connectivity.
         *
         * @param connectivity New value for the property.
         */
        public Builder setConnectivity(java.lang.String connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        /**
         * Policy path to IP address pools.
         *
         * @param addressPoolPaths New value for the property.
         */
        public Builder setAddressPoolPaths(java.util.List<java.lang.String> addressPoolPaths) {
            this.addressPoolPaths = addressPoolPaths;
            return this;
        }

        /**
         * When set to true, all the ports created on this segment will behave in a hybrid
         * fashion. The hybrid port indicates to NSX that the VM intends to operate in
         * underlay mode, but retains the ability to forward egress traffic to the NSX
         * overlay network. This property is only applicable for segment created with
         * transport zone type OVERLAY_STANDARD. This property cannot be modified after
         * segment is created.
         *
         * @param hybrid New value for the property.
         */
        public Builder setHybrid(java.lang.Boolean hybrid) {
            this.hybrid = hybrid;
            return this;
        }

        /**
         * When set to true, any port attached to this logical switch will not be visible
         * through VC/ESX UI
         *
         * @param interRouter New value for the property.
         */
        public Builder setInterRouter(java.lang.Boolean interRouter) {
            this.interRouter = interRouter;
            return this;
        }

        /**
         * This property is used to enable proximity routing with local egress. When set to
         * true, logical router interface (downlink) connecting Segment to Tier0/Tier1
         * gateway is configured with prefix-length 32.
         *
         * @param localEgress New value for the property.
         */
        public Builder setLocalEgress(java.lang.Boolean localEgress) {
            this.localEgress = localEgress;
            return this;
        }

        /**
         * An ordered list of routing policies to forward traffic to the next hop.
         *
         * @param localEgressRoutingPolicies New value for the property.
         */
        public Builder setLocalEgressRoutingPolicies(java.util.List<com.vmware.nsx_policy.model.LocalEgressRoutingEntry> localEgressRoutingPolicies) {
            this.localEgressRoutingPolicies = localEgressRoutingPolicies;
            return this;
        }

        /**
         * Enable multicast on the downlink LRP created to connect the segment to
         * Tier0/Tier1 gateway.
         *
         * @param multicast New value for the property.
         */
        public Builder setMulticast(java.lang.Boolean multicast) {
            this.multicast = multicast;
            return this;
        }

        /**
         * This profile is applie dto the downlink logical router port created while
         * attaching this semgnet to tier-0 or tier-1. If this field is empty, NDRA profile
         * of the router is applied to the newly created port.
         *
         * @param ndraProfilePath New value for the property.
         */
        public Builder setNdraProfilePath(java.lang.String ndraProfilePath) {
            this.ndraProfilePath = ndraProfilePath;
            return this;
        }

        /**
         * A behaviour required for Firewall As A Service (FaaS) where the segment BUM
         * traffic is confined within the edge node that this segment belongs to.
         *
         * @param nodeLocalSwitch New value for the property.
         */
        public Builder setNodeLocalSwitch(java.lang.Boolean nodeLocalSwitch) {
            this.nodeLocalSwitch = nodeLocalSwitch;
            return this;
        }

        /**
         * ID populated by NSX when NSX on DVPG is used to indicate the source DVPG.
         * Currently, only DVPortgroups are identified as Discovered Segments. The
         * origin_id is the identifier of DVPortgroup from the source vCenter server.
         *
         * @param originId New value for the property.
         */
        public Builder setOriginId(java.lang.String originId) {
            this.originId = originId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.SegmentAdvancedConfig#ORIGIN_TYPE_VCENTER}</li>
         * </ul> The type of source from where the DVPortgroup is discovered
         *
         * @param originType New value for the property.
         */
        public Builder setOriginType(java.lang.String originType) {
            this.originType = originType;
            return this;
        }

        /**
         * The name of the switching uplink teaming policy for the Segment. This name
         * corresponds to one of the switching uplink teaming policy names listed in
         * TransportZone associated with the Segment. See transport_zone_path property
         * above for more details. When this property is not specified, the segment will
         * not have a teaming policy associated with it and the host switch's default
         * teaming policy will be used by MP.
         *
         * @param uplinkTeamingPolicyName New value for the property.
         */
        public Builder setUplinkTeamingPolicyName(java.lang.String uplinkTeamingPolicyName) {
            this.uplinkTeamingPolicyName = uplinkTeamingPolicyName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.SegmentAdvancedConfig#URPF_MODE_NONE}</li> <li>
         * {@link com.vmware.nsx_policy.model.SegmentAdvancedConfig#URPF_MODE_STRICT}</li>
         * </ul> This URPF mode is applied to the downlink logical router port created
         * while attaching this segment to tier-0 or tier-1.
         *
         * @param urpfMode New value for the property.
         */
        public Builder setUrpfMode(java.lang.String urpfMode) {
            this.urpfMode = urpfMode;
            return this;
        }

        public SegmentAdvancedConfig build() {
            SegmentAdvancedConfig result = new SegmentAdvancedConfig();
            result.setConnectivity(this.connectivity);
            result.setAddressPoolPaths(this.addressPoolPaths);
            result.setHybrid(this.hybrid);
            result.setInterRouter(this.interRouter);
            result.setLocalEgress(this.localEgress);
            result.setLocalEgressRoutingPolicies(this.localEgressRoutingPolicies);
            result.setMulticast(this.multicast);
            result.setNdraProfilePath(this.ndraProfilePath);
            result.setNodeLocalSwitch(this.nodeLocalSwitch);
            result.setOriginId(this.originId);
            result.setOriginType(this.originType);
            result.setUplinkTeamingPolicyName(this.uplinkTeamingPolicyName);
            result.setUrpfMode(this.urpfMode);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("connectivity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connectivity",
                                                                                "connectivity",
                                                                                "getConnectivity",
                                                                                "setConnectivity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("address_pool_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("address_pool_paths",
                                                                                "addressPoolPaths",
                                                                                "getAddressPoolPaths",
                                                                                "setAddressPoolPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hybrid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hybrid",
                                                                                "hybrid",
                                                                                "getHybrid",
                                                                                "setHybrid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("inter_router", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("inter_router",
                                                                                "interRouter",
                                                                                "getInterRouter",
                                                                                "setInterRouter");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("local_egress", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_egress",
                                                                                "localEgress",
                                                                                "getLocalEgress",
                                                                                "setLocalEgress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("local_egress_routing_policies", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.localEgressRoutingEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_egress_routing_policies",
                                                                                "localEgressRoutingPolicies",
                                                                                "getLocalEgressRoutingPolicies",
                                                                                "setLocalEgressRoutingPolicies");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("multicast", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("multicast",
                                                                                "multicast",
                                                                                "getMulticast",
                                                                                "setMulticast");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ndra_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ndra_profile_path",
                                                                                "ndraProfilePath",
                                                                                "getNdraProfilePath",
                                                                                "setNdraProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_local_switch", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_local_switch",
                                                                                "nodeLocalSwitch",
                                                                                "getNodeLocalSwitch",
                                                                                "setNodeLocalSwitch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_id",
                                                                                "originId",
                                                                                "getOriginId",
                                                                                "setOriginId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_type",
                                                                                "originType",
                                                                                "getOriginType",
                                                                                "setOriginType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uplink_teaming_policy_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uplink_teaming_policy_name",
                                                                                "uplinkTeamingPolicyName",
                                                                                "getUplinkTeamingPolicyName",
                                                                                "setUplinkTeamingPolicyName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("urpf_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("urpf_mode",
                                                                                "urpfMode",
                                                                                "getUrpfMode",
                                                                                "setUrpfMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.segment_advanced_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.SegmentAdvancedConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

