/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * TCP MSS Clamping Direction and Value.
 */
public final class TcpMaximumSegmentSizeClamping implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String DIRECTION_NONE = "NONE";

    public static final java.lang.String DIRECTION_INBOUND_CONNECTION = "INBOUND_CONNECTION";

    public static final java.lang.String DIRECTION_OUTBOUND_CONNECTION = "OUTBOUND_CONNECTION";

    public static final java.lang.String DIRECTION_BOTH = "BOTH";

    private java.lang.String direction;

    private java.lang.Long maxSegmentSize;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TcpMaximumSegmentSizeClamping() {
    }

    protected TcpMaximumSegmentSizeClamping(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_INBOUND_CONNECTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_OUTBOUND_CONNECTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_BOTH}</li>
     * </ul> Specifies the traffic direction for which to apply MSS Clamping.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDirection() {
        return this.direction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_INBOUND_CONNECTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_OUTBOUND_CONNECTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_BOTH}</li>
     * </ul> Specifies the traffic direction for which to apply MSS Clamping.
     *
     * @param direction New value for the property.
     */
    public void setDirection(java.lang.String direction) {
        this.direction = direction;
    }

    /**
     * MSS defines the maximum amount of data that a host is willing to accept in a
     * single TCP segment. This field is set in TCP header during connection
     * establishment. To avoid packet fragmentation, you can set this field depending
     * on uplink MTU and VPN overhead. This is an optional field and in case it is left
     * unconfigured, best possible MSS value will be calculated based on effective mtu
     * of uplink interface. Supported MSS range is 216 to 8960. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    /**
     * MSS defines the maximum amount of data that a host is willing to accept in a
     * single TCP segment. This field is set in TCP header during connection
     * establishment. To avoid packet fragmentation, you can set this field depending
     * on uplink MTU and VPN overhead. This is an optional field and in case it is left
     * unconfigured, best possible MSS value will be calculated based on effective mtu
     * of uplink interface. Supported MSS range is 216 to 8960. format: int64
     *
     * @param maxSegmentSize New value for the property.
     */
    public void setMaxSegmentSize(java.lang.Long maxSegmentSize) {
        this.maxSegmentSize = maxSegmentSize;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.tcpMaximumSegmentSizeClamping;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("direction",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.direction, this._getType().getField("direction")));
        structValue.setField("max_segment_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxSegmentSize, this._getType().getField("max_segment_size")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.tcpMaximumSegmentSizeClamping;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.tcpMaximumSegmentSizeClamping.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TcpMaximumSegmentSizeClamping _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TcpMaximumSegmentSizeClamping(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TcpMaximumSegmentSizeClamping _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TcpMaximumSegmentSizeClamping(structValue);
    }

    /**
     * Builder class for {@link TcpMaximumSegmentSizeClamping}.
     */
    public static final class Builder {
        private java.lang.String direction;
        private java.lang.Long maxSegmentSize;

        /**
         * Constructor with parameters for the required properties of
         * {@link TcpMaximumSegmentSizeClamping}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_INBOUND_CONNECTION}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_OUTBOUND_CONNECTION}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping#DIRECTION_BOTH}</li>
         * </ul> Specifies the traffic direction for which to apply MSS Clamping.
         *
         * @param direction New value for the property.
         */
        public Builder setDirection(java.lang.String direction) {
            this.direction = direction;
            return this;
        }

        /**
         * MSS defines the maximum amount of data that a host is willing to accept in a
         * single TCP segment. This field is set in TCP header during connection
         * establishment. To avoid packet fragmentation, you can set this field depending
         * on uplink MTU and VPN overhead. This is an optional field and in case it is left
         * unconfigured, best possible MSS value will be calculated based on effective mtu
         * of uplink interface. Supported MSS range is 216 to 8960. format: int64
         *
         * @param maxSegmentSize New value for the property.
         */
        public Builder setMaxSegmentSize(java.lang.Long maxSegmentSize) {
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        public TcpMaximumSegmentSizeClamping build() {
            TcpMaximumSegmentSizeClamping result = new TcpMaximumSegmentSizeClamping();
            result.setDirection(this.direction);
            result.setMaxSegmentSize(this.maxSegmentSize);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("direction", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("direction",
                                                                                "direction",
                                                                                "getDirection",
                                                                                "setDirection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_segment_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_segment_size",
                                                                                "maxSegmentSize",
                                                                                "getMaxSegmentSize",
                                                                                "setMaxSegmentSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.tcp_maximum_segment_size_clamping",
                                                            fields,
                                                            com.vmware.nsx_policy.model.TcpMaximumSegmentSizeClamping.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

