/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

public final class TraceflowObservationForwarded implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "TraceflowObservationForwarded";

    private java.lang.Long context;

    private java.lang.String dstTransportNodeId;

    private java.lang.String dstTransportNodeName;

    private java.lang.String localIpAddress;

    private java.lang.String remoteIpAddress;

    private java.lang.String uplinkName;

    private java.lang.Long vtepLabel;

    private java.lang.String componentName;

    private java.lang.String componentSubType;

    private java.lang.String componentType;

    private final java.lang.String resourceType = "TraceflowObservationForwarded";

    private java.lang.Long sequenceNo;

    private java.lang.String sitePath;

    private java.lang.Long timestamp;

    private java.lang.Long timestampMicro;

    private java.lang.String transportNodeId;

    private java.lang.String transportNodeName;

    private java.lang.String transportNodeType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TraceflowObservationForwarded() {
    }

    protected TraceflowObservationForwarded(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The 64bit tunnel context carried on the wire format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getContext() {
        return this.context;
    }

    /**
     * The 64bit tunnel context carried on the wire format: int64
     *
     * @param context New value for the property.
     */
    public void setContext(java.lang.Long context) {
        this.context = context;
    }

    /**
     * This field will not be always available. Use remote_ip_address when this field
     * is not set.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDstTransportNodeId() {
        return this.dstTransportNodeId;
    }

    /**
     * This field will not be always available. Use remote_ip_address when this field
     * is not set.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dstTransportNodeId New value for the property.
     */
    public void setDstTransportNodeId(java.lang.String dstTransportNodeId) {
        this.dstTransportNodeId = dstTransportNodeId;
    }

    /**
     * The name of the transport node to which the traceflow packet is forwarded
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDstTransportNodeName() {
        return this.dstTransportNodeName;
    }

    /**
     * The name of the transport node to which the traceflow packet is forwarded
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dstTransportNodeName New value for the property.
     */
    public void setDstTransportNodeName(java.lang.String dstTransportNodeName) {
        this.dstTransportNodeName = dstTransportNodeName;
    }

    /**
     * IP address of the source end of the tunnel format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocalIpAddress() {
        return this.localIpAddress;
    }

    /**
     * IP address of the source end of the tunnel format: ip
     *
     * @param localIpAddress New value for the property.
     */
    public void setLocalIpAddress(java.lang.String localIpAddress) {
        this.localIpAddress = localIpAddress;
    }

    /**
     * IP address of the destination end of the tunnel format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemoteIpAddress() {
        return this.remoteIpAddress;
    }

    /**
     * IP address of the destination end of the tunnel format: ip
     *
     * @param remoteIpAddress New value for the property.
     */
    public void setRemoteIpAddress(java.lang.String remoteIpAddress) {
        this.remoteIpAddress = remoteIpAddress;
    }

    /**
     * The name of the uplink the traceflow packet is forwarded on
     *
     * @return The current value of the property.
     */
    public java.lang.String getUplinkName() {
        return this.uplinkName;
    }

    /**
     * The name of the uplink the traceflow packet is forwarded on
     *
     * @param uplinkName New value for the property.
     */
    public void setUplinkName(java.lang.String uplinkName) {
        this.uplinkName = uplinkName;
    }

    /**
     * The virtual tunnel endpoint label format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getVtepLabel() {
        return this.vtepLabel;
    }

    /**
     * The virtual tunnel endpoint label format: int64
     *
     * @param vtepLabel New value for the property.
     */
    public void setVtepLabel(java.lang.Long vtepLabel) {
        this.vtepLabel = vtepLabel;
    }

    /**
     * The name of the component that issued the observation.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getComponentName() {
        return this.componentName;
    }

    /**
     * The name of the component that issued the observation.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param componentName New value for the property.
     */
    public void setComponentName(java.lang.String componentName) {
        this.componentName = componentName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_TIER0}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_TIER1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_VRF_TIER0}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LS_TRANSIT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_SI_CLASSIFIER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_SI_PROXY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_VDR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_ENI}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_AWS_GATEWAY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_TGW_ROUTE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_EDGE_UPLINK}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_DELL_GATEWAY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LGW_ROUTE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_KNI}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_UNKNOWN}</li>
     * </ul> The sub type of the component that issued the observation.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getComponentSubType() {
        return this.componentSubType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_TIER0}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_TIER1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_VRF_TIER0}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LS_TRANSIT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_SI_CLASSIFIER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_SI_PROXY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_VDR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_ENI}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_AWS_GATEWAY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_TGW_ROUTE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_EDGE_UPLINK}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_DELL_GATEWAY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LGW_ROUTE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_KNI}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_UNKNOWN}</li>
     * </ul> The sub type of the component that issued the observation.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param componentSubType New value for the property.
     */
    public void setComponentSubType(java.lang.String componentSubType) {
        this.componentSubType = componentSubType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_PHYSICAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LR}</li> <li>
     * {@link com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_DFW}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_BRIDGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_TUNNEL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_HOSTSWITCH}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_FW_BRIDGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_RTEP_TUNNEL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LOAD_BALANCER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_NAT}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_IPSEC}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_SERVICE_INSERTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_VMC}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_SPOOFGUARD}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_FW}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_DLB}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_SPOOFGUARD}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_LB}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_ROUTING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_DFW}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_FORWARDING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_HOST_SWITCH}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_UNKNOWN}</li>
     * </ul> The type of the component that issued the observation.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getComponentType() {
        return this.componentType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_PHYSICAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LR}</li> <li>
     * {@link com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_DFW}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_BRIDGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_TUNNEL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_HOSTSWITCH}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_FW_BRIDGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_RTEP_TUNNEL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LOAD_BALANCER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_NAT}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_IPSEC}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_SERVICE_INSERTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_VMC}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_SPOOFGUARD}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_FW}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_DLB}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_SPOOFGUARD}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_LB}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_ROUTING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_DFW}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_FORWARDING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_HOST_SWITCH}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_UNKNOWN}</li>
     * </ul> The type of the component that issued the observation.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param componentType New value for the property.
     */
    public void setComponentType(java.lang.String componentType) {
        this.componentType = componentType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONFORWARDED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONDROPPED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONDELIVERED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONRECEIVED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONFORWARDEDLOGICAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONDROPPEDLOGICAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONRECEIVEDLOGICAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONREPLICATIONLOGICAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONRELAYEDLOGICAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#RESOURCE_TYPE_TRACEFLOWOBSERVATIONPROTECTED}</li>
     * </ul>
     * The value of this property is automatically populated to {@code "TraceflowObservationForwarded"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * the hop count for observations on the transport node that a traceflow packet is
     * injected in will be 0. The hop count is incremented each time a subsequent
     * transport node receives the traceflow packet. The sequence number of 999
     * indicates that the hop count could not be determined for the containing
     * observation. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSequenceNo() {
        return this.sequenceNo;
    }

    /**
     * the hop count for observations on the transport node that a traceflow packet is
     * injected in will be 0. The hop count is incremented each time a subsequent
     * transport node receives the traceflow packet. The sequence number of 999
     * indicates that the hop count could not be determined for the containing
     * observation. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sequenceNo New value for the property.
     */
    public void setSequenceNo(java.lang.Long sequenceNo) {
        this.sequenceNo = sequenceNo;
    }

    /**
     * This field contains the site path where this observation was generated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSitePath() {
        return this.sitePath;
    }

    /**
     * This field contains the site path where this observation was generated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sitePath New value for the property.
     */
    public void setSitePath(java.lang.String sitePath) {
        this.sitePath = sitePath;
    }

    /**
     * Timestamp when the observation was created by the transport node (milliseconds
     * epoch) format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimestamp() {
        return this.timestamp;
    }

    /**
     * Timestamp when the observation was created by the transport node (milliseconds
     * epoch) format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param timestamp New value for the property.
     */
    public void setTimestamp(java.lang.Long timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * Timestamp when the observation was created by the transport node (microseconds
     * epoch) format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimestampMicro() {
        return this.timestampMicro;
    }

    /**
     * Timestamp when the observation was created by the transport node (microseconds
     * epoch) format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param timestampMicro New value for the property.
     */
    public void setTimestampMicro(java.lang.Long timestampMicro) {
        this.timestampMicro = timestampMicro;
    }

    /**
     * id of the transport node that observed a traceflow packet
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportNodeId() {
        return this.transportNodeId;
    }

    /**
     * id of the transport node that observed a traceflow packet
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportNodeId New value for the property.
     */
    public void setTransportNodeId(java.lang.String transportNodeId) {
        this.transportNodeId = transportNodeId;
    }

    /**
     * name of the transport node that observed a traceflow packet
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportNodeName() {
        return this.transportNodeName;
    }

    /**
     * name of the transport node that observed a traceflow packet
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportNodeName New value for the property.
     */
    public void setTransportNodeName(java.lang.String transportNodeName) {
        this.transportNodeName = transportNodeName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_ESX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELKVM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUKVM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSKVM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELCONTAINER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSCONTAINER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_SLESKVM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_SLESSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_WINDOWSSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELSMARTNIC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_OELSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUSMARTNIC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_EDGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_PUBLIC_CLOUD_GATEWAY_NODE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_OTHERS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_HYPERV}</li>
     * </ul> type of the transport node that observed a traceflow packet
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportNodeType() {
        return this.transportNodeType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_ESX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELKVM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUKVM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSKVM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELCONTAINER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSCONTAINER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_SLESKVM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_SLESSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_WINDOWSSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELSMARTNIC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_OELSERVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUSMARTNIC}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_EDGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_PUBLIC_CLOUD_GATEWAY_NODE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_OTHERS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_HYPERV}</li>
     * </ul> type of the transport node that observed a traceflow packet
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportNodeType New value for the property.
     */
    public void setTransportNodeType(java.lang.String transportNodeType) {
        this.transportNodeType = transportNodeType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.traceflowObservationForwarded;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("context",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.context, this._getType().getField("context")));
        structValue.setField("dst_transport_node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dstTransportNodeId, this._getType().getField("dst_transport_node_id")));
        structValue.setField("dst_transport_node_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dstTransportNodeName, this._getType().getField("dst_transport_node_name")));
        structValue.setField("local_ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localIpAddress, this._getType().getField("local_ip_address")));
        structValue.setField("remote_ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remoteIpAddress, this._getType().getField("remote_ip_address")));
        structValue.setField("uplink_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uplinkName, this._getType().getField("uplink_name")));
        structValue.setField("vtep_label",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vtepLabel, this._getType().getField("vtep_label")));
        structValue.setField("component_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.componentName, this._getType().getField("component_name")));
        structValue.setField("component_sub_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.componentSubType, this._getType().getField("component_sub_type")));
        structValue.setField("component_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.componentType, this._getType().getField("component_type")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("sequence_no",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sequenceNo, this._getType().getField("sequence_no")));
        structValue.setField("site_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sitePath, this._getType().getField("site_path")));
        structValue.setField("timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timestamp, this._getType().getField("timestamp")));
        structValue.setField("timestamp_micro",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timestampMicro, this._getType().getField("timestamp_micro")));
        structValue.setField("transport_node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeId, this._getType().getField("transport_node_id")));
        structValue.setField("transport_node_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeName, this._getType().getField("transport_node_name")));
        structValue.setField("transport_node_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeType, this._getType().getField("transport_node_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.traceflowObservationForwarded;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.traceflowObservationForwarded.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TraceflowObservationForwarded _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TraceflowObservationForwarded(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TraceflowObservationForwarded _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TraceflowObservationForwarded(structValue);
    }

    /**
     * Builder class for {@link TraceflowObservationForwarded}.
     */
    public static final class Builder {
        private java.lang.Long context;
        private java.lang.String dstTransportNodeId;
        private java.lang.String dstTransportNodeName;
        private java.lang.String localIpAddress;
        private java.lang.String remoteIpAddress;
        private java.lang.String uplinkName;
        private java.lang.Long vtepLabel;
        private java.lang.String componentName;
        private java.lang.String componentSubType;
        private java.lang.String componentType;
        private java.lang.Long sequenceNo;
        private java.lang.String sitePath;
        private java.lang.Long timestamp;
        private java.lang.Long timestampMicro;
        private java.lang.String transportNodeId;
        private java.lang.String transportNodeName;
        private java.lang.String transportNodeType;

        /**
         * Constructor with parameters for the required properties of
         * {@link TraceflowObservationForwarded}.
         */
        public Builder() {
        }

        /**
         * The 64bit tunnel context carried on the wire format: int64
         *
         * @param context New value for the property.
         */
        public Builder setContext(java.lang.Long context) {
            this.context = context;
            return this;
        }

        /**
         * This field will not be always available. Use remote_ip_address when this field
         * is not set.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dstTransportNodeId New value for the property.
         */
        public Builder setDstTransportNodeId(java.lang.String dstTransportNodeId) {
            this.dstTransportNodeId = dstTransportNodeId;
            return this;
        }

        /**
         * The name of the transport node to which the traceflow packet is forwarded
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dstTransportNodeName New value for the property.
         */
        public Builder setDstTransportNodeName(java.lang.String dstTransportNodeName) {
            this.dstTransportNodeName = dstTransportNodeName;
            return this;
        }

        /**
         * IP address of the source end of the tunnel format: ip
         *
         * @param localIpAddress New value for the property.
         */
        public Builder setLocalIpAddress(java.lang.String localIpAddress) {
            this.localIpAddress = localIpAddress;
            return this;
        }

        /**
         * IP address of the destination end of the tunnel format: ip
         *
         * @param remoteIpAddress New value for the property.
         */
        public Builder setRemoteIpAddress(java.lang.String remoteIpAddress) {
            this.remoteIpAddress = remoteIpAddress;
            return this;
        }

        /**
         * The name of the uplink the traceflow packet is forwarded on
         *
         * @param uplinkName New value for the property.
         */
        public Builder setUplinkName(java.lang.String uplinkName) {
            this.uplinkName = uplinkName;
            return this;
        }

        /**
         * The virtual tunnel endpoint label format: int64
         *
         * @param vtepLabel New value for the property.
         */
        public Builder setVtepLabel(java.lang.Long vtepLabel) {
            this.vtepLabel = vtepLabel;
            return this;
        }

        /**
         * The name of the component that issued the observation.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param componentName New value for the property.
         */
        public Builder setComponentName(java.lang.String componentName) {
            this.componentName = componentName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_TIER0}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_TIER1}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_VRF_TIER0}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LS_TRANSIT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_SI_CLASSIFIER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_SI_PROXY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_VDR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_ENI}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_AWS_GATEWAY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_TGW_ROUTE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_EDGE_UPLINK}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_DELL_GATEWAY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LGW_ROUTE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_LR_KNI}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_SUB_TYPE_UNKNOWN}</li>
         * </ul> The sub type of the component that issued the observation.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param componentSubType New value for the property.
         */
        public Builder setComponentSubType(java.lang.String componentSubType) {
            this.componentSubType = componentSubType;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_PHYSICAL}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LR}</li> <li>
         * {@link com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_DFW}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_BRIDGE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_TUNNEL}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_HOSTSWITCH}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_FW_BRIDGE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_RTEP_TUNNEL}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_LOAD_BALANCER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_NAT}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_IPSEC}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_SERVICE_INSERTION}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_VMC}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_SPOOFGUARD}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_EDGE_FW}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_DLB}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_SPOOFGUARD}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_LB}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_ROUTING}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_DFW}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_ANTREA_FORWARDING}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_HOST_SWITCH}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#COMPONENT_TYPE_UNKNOWN}</li>
         * </ul> The type of the component that issued the observation.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param componentType New value for the property.
         */
        public Builder setComponentType(java.lang.String componentType) {
            this.componentType = componentType;
            return this;
        }

        /**
         * the hop count for observations on the transport node that a traceflow packet is
         * injected in will be 0. The hop count is incremented each time a subsequent
         * transport node receives the traceflow packet. The sequence number of 999
         * indicates that the hop count could not be determined for the containing
         * observation. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sequenceNo New value for the property.
         */
        public Builder setSequenceNo(java.lang.Long sequenceNo) {
            this.sequenceNo = sequenceNo;
            return this;
        }

        /**
         * This field contains the site path where this observation was generated.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sitePath New value for the property.
         */
        public Builder setSitePath(java.lang.String sitePath) {
            this.sitePath = sitePath;
            return this;
        }

        /**
         * Timestamp when the observation was created by the transport node (milliseconds
         * epoch) format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param timestamp New value for the property.
         */
        public Builder setTimestamp(java.lang.Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        /**
         * Timestamp when the observation was created by the transport node (microseconds
         * epoch) format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param timestampMicro New value for the property.
         */
        public Builder setTimestampMicro(java.lang.Long timestampMicro) {
            this.timestampMicro = timestampMicro;
            return this;
        }

        /**
         * id of the transport node that observed a traceflow packet
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportNodeId New value for the property.
         */
        public Builder setTransportNodeId(java.lang.String transportNodeId) {
            this.transportNodeId = transportNodeId;
            return this;
        }

        /**
         * name of the transport node that observed a traceflow packet
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportNodeName New value for the property.
         */
        public Builder setTransportNodeName(java.lang.String transportNodeName) {
            this.transportNodeName = transportNodeName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_ESX}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELKVM}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUKVM}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSKVM}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELCONTAINER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSCONTAINER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELSERVER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUSERVER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_CENTOSSERVER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_SLESKVM}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_SLESSERVER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_WINDOWSSERVER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_RHELSMARTNIC}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_OELSERVER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_UBUNTUSMARTNIC}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_EDGE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_PUBLIC_CLOUD_GATEWAY_NODE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_OTHERS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TraceflowObservation#TRANSPORT_NODE_TYPE_HYPERV}</li>
         * </ul> type of the transport node that observed a traceflow packet
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportNodeType New value for the property.
         */
        public Builder setTransportNodeType(java.lang.String transportNodeType) {
            this.transportNodeType = transportNodeType;
            return this;
        }

        public TraceflowObservationForwarded build() {
            TraceflowObservationForwarded result = new TraceflowObservationForwarded();
            result.setContext(this.context);
            result.setDstTransportNodeId(this.dstTransportNodeId);
            result.setDstTransportNodeName(this.dstTransportNodeName);
            result.setLocalIpAddress(this.localIpAddress);
            result.setRemoteIpAddress(this.remoteIpAddress);
            result.setUplinkName(this.uplinkName);
            result.setVtepLabel(this.vtepLabel);
            result.setComponentName(this.componentName);
            result.setComponentSubType(this.componentSubType);
            result.setComponentType(this.componentType);
            result.setSequenceNo(this.sequenceNo);
            result.setSitePath(this.sitePath);
            result.setTimestamp(this.timestamp);
            result.setTimestampMicro(this.timestampMicro);
            result.setTransportNodeId(this.transportNodeId);
            result.setTransportNodeName(this.transportNodeName);
            result.setTransportNodeType(this.transportNodeType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("context", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("context",
                                                                                "context",
                                                                                "getContext",
                                                                                "setContext");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dst_transport_node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dst_transport_node_id",
                                                                                "dstTransportNodeId",
                                                                                "getDstTransportNodeId",
                                                                                "setDstTransportNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dst_transport_node_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dst_transport_node_name",
                                                                                "dstTransportNodeName",
                                                                                "getDstTransportNodeName",
                                                                                "setDstTransportNodeName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("local_ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_ip_address",
                                                                                "localIpAddress",
                                                                                "getLocalIpAddress",
                                                                                "setLocalIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_ip_address",
                                                                                "remoteIpAddress",
                                                                                "getRemoteIpAddress",
                                                                                "setRemoteIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uplink_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uplink_name",
                                                                                "uplinkName",
                                                                                "getUplinkName",
                                                                                "setUplinkName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vtep_label", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vtep_label",
                                                                                "vtepLabel",
                                                                                "getVtepLabel",
                                                                                "setVtepLabel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("component_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("component_name",
                                                                                "componentName",
                                                                                "getComponentName",
                                                                                "setComponentName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("component_sub_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("component_sub_type",
                                                                                "componentSubType",
                                                                                "getComponentSubType",
                                                                                "setComponentSubType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("component_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("component_type",
                                                                                "componentType",
                                                                                "getComponentType",
                                                                                "setComponentType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sequence_no", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sequence_no",
                                                                                "sequenceNo",
                                                                                "getSequenceNo",
                                                                                "setSequenceNo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_path",
                                                                                "sitePath",
                                                                                "getSitePath",
                                                                                "setSitePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("timestamp",
                                                                                "timestamp",
                                                                                "getTimestamp",
                                                                                "setTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("timestamp_micro", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("timestamp_micro",
                                                                                "timestampMicro",
                                                                                "getTimestampMicro",
                                                                                "setTimestampMicro");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_id",
                                                                                "transportNodeId",
                                                                                "getTransportNodeId",
                                                                                "setTransportNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_name",
                                                                                "transportNodeName",
                                                                                "getTransportNodeName",
                                                                                "setTransportNodeName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_type",
                                                                                "transportNodeType",
                                                                                "getTransportNodeType",
                                                                                "setTransportNodeType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.traceflow_observation_forwarded",
                                                            fields,
                                                            com.vmware.nsx_policy.model.TraceflowObservationForwarded.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "TraceflowObservationForwarded");
    }
}

