/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Realization state of attaching or detaching Transport node profile on compute
 * collection.
 */
public final class TransportNodeCollectionState implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String STATE_FAILED_TO_CREATE = "FAILED_TO_CREATE";

    public static final java.lang.String STATE_FAILED_TO_REALIZE = "FAILED_TO_REALIZE";

    public static final java.lang.String STATE_IN_PROGRESS = "IN_PROGRESS";

    public static final java.lang.String STATE_PROFILE_MISMATCH = "PROFILE_MISMATCH";

    public static final java.lang.String STATE_SUCCESS = "SUCCESS";

    private java.lang.Long aggregateProgressPercentage;

    private java.lang.String clusterLevelError;

    private java.lang.String state;

    private java.util.List<com.vmware.nsx_policy.model.ValidationError> validationErrors;

    private java.lang.String vlcmTransitionError;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TransportNodeCollectionState() {
    }

    protected TransportNodeCollectionState(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Average of all transport node deployment progress in a cluster. Applicable only
     * if transport node profile is applied on a cluster. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAggregateProgressPercentage() {
        return this.aggregateProgressPercentage;
    }

    /**
     * Average of all transport node deployment progress in a cluster. Applicable only
     * if transport node profile is applied on a cluster. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param aggregateProgressPercentage New value for the property.
     */
    public void setAggregateProgressPercentage(java.lang.Long aggregateProgressPercentage) {
        this.aggregateProgressPercentage = aggregateProgressPercentage;
    }

    /**
     * Errors while applying transport node profile which need cluster level action to
     * resolve
     *
     * @return The current value of the property.
     */
    public java.lang.String getClusterLevelError() {
        return this.clusterLevelError;
    }

    /**
     * Errors while applying transport node profile which need cluster level action to
     * resolve
     *
     * @param clusterLevelError New value for the property.
     */
    public void setClusterLevelError(java.lang.String clusterLevelError) {
        this.clusterLevelError = clusterLevelError;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_FAILED_TO_CREATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_FAILED_TO_REALIZE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_PROFILE_MISMATCH}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_SUCCESS}</li>
     * </ul> If the host preparation or transport node creation is going on for any
     * host then state will be \"IN_PROGRESS\". If setting desired state of the
     * transport node failed for any of the host then state will be
     * \"FAILED_TO_CREATE\" If realization of transport node failed for any of the host
     * then state will be \"FAILED_TO_REALIZE\" If Transport node is successfully
     * created for all of the hosts in compute collection then state will be
     * \"SUCCESS\" You can override the configuration for one or more hosts in the
     * compute collection by update TN(transport node) request on individual TN. If TN
     * is successfully created for all hosts in compute collection and one or more
     * hosts have overridden configuration then transport node collection state will be
     * \"PROFILE_MISMATCH\".
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getState() {
        return this.state;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_FAILED_TO_CREATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_FAILED_TO_REALIZE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_PROFILE_MISMATCH}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_SUCCESS}</li>
     * </ul> If the host preparation or transport node creation is going on for any
     * host then state will be \"IN_PROGRESS\". If setting desired state of the
     * transport node failed for any of the host then state will be
     * \"FAILED_TO_CREATE\" If realization of transport node failed for any of the host
     * then state will be \"FAILED_TO_REALIZE\" If Transport node is successfully
     * created for all of the hosts in compute collection then state will be
     * \"SUCCESS\" You can override the configuration for one or more hosts in the
     * compute collection by update TN(transport node) request on individual TN. If TN
     * is successfully created for all hosts in compute collection and one or more
     * hosts have overridden configuration then transport node collection state will be
     * \"PROFILE_MISMATCH\".
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param state New value for the property.
     */
    public void setState(java.lang.String state) {
        this.state = state;
    }

    /**
     * Transport node profile(TNP) will not be applied to a discovered node(DN) if some
     * validations are not passed. In this case transport node is not created or
     * existing transport node is not updated with TNP configurations.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    /**
     * Transport node profile(TNP) will not be applied to a discovered node(DN) if some
     * validations are not passed. In this case transport node is not created or
     * existing transport node is not updated with TNP configurations.
     *
     * @param validationErrors New value for the property.
     */
    public void setValidationErrors(java.util.List<com.vmware.nsx_policy.model.ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    /**
     * When vLCM is enabled on a compute collection in vSphere the transition workflow
     * is triggered. This field indicates error in this special case.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVlcmTransitionError() {
        return this.vlcmTransitionError;
    }

    /**
     * When vLCM is enabled on a compute collection in vSphere the transition workflow
     * is triggered. This field indicates error in this special case.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vlcmTransitionError New value for the property.
     */
    public void setVlcmTransitionError(java.lang.String vlcmTransitionError) {
        this.vlcmTransitionError = vlcmTransitionError;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.transportNodeCollectionState;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("aggregate_progress_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.aggregateProgressPercentage, this._getType().getField("aggregate_progress_percentage")));
        structValue.setField("cluster_level_error",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clusterLevelError, this._getType().getField("cluster_level_error")));
        structValue.setField("state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.state, this._getType().getField("state")));
        structValue.setField("validation_errors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.validationErrors, this._getType().getField("validation_errors")));
        structValue.setField("vlcm_transition_error",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vlcmTransitionError, this._getType().getField("vlcm_transition_error")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.transportNodeCollectionState;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.transportNodeCollectionState.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TransportNodeCollectionState _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TransportNodeCollectionState(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TransportNodeCollectionState _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TransportNodeCollectionState(structValue);
    }

    /**
     * Builder class for {@link TransportNodeCollectionState}.
     */
    public static final class Builder {
        private java.lang.Long aggregateProgressPercentage;
        private java.lang.String clusterLevelError;
        private java.lang.String state;
        private java.util.List<com.vmware.nsx_policy.model.ValidationError> validationErrors;
        private java.lang.String vlcmTransitionError;

        /**
         * Constructor with parameters for the required properties of
         * {@link TransportNodeCollectionState}.
         */
        public Builder() {
        }

        /**
         * Average of all transport node deployment progress in a cluster. Applicable only
         * if transport node profile is applied on a cluster. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param aggregateProgressPercentage New value for the property.
         */
        public Builder setAggregateProgressPercentage(java.lang.Long aggregateProgressPercentage) {
            this.aggregateProgressPercentage = aggregateProgressPercentage;
            return this;
        }

        /**
         * Errors while applying transport node profile which need cluster level action to
         * resolve
         *
         * @param clusterLevelError New value for the property.
         */
        public Builder setClusterLevelError(java.lang.String clusterLevelError) {
            this.clusterLevelError = clusterLevelError;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_FAILED_TO_CREATE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_FAILED_TO_REALIZE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_IN_PROGRESS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_PROFILE_MISMATCH}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TransportNodeCollectionState#STATE_SUCCESS}</li>
         * </ul> If the host preparation or transport node creation is going on for any
         * host then state will be \"IN_PROGRESS\". If setting desired state of the
         * transport node failed for any of the host then state will be
         * \"FAILED_TO_CREATE\" If realization of transport node failed for any of the host
         * then state will be \"FAILED_TO_REALIZE\" If Transport node is successfully
         * created for all of the hosts in compute collection then state will be
         * \"SUCCESS\" You can override the configuration for one or more hosts in the
         * compute collection by update TN(transport node) request on individual TN. If TN
         * is successfully created for all hosts in compute collection and one or more
         * hosts have overridden configuration then transport node collection state will be
         * \"PROFILE_MISMATCH\".
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param state New value for the property.
         */
        public Builder setState(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Transport node profile(TNP) will not be applied to a discovered node(DN) if some
         * validations are not passed. In this case transport node is not created or
         * existing transport node is not updated with TNP configurations.
         *
         * @param validationErrors New value for the property.
         */
        public Builder setValidationErrors(java.util.List<com.vmware.nsx_policy.model.ValidationError> validationErrors) {
            this.validationErrors = validationErrors;
            return this;
        }

        /**
         * When vLCM is enabled on a compute collection in vSphere the transition workflow
         * is triggered. This field indicates error in this special case.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vlcmTransitionError New value for the property.
         */
        public Builder setVlcmTransitionError(java.lang.String vlcmTransitionError) {
            this.vlcmTransitionError = vlcmTransitionError;
            return this;
        }

        public TransportNodeCollectionState build() {
            TransportNodeCollectionState result = new TransportNodeCollectionState();
            result.setAggregateProgressPercentage(this.aggregateProgressPercentage);
            result.setClusterLevelError(this.clusterLevelError);
            result.setState(this.state);
            result.setValidationErrors(this.validationErrors);
            result.setVlcmTransitionError(this.vlcmTransitionError);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("aggregate_progress_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("aggregate_progress_percentage",
                                                                                "aggregateProgressPercentage",
                                                                                "getAggregateProgressPercentage",
                                                                                "setAggregateProgressPercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cluster_level_error", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cluster_level_error",
                                                                                "clusterLevelError",
                                                                                "getClusterLevelError",
                                                                                "setClusterLevelError");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("state",
                                                                                "state",
                                                                                "getState",
                                                                                "setState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("validation_errors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.validationError; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("validation_errors",
                                                                                "validationErrors",
                                                                                "getValidationErrors",
                                                                                "setValidationErrors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vlcm_transition_error", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vlcm_transition_error",
                                                                                "vlcmTransitionError",
                                                                                "getVlcmTransitionError",
                                                                                "setVlcmTransitionError");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.transport_node_collection_state",
                                                            fields,
                                                            com.vmware.nsx_policy.model.TransportNodeCollectionState.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

