/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Realized state of the VPC Subnet, this will show user information related to ip
 * pool, dhcp etc.
 */
public final class VpcSubnetStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String IP_ADDRESS_TYPE_IPV4 = "IPV4";

    public static final java.lang.String IP_ADDRESS_TYPE_IPV6 = "IPV6";

    private java.lang.String dhcpRanges;

    private java.lang.String dhcpServerAddress;

    private java.lang.String gatewayAddress;

    private java.lang.String ipAddressType;

    private java.lang.String networkAddress;

    private java.lang.String staticIpPoolPath;

    private java.lang.String staticIpPoolRange;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public VpcSubnetStatus() {
    }

    protected VpcSubnetStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * DHCP address ranges are used for dynamic IP allocation. Existing values cannot
     * be deleted or modified
     *
     * @return The current value of the property.
     */
    public java.lang.String getDhcpRanges() {
        return this.dhcpRanges;
    }

    /**
     * DHCP address ranges are used for dynamic IP allocation. Existing values cannot
     * be deleted or modified
     *
     * @param dhcpRanges New value for the property.
     */
    public void setDhcpRanges(java.lang.String dhcpRanges) {
        this.dhcpRanges = dhcpRanges;
    }

    /**
     * Dhcp server IP address.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDhcpServerAddress() {
        return this.dhcpServerAddress;
    }

    /**
     * Dhcp server IP address.
     *
     * @param dhcpServerAddress New value for the property.
     */
    public void setDhcpServerAddress(java.lang.String dhcpServerAddress) {
        this.dhcpServerAddress = dhcpServerAddress;
    }

    /**
     * Gateway address of the VPC Subnet
     *
     * @return The current value of the property.
     */
    public java.lang.String getGatewayAddress() {
        return this.gatewayAddress;
    }

    /**
     * Gateway address of the VPC Subnet
     *
     * @param gatewayAddress New value for the property.
     */
    public void setGatewayAddress(java.lang.String gatewayAddress) {
        this.gatewayAddress = gatewayAddress;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.VpcSubnetStatus#IP_ADDRESS_TYPE_IPV4}</li> <li>
     * {@link com.vmware.nsx_policy.model.VpcSubnetStatus#IP_ADDRESS_TYPE_IPV6}</li>
     * </ul> This defines the IP address type that will be allocated for VPC Subnets.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddressType() {
        return this.ipAddressType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.VpcSubnetStatus#IP_ADDRESS_TYPE_IPV4}</li> <li>
     * {@link com.vmware.nsx_policy.model.VpcSubnetStatus#IP_ADDRESS_TYPE_IPV6}</li>
     * </ul> This defines the IP address type that will be allocated for VPC Subnets.
     *
     * @param ipAddressType New value for the property.
     */
    public void setIpAddressType(java.lang.String ipAddressType) {
        this.ipAddressType = ipAddressType;
    }

    /**
     * Network address of the VPC Subnet
     *
     * @return The current value of the property.
     */
    public java.lang.String getNetworkAddress() {
        return this.networkAddress;
    }

    /**
     * Network address of the VPC Subnet
     *
     * @param networkAddress New value for the property.
     */
    public void setNetworkAddress(java.lang.String networkAddress) {
        this.networkAddress = networkAddress;
    }

    /**
     * Static IP Pool used to allocate IPs. For ex, for DHCP static binding, LB VIP
     * etc. This will also have pool usage inforamation.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStaticIpPoolPath() {
        return this.staticIpPoolPath;
    }

    /**
     * Static IP Pool used to allocate IPs. For ex, for DHCP static binding, LB VIP
     * etc. This will also have pool usage inforamation.
     *
     * @param staticIpPoolPath New value for the property.
     */
    public void setStaticIpPoolPath(java.lang.String staticIpPoolPath) {
        this.staticIpPoolPath = staticIpPoolPath;
    }

    /**
     * Static IP address ranges used for IP allocation.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStaticIpPoolRange() {
        return this.staticIpPoolRange;
    }

    /**
     * Static IP address ranges used for IP allocation.
     *
     * @param staticIpPoolRange New value for the property.
     */
    public void setStaticIpPoolRange(java.lang.String staticIpPoolRange) {
        this.staticIpPoolRange = staticIpPoolRange;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.vpcSubnetStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dhcp_ranges",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpRanges, this._getType().getField("dhcp_ranges")));
        structValue.setField("dhcp_server_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpServerAddress, this._getType().getField("dhcp_server_address")));
        structValue.setField("gateway_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gatewayAddress, this._getType().getField("gateway_address")));
        structValue.setField("ip_address_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddressType, this._getType().getField("ip_address_type")));
        structValue.setField("network_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.networkAddress, this._getType().getField("network_address")));
        structValue.setField("static_ip_pool_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.staticIpPoolPath, this._getType().getField("static_ip_pool_path")));
        structValue.setField("static_ip_pool_range",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.staticIpPoolRange, this._getType().getField("static_ip_pool_range")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.vpcSubnetStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.vpcSubnetStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static VpcSubnetStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new VpcSubnetStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static VpcSubnetStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new VpcSubnetStatus(structValue);
    }

    /**
     * Builder class for {@link VpcSubnetStatus}.
     */
    public static final class Builder {
        private java.lang.String dhcpRanges;
        private java.lang.String dhcpServerAddress;
        private java.lang.String gatewayAddress;
        private java.lang.String ipAddressType;
        private java.lang.String networkAddress;
        private java.lang.String staticIpPoolPath;
        private java.lang.String staticIpPoolRange;

        /**
         * Constructor with parameters for the required properties of
         * {@link VpcSubnetStatus}.
         */
        public Builder() {
        }

        /**
         * DHCP address ranges are used for dynamic IP allocation. Existing values cannot
         * be deleted or modified
         *
         * @param dhcpRanges New value for the property.
         */
        public Builder setDhcpRanges(java.lang.String dhcpRanges) {
            this.dhcpRanges = dhcpRanges;
            return this;
        }

        /**
         * Dhcp server IP address.
         *
         * @param dhcpServerAddress New value for the property.
         */
        public Builder setDhcpServerAddress(java.lang.String dhcpServerAddress) {
            this.dhcpServerAddress = dhcpServerAddress;
            return this;
        }

        /**
         * Gateway address of the VPC Subnet
         *
         * @param gatewayAddress New value for the property.
         */
        public Builder setGatewayAddress(java.lang.String gatewayAddress) {
            this.gatewayAddress = gatewayAddress;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.VpcSubnetStatus#IP_ADDRESS_TYPE_IPV4}</li> <li>
         * {@link com.vmware.nsx_policy.model.VpcSubnetStatus#IP_ADDRESS_TYPE_IPV6}</li>
         * </ul> This defines the IP address type that will be allocated for VPC Subnets.
         *
         * @param ipAddressType New value for the property.
         */
        public Builder setIpAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Network address of the VPC Subnet
         *
         * @param networkAddress New value for the property.
         */
        public Builder setNetworkAddress(java.lang.String networkAddress) {
            this.networkAddress = networkAddress;
            return this;
        }

        /**
         * Static IP Pool used to allocate IPs. For ex, for DHCP static binding, LB VIP
         * etc. This will also have pool usage inforamation.
         *
         * @param staticIpPoolPath New value for the property.
         */
        public Builder setStaticIpPoolPath(java.lang.String staticIpPoolPath) {
            this.staticIpPoolPath = staticIpPoolPath;
            return this;
        }

        /**
         * Static IP address ranges used for IP allocation.
         *
         * @param staticIpPoolRange New value for the property.
         */
        public Builder setStaticIpPoolRange(java.lang.String staticIpPoolRange) {
            this.staticIpPoolRange = staticIpPoolRange;
            return this;
        }

        public VpcSubnetStatus build() {
            VpcSubnetStatus result = new VpcSubnetStatus();
            result.setDhcpRanges(this.dhcpRanges);
            result.setDhcpServerAddress(this.dhcpServerAddress);
            result.setGatewayAddress(this.gatewayAddress);
            result.setIpAddressType(this.ipAddressType);
            result.setNetworkAddress(this.networkAddress);
            result.setStaticIpPoolPath(this.staticIpPoolPath);
            result.setStaticIpPoolRange(this.staticIpPoolRange);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dhcp_ranges", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_ranges",
                                                                                "dhcpRanges",
                                                                                "getDhcpRanges",
                                                                                "setDhcpRanges");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcp_server_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_server_address",
                                                                                "dhcpServerAddress",
                                                                                "getDhcpServerAddress",
                                                                                "setDhcpServerAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("gateway_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("gateway_address",
                                                                                "gatewayAddress",
                                                                                "getGatewayAddress",
                                                                                "setGatewayAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address_type",
                                                                                "ipAddressType",
                                                                                "getIpAddressType",
                                                                                "setIpAddressType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("network_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("network_address",
                                                                                "networkAddress",
                                                                                "getNetworkAddress",
                                                                                "setNetworkAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("static_ip_pool_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("static_ip_pool_path",
                                                                                "staticIpPoolPath",
                                                                                "getStaticIpPoolPath",
                                                                                "setStaticIpPoolPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("static_ip_pool_range", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("static_ip_pool_range",
                                                                                "staticIpPoolRange",
                                                                                "getStaticIpPoolRange",
                                                                                "setStaticIpPoolRange");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.vpc_subnet_status",
                                                            fields,
                                                            com.vmware.nsx_policy.model.VpcSubnetStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

