/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

public final class X509Certificate implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ECDSA_EC_FIELD_F2M = "F2M";

    public static final java.lang.String ECDSA_EC_FIELD_FP = "FP";

    private java.lang.String dsaPublicKeyg;

    private java.lang.String dsaPublicKeyp;

    private java.lang.String dsaPublicKeyq;

    private java.lang.String dsaPublicKeyy;

    private java.lang.String ecdsaCurveName;

    private java.lang.String ecdsaEcField;

    private java.util.List<java.lang.Long> ecdsaEcFieldF2mks;

    private java.lang.Long ecdsaEcFieldF2mm;

    private java.lang.String ecdsaEcFieldF2mrp;

    private java.lang.String ecdsaEcFieldF2pp;

    private java.lang.String ecdsaPublicKeya;

    private java.lang.String ecdsaPublicKeyb;

    private java.lang.Long ecdsaPublicKeyCofactor;

    private java.lang.String ecdsaPublicKeyGeneratorx;

    private java.lang.String ecdsaPublicKeyGeneratory;

    private java.lang.String ecdsaPublicKeyOrder;

    private java.util.List<java.lang.String> ecdsaPublicKeySeed;

    private java.lang.Boolean isCa;

    private java.lang.Boolean isValid;

    private java.lang.String issuer;

    private java.lang.String issuerCn;

    private java.lang.Long notAfter;

    private java.lang.Long notBefore;

    private java.lang.String publicKeyAlgo;

    private java.lang.Long publicKeyLength;

    private java.lang.String rsaPublicKeyExponent;

    private java.lang.String rsaPublicKeyModulus;

    private java.lang.String serialNumber;

    private java.lang.String sha256Thumbprint;

    private java.lang.String signature;

    private java.lang.String signatureAlgorithm;

    private java.lang.String subject;

    private java.lang.String subjectCn;

    private java.lang.String version;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public X509Certificate() {
    }

    protected X509Certificate(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * One of the DSA cryptogaphic algorithm's strength parameters, base.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDsaPublicKeyg() {
        return this.dsaPublicKeyg;
    }

    /**
     * One of the DSA cryptogaphic algorithm's strength parameters, base.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dsaPublicKeyg New value for the property.
     */
    public void setDsaPublicKeyg(java.lang.String dsaPublicKeyg) {
        this.dsaPublicKeyg = dsaPublicKeyg;
    }

    /**
     * One of the DSA cryptogaphic algorithm's strength parameters, prime.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDsaPublicKeyp() {
        return this.dsaPublicKeyp;
    }

    /**
     * One of the DSA cryptogaphic algorithm's strength parameters, prime.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dsaPublicKeyp New value for the property.
     */
    public void setDsaPublicKeyp(java.lang.String dsaPublicKeyp) {
        this.dsaPublicKeyp = dsaPublicKeyp;
    }

    /**
     * One of the DSA cryptogaphic algorithm's strength parameters, sub-prime.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDsaPublicKeyq() {
        return this.dsaPublicKeyq;
    }

    /**
     * One of the DSA cryptogaphic algorithm's strength parameters, sub-prime.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dsaPublicKeyq New value for the property.
     */
    public void setDsaPublicKeyq(java.lang.String dsaPublicKeyq) {
        this.dsaPublicKeyq = dsaPublicKeyq;
    }

    /**
     * One of the DSA cryptogaphic algorithm's strength parameters.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDsaPublicKeyy() {
        return this.dsaPublicKeyy;
    }

    /**
     * One of the DSA cryptogaphic algorithm's strength parameters.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dsaPublicKeyy New value for the property.
     */
    public void setDsaPublicKeyy(java.lang.String dsaPublicKeyy) {
        this.dsaPublicKeyy = dsaPublicKeyy;
    }

    /**
     * The Curve name for the ECDSA certificate.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaCurveName() {
        return this.ecdsaCurveName;
    }

    /**
     * The Curve name for the ECDSA certificate.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaCurveName New value for the property.
     */
    public void setEcdsaCurveName(java.lang.String ecdsaCurveName) {
        this.ecdsaCurveName = ecdsaCurveName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.X509Certificate#ECDSA_EC_FIELD_F2M}</li> <li> {@link
     * com.vmware.nsx_policy.model.X509Certificate#ECDSA_EC_FIELD_FP}</li> </ul>
     * Represents an elliptic curve (EC) finite field in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaEcField() {
        return this.ecdsaEcField;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.X509Certificate#ECDSA_EC_FIELD_F2M}</li> <li> {@link
     * com.vmware.nsx_policy.model.X509Certificate#ECDSA_EC_FIELD_FP}</li> </ul>
     * Represents an elliptic curve (EC) finite field in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaEcField New value for the property.
     */
    public void setEcdsaEcField(java.lang.String ecdsaEcField) {
        this.ecdsaEcField = ecdsaEcField;
    }

    /**
     * The order of the middle term(s) of the reduction polynomial in elliptic curve
     * (EC) | characteristic 2 finite field.| Contents of this array are copied to
     * protect against subsequent modification in ECDSA. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.Long> getEcdsaEcFieldF2mks() {
        return this.ecdsaEcFieldF2mks;
    }

    /**
     * The order of the middle term(s) of the reduction polynomial in elliptic curve
     * (EC) | characteristic 2 finite field.| Contents of this array are copied to
     * protect against subsequent modification in ECDSA. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaEcFieldF2mks New value for the property.
     */
    public void setEcdsaEcFieldF2mks(java.util.List<java.lang.Long> ecdsaEcFieldF2mks) {
        this.ecdsaEcFieldF2mks = ecdsaEcFieldF2mks;
    }

    /**
     * The first coefficient of this elliptic curve in elliptic curve (EC) |
     * characteristic 2 finite field for ECDSA. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEcdsaEcFieldF2mm() {
        return this.ecdsaEcFieldF2mm;
    }

    /**
     * The first coefficient of this elliptic curve in elliptic curve (EC) |
     * characteristic 2 finite field for ECDSA. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaEcFieldF2mm New value for the property.
     */
    public void setEcdsaEcFieldF2mm(java.lang.Long ecdsaEcFieldF2mm) {
        this.ecdsaEcFieldF2mm = ecdsaEcFieldF2mm;
    }

    /**
     * The value whose i-th bit corresponds to the i-th coefficient of the reduction
     * polynomial | in elliptic curve (EC) characteristic 2 finite field for ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaEcFieldF2mrp() {
        return this.ecdsaEcFieldF2mrp;
    }

    /**
     * The value whose i-th bit corresponds to the i-th coefficient of the reduction
     * polynomial | in elliptic curve (EC) characteristic 2 finite field for ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaEcFieldF2mrp New value for the property.
     */
    public void setEcdsaEcFieldF2mrp(java.lang.String ecdsaEcFieldF2mrp) {
        this.ecdsaEcFieldF2mrp = ecdsaEcFieldF2mrp;
    }

    /**
     * The specified prime for the elliptic curve prime finite field in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaEcFieldF2pp() {
        return this.ecdsaEcFieldF2pp;
    }

    /**
     * The specified prime for the elliptic curve prime finite field in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaEcFieldF2pp New value for the property.
     */
    public void setEcdsaEcFieldF2pp(java.lang.String ecdsaEcFieldF2pp) {
        this.ecdsaEcFieldF2pp = ecdsaEcFieldF2pp;
    }

    /**
     * The first coefficient of this elliptic curve in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaPublicKeya() {
        return this.ecdsaPublicKeya;
    }

    /**
     * The first coefficient of this elliptic curve in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaPublicKeya New value for the property.
     */
    public void setEcdsaPublicKeya(java.lang.String ecdsaPublicKeya) {
        this.ecdsaPublicKeya = ecdsaPublicKeya;
    }

    /**
     * The second coefficient of this elliptic curve in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaPublicKeyb() {
        return this.ecdsaPublicKeyb;
    }

    /**
     * The second coefficient of this elliptic curve in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaPublicKeyb New value for the property.
     */
    public void setEcdsaPublicKeyb(java.lang.String ecdsaPublicKeyb) {
        this.ecdsaPublicKeyb = ecdsaPublicKeyb;
    }

    /**
     * The co-factor in ECDSA. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEcdsaPublicKeyCofactor() {
        return this.ecdsaPublicKeyCofactor;
    }

    /**
     * The co-factor in ECDSA. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaPublicKeyCofactor New value for the property.
     */
    public void setEcdsaPublicKeyCofactor(java.lang.Long ecdsaPublicKeyCofactor) {
        this.ecdsaPublicKeyCofactor = ecdsaPublicKeyCofactor;
    }

    /**
     * X co-ordinate of G (the generator which is also known as the base point) in
     * ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaPublicKeyGeneratorx() {
        return this.ecdsaPublicKeyGeneratorx;
    }

    /**
     * X co-ordinate of G (the generator which is also known as the base point) in
     * ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaPublicKeyGeneratorx New value for the property.
     */
    public void setEcdsaPublicKeyGeneratorx(java.lang.String ecdsaPublicKeyGeneratorx) {
        this.ecdsaPublicKeyGeneratorx = ecdsaPublicKeyGeneratorx;
    }

    /**
     * Y co-ordinate of G (the generator which is also known as the base point) in
     * ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaPublicKeyGeneratory() {
        return this.ecdsaPublicKeyGeneratory;
    }

    /**
     * Y co-ordinate of G (the generator which is also known as the base point) in
     * ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaPublicKeyGeneratory New value for the property.
     */
    public void setEcdsaPublicKeyGeneratory(java.lang.String ecdsaPublicKeyGeneratory) {
        this.ecdsaPublicKeyGeneratory = ecdsaPublicKeyGeneratory;
    }

    /**
     * The order of generator G in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEcdsaPublicKeyOrder() {
        return this.ecdsaPublicKeyOrder;
    }

    /**
     * The order of generator G in ECDSA.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaPublicKeyOrder New value for the property.
     */
    public void setEcdsaPublicKeyOrder(java.lang.String ecdsaPublicKeyOrder) {
        this.ecdsaPublicKeyOrder = ecdsaPublicKeyOrder;
    }

    /**
     * The bytes used during curve generation for later validation in ECDSA.| Contents
     * of this array are copied to protect against subsequent modification.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getEcdsaPublicKeySeed() {
        return this.ecdsaPublicKeySeed;
    }

    /**
     * The bytes used during curve generation for later validation in ECDSA.| Contents
     * of this array are copied to protect against subsequent modification.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ecdsaPublicKeySeed New value for the property.
     */
    public void setEcdsaPublicKeySeed(java.util.List<java.lang.String> ecdsaPublicKeySeed) {
        this.ecdsaPublicKeySeed = ecdsaPublicKeySeed;
    }

    /**
     * True if this is a CA certificate.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsCa() {
        return this.isCa;
    }

    /**
     * True if this is a CA certificate.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isCa New value for the property.
     */
    public void setIsCa(java.lang.Boolean isCa) {
        this.isCa = isCa;
    }

    /**
     * True if this certificate is valid.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsValid() {
        return this.isValid;
    }

    /**
     * True if this certificate is valid.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isValid New value for the property.
     */
    public void setIsValid(java.lang.Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * The certificate issuers complete distinguished name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIssuer() {
        return this.issuer;
    }

    /**
     * The certificate issuers complete distinguished name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param issuer New value for the property.
     */
    public void setIssuer(java.lang.String issuer) {
        this.issuer = issuer;
    }

    /**
     * The certificate issuer's common name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIssuerCn() {
        return this.issuerCn;
    }

    /**
     * The certificate issuer's common name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param issuerCn New value for the property.
     */
    public void setIssuerCn(java.lang.String issuerCn) {
        this.issuerCn = issuerCn;
    }

    /**
     * The time in epoch milliseconds at which the certificate becomes invalid. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNotAfter() {
        return this.notAfter;
    }

    /**
     * The time in epoch milliseconds at which the certificate becomes invalid. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param notAfter New value for the property.
     */
    public void setNotAfter(java.lang.Long notAfter) {
        this.notAfter = notAfter;
    }

    /**
     * The time in epoch milliseconds at which the certificate becomes valid. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNotBefore() {
        return this.notBefore;
    }

    /**
     * The time in epoch milliseconds at which the certificate becomes valid. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param notBefore New value for the property.
     */
    public void setNotBefore(java.lang.Long notBefore) {
        this.notBefore = notBefore;
    }

    /**
     * Cryptographic algorithm used by the public key for data encryption.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPublicKeyAlgo() {
        return this.publicKeyAlgo;
    }

    /**
     * Cryptographic algorithm used by the public key for data encryption.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param publicKeyAlgo New value for the property.
     */
    public void setPublicKeyAlgo(java.lang.String publicKeyAlgo) {
        this.publicKeyAlgo = publicKeyAlgo;
    }

    /**
     * Size measured in bits of the public/private keys used in a cryptographic
     * algorithm. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPublicKeyLength() {
        return this.publicKeyLength;
    }

    /**
     * Size measured in bits of the public/private keys used in a cryptographic
     * algorithm. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param publicKeyLength New value for the property.
     */
    public void setPublicKeyLength(java.lang.Long publicKeyLength) {
        this.publicKeyLength = publicKeyLength;
    }

    /**
     * An RSA public key is made up of the modulus and the public exponent. Exponent is
     * a power number.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRsaPublicKeyExponent() {
        return this.rsaPublicKeyExponent;
    }

    /**
     * An RSA public key is made up of the modulus and the public exponent. Exponent is
     * a power number.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rsaPublicKeyExponent New value for the property.
     */
    public void setRsaPublicKeyExponent(java.lang.String rsaPublicKeyExponent) {
        this.rsaPublicKeyExponent = rsaPublicKeyExponent;
    }

    /**
     * An RSA public key is made up of the modulus and the public exponent. Modulus is
     * wrap around number.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRsaPublicKeyModulus() {
        return this.rsaPublicKeyModulus;
    }

    /**
     * An RSA public key is made up of the modulus and the public exponent. Modulus is
     * wrap around number.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rsaPublicKeyModulus New value for the property.
     */
    public void setRsaPublicKeyModulus(java.lang.String rsaPublicKeyModulus) {
        this.rsaPublicKeyModulus = rsaPublicKeyModulus;
    }

    /**
     * Certificate's serial number.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSerialNumber() {
        return this.serialNumber;
    }

    /**
     * Certificate's serial number.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serialNumber New value for the property.
     */
    public void setSerialNumber(java.lang.String serialNumber) {
        this.serialNumber = serialNumber;
    }

    /**
     * The SHA256 thumbprint of the certificate, in hexadecimal notation.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSha256Thumbprint() {
        return this.sha256Thumbprint;
    }

    /**
     * The SHA256 thumbprint of the certificate, in hexadecimal notation.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sha256Thumbprint New value for the property.
     */
    public void setSha256Thumbprint(java.lang.String sha256Thumbprint) {
        this.sha256Thumbprint = sha256Thumbprint;
    }

    /**
     * The signature value(the raw signature bits) used for signing and validate the
     * cert.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSignature() {
        return this.signature;
    }

    /**
     * The signature value(the raw signature bits) used for signing and validate the
     * cert.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param signature New value for the property.
     */
    public void setSignature(java.lang.String signature) {
        this.signature = signature;
    }

    /**
     * The algorithm used by the Certificate Authority to sign the certificate.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    /**
     * The algorithm used by the Certificate Authority to sign the certificate.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param signatureAlgorithm New value for the property.
     */
    public void setSignatureAlgorithm(java.lang.String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    /**
     * The certificate owners complete distinguished name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSubject() {
        return this.subject;
    }

    /**
     * The certificate owners complete distinguished name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param subject New value for the property.
     */
    public void setSubject(java.lang.String subject) {
        this.subject = subject;
    }

    /**
     * The certificate owner's common name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSubjectCn() {
        return this.subjectCn;
    }

    /**
     * The certificate owner's common name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param subjectCn New value for the property.
     */
    public void setSubjectCn(java.lang.String subjectCn) {
        this.subjectCn = subjectCn;
    }

    /**
     * Certificate version (default v1).
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVersion() {
        return this.version;
    }

    /**
     * Certificate version (default v1).
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param version New value for the property.
     */
    public void setVersion(java.lang.String version) {
        this.version = version;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.x509Certificate;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dsa_public_key_g",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dsaPublicKeyg, this._getType().getField("dsa_public_key_g")));
        structValue.setField("dsa_public_key_p",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dsaPublicKeyp, this._getType().getField("dsa_public_key_p")));
        structValue.setField("dsa_public_key_q",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dsaPublicKeyq, this._getType().getField("dsa_public_key_q")));
        structValue.setField("dsa_public_key_y",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dsaPublicKeyy, this._getType().getField("dsa_public_key_y")));
        structValue.setField("ecdsa_curve_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaCurveName, this._getType().getField("ecdsa_curve_name")));
        structValue.setField("ecdsa_ec_field",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaEcField, this._getType().getField("ecdsa_ec_field")));
        structValue.setField("ecdsa_ec_field_f2mks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaEcFieldF2mks, this._getType().getField("ecdsa_ec_field_f2mks")));
        structValue.setField("ecdsa_ec_field_f2mm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaEcFieldF2mm, this._getType().getField("ecdsa_ec_field_f2mm")));
        structValue.setField("ecdsa_ec_field_f2mrp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaEcFieldF2mrp, this._getType().getField("ecdsa_ec_field_f2mrp")));
        structValue.setField("ecdsa_ec_field_f2pp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaEcFieldF2pp, this._getType().getField("ecdsa_ec_field_f2pp")));
        structValue.setField("ecdsa_public_key_a",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaPublicKeya, this._getType().getField("ecdsa_public_key_a")));
        structValue.setField("ecdsa_public_key_b",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaPublicKeyb, this._getType().getField("ecdsa_public_key_b")));
        structValue.setField("ecdsa_public_key_cofactor",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaPublicKeyCofactor, this._getType().getField("ecdsa_public_key_cofactor")));
        structValue.setField("ecdsa_public_key_generator_x",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaPublicKeyGeneratorx, this._getType().getField("ecdsa_public_key_generator_x")));
        structValue.setField("ecdsa_public_key_generator_y",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaPublicKeyGeneratory, this._getType().getField("ecdsa_public_key_generator_y")));
        structValue.setField("ecdsa_public_key_order",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaPublicKeyOrder, this._getType().getField("ecdsa_public_key_order")));
        structValue.setField("ecdsa_public_key_seed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecdsaPublicKeySeed, this._getType().getField("ecdsa_public_key_seed")));
        structValue.setField("is_ca",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isCa, this._getType().getField("is_ca")));
        structValue.setField("is_valid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isValid, this._getType().getField("is_valid")));
        structValue.setField("issuer",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.issuer, this._getType().getField("issuer")));
        structValue.setField("issuer_cn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.issuerCn, this._getType().getField("issuer_cn")));
        structValue.setField("not_after",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.notAfter, this._getType().getField("not_after")));
        structValue.setField("not_before",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.notBefore, this._getType().getField("not_before")));
        structValue.setField("public_key_algo",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.publicKeyAlgo, this._getType().getField("public_key_algo")));
        structValue.setField("public_key_length",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.publicKeyLength, this._getType().getField("public_key_length")));
        structValue.setField("rsa_public_key_exponent",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rsaPublicKeyExponent, this._getType().getField("rsa_public_key_exponent")));
        structValue.setField("rsa_public_key_modulus",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rsaPublicKeyModulus, this._getType().getField("rsa_public_key_modulus")));
        structValue.setField("serial_number",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serialNumber, this._getType().getField("serial_number")));
        structValue.setField("sha_256_thumbprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sha256Thumbprint, this._getType().getField("sha_256_thumbprint")));
        structValue.setField("signature",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.signature, this._getType().getField("signature")));
        structValue.setField("signature_algorithm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.signatureAlgorithm, this._getType().getField("signature_algorithm")));
        structValue.setField("subject",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subject, this._getType().getField("subject")));
        structValue.setField("subject_cn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subjectCn, this._getType().getField("subject_cn")));
        structValue.setField("version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.version, this._getType().getField("version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.x509Certificate;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.x509Certificate.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static X509Certificate _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new X509Certificate(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static X509Certificate _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new X509Certificate(structValue);
    }

    /**
     * Builder class for {@link X509Certificate}.
     */
    public static final class Builder {
        private java.lang.String dsaPublicKeyg;
        private java.lang.String dsaPublicKeyp;
        private java.lang.String dsaPublicKeyq;
        private java.lang.String dsaPublicKeyy;
        private java.lang.String ecdsaCurveName;
        private java.lang.String ecdsaEcField;
        private java.util.List<java.lang.Long> ecdsaEcFieldF2mks;
        private java.lang.Long ecdsaEcFieldF2mm;
        private java.lang.String ecdsaEcFieldF2mrp;
        private java.lang.String ecdsaEcFieldF2pp;
        private java.lang.String ecdsaPublicKeya;
        private java.lang.String ecdsaPublicKeyb;
        private java.lang.Long ecdsaPublicKeyCofactor;
        private java.lang.String ecdsaPublicKeyGeneratorx;
        private java.lang.String ecdsaPublicKeyGeneratory;
        private java.lang.String ecdsaPublicKeyOrder;
        private java.util.List<java.lang.String> ecdsaPublicKeySeed;
        private java.lang.Boolean isCa;
        private java.lang.Boolean isValid;
        private java.lang.String issuer;
        private java.lang.String issuerCn;
        private java.lang.Long notAfter;
        private java.lang.Long notBefore;
        private java.lang.String publicKeyAlgo;
        private java.lang.Long publicKeyLength;
        private java.lang.String rsaPublicKeyExponent;
        private java.lang.String rsaPublicKeyModulus;
        private java.lang.String serialNumber;
        private java.lang.String sha256Thumbprint;
        private java.lang.String signature;
        private java.lang.String signatureAlgorithm;
        private java.lang.String subject;
        private java.lang.String subjectCn;
        private java.lang.String version;

        /**
         * Constructor with parameters for the required properties of
         * {@link X509Certificate}.
         */
        public Builder() {
        }

        /**
         * One of the DSA cryptogaphic algorithm's strength parameters, base.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dsaPublicKeyg New value for the property.
         */
        public Builder setDsaPublicKeyg(java.lang.String dsaPublicKeyg) {
            this.dsaPublicKeyg = dsaPublicKeyg;
            return this;
        }

        /**
         * One of the DSA cryptogaphic algorithm's strength parameters, prime.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dsaPublicKeyp New value for the property.
         */
        public Builder setDsaPublicKeyp(java.lang.String dsaPublicKeyp) {
            this.dsaPublicKeyp = dsaPublicKeyp;
            return this;
        }

        /**
         * One of the DSA cryptogaphic algorithm's strength parameters, sub-prime.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dsaPublicKeyq New value for the property.
         */
        public Builder setDsaPublicKeyq(java.lang.String dsaPublicKeyq) {
            this.dsaPublicKeyq = dsaPublicKeyq;
            return this;
        }

        /**
         * One of the DSA cryptogaphic algorithm's strength parameters.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dsaPublicKeyy New value for the property.
         */
        public Builder setDsaPublicKeyy(java.lang.String dsaPublicKeyy) {
            this.dsaPublicKeyy = dsaPublicKeyy;
            return this;
        }

        /**
         * The Curve name for the ECDSA certificate.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaCurveName New value for the property.
         */
        public Builder setEcdsaCurveName(java.lang.String ecdsaCurveName) {
            this.ecdsaCurveName = ecdsaCurveName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.X509Certificate#ECDSA_EC_FIELD_F2M}</li> <li> {@link
         * com.vmware.nsx_policy.model.X509Certificate#ECDSA_EC_FIELD_FP}</li> </ul>
         * Represents an elliptic curve (EC) finite field in ECDSA.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaEcField New value for the property.
         */
        public Builder setEcdsaEcField(java.lang.String ecdsaEcField) {
            this.ecdsaEcField = ecdsaEcField;
            return this;
        }

        /**
         * The order of the middle term(s) of the reduction polynomial in elliptic curve
         * (EC) | characteristic 2 finite field.| Contents of this array are copied to
         * protect against subsequent modification in ECDSA. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaEcFieldF2mks New value for the property.
         */
        public Builder setEcdsaEcFieldF2mks(java.util.List<java.lang.Long> ecdsaEcFieldF2mks) {
            this.ecdsaEcFieldF2mks = ecdsaEcFieldF2mks;
            return this;
        }

        /**
         * The first coefficient of this elliptic curve in elliptic curve (EC) |
         * characteristic 2 finite field for ECDSA. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaEcFieldF2mm New value for the property.
         */
        public Builder setEcdsaEcFieldF2mm(java.lang.Long ecdsaEcFieldF2mm) {
            this.ecdsaEcFieldF2mm = ecdsaEcFieldF2mm;
            return this;
        }

        /**
         * The value whose i-th bit corresponds to the i-th coefficient of the reduction
         * polynomial | in elliptic curve (EC) characteristic 2 finite field for ECDSA.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaEcFieldF2mrp New value for the property.
         */
        public Builder setEcdsaEcFieldF2mrp(java.lang.String ecdsaEcFieldF2mrp) {
            this.ecdsaEcFieldF2mrp = ecdsaEcFieldF2mrp;
            return this;
        }

        /**
         * The specified prime for the elliptic curve prime finite field in ECDSA.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaEcFieldF2pp New value for the property.
         */
        public Builder setEcdsaEcFieldF2pp(java.lang.String ecdsaEcFieldF2pp) {
            this.ecdsaEcFieldF2pp = ecdsaEcFieldF2pp;
            return this;
        }

        /**
         * The first coefficient of this elliptic curve in ECDSA.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaPublicKeya New value for the property.
         */
        public Builder setEcdsaPublicKeya(java.lang.String ecdsaPublicKeya) {
            this.ecdsaPublicKeya = ecdsaPublicKeya;
            return this;
        }

        /**
         * The second coefficient of this elliptic curve in ECDSA.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaPublicKeyb New value for the property.
         */
        public Builder setEcdsaPublicKeyb(java.lang.String ecdsaPublicKeyb) {
            this.ecdsaPublicKeyb = ecdsaPublicKeyb;
            return this;
        }

        /**
         * The co-factor in ECDSA. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaPublicKeyCofactor New value for the property.
         */
        public Builder setEcdsaPublicKeyCofactor(java.lang.Long ecdsaPublicKeyCofactor) {
            this.ecdsaPublicKeyCofactor = ecdsaPublicKeyCofactor;
            return this;
        }

        /**
         * X co-ordinate of G (the generator which is also known as the base point) in
         * ECDSA.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaPublicKeyGeneratorx New value for the property.
         */
        public Builder setEcdsaPublicKeyGeneratorx(java.lang.String ecdsaPublicKeyGeneratorx) {
            this.ecdsaPublicKeyGeneratorx = ecdsaPublicKeyGeneratorx;
            return this;
        }

        /**
         * Y co-ordinate of G (the generator which is also known as the base point) in
         * ECDSA.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaPublicKeyGeneratory New value for the property.
         */
        public Builder setEcdsaPublicKeyGeneratory(java.lang.String ecdsaPublicKeyGeneratory) {
            this.ecdsaPublicKeyGeneratory = ecdsaPublicKeyGeneratory;
            return this;
        }

        /**
         * The order of generator G in ECDSA.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaPublicKeyOrder New value for the property.
         */
        public Builder setEcdsaPublicKeyOrder(java.lang.String ecdsaPublicKeyOrder) {
            this.ecdsaPublicKeyOrder = ecdsaPublicKeyOrder;
            return this;
        }

        /**
         * The bytes used during curve generation for later validation in ECDSA.| Contents
         * of this array are copied to protect against subsequent modification.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ecdsaPublicKeySeed New value for the property.
         */
        public Builder setEcdsaPublicKeySeed(java.util.List<java.lang.String> ecdsaPublicKeySeed) {
            this.ecdsaPublicKeySeed = ecdsaPublicKeySeed;
            return this;
        }

        /**
         * True if this is a CA certificate.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isCa New value for the property.
         */
        public Builder setIsCa(java.lang.Boolean isCa) {
            this.isCa = isCa;
            return this;
        }

        /**
         * True if this certificate is valid.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isValid New value for the property.
         */
        public Builder setIsValid(java.lang.Boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        /**
         * The certificate issuers complete distinguished name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param issuer New value for the property.
         */
        public Builder setIssuer(java.lang.String issuer) {
            this.issuer = issuer;
            return this;
        }

        /**
         * The certificate issuer's common name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param issuerCn New value for the property.
         */
        public Builder setIssuerCn(java.lang.String issuerCn) {
            this.issuerCn = issuerCn;
            return this;
        }

        /**
         * The time in epoch milliseconds at which the certificate becomes invalid. format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param notAfter New value for the property.
         */
        public Builder setNotAfter(java.lang.Long notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        /**
         * The time in epoch milliseconds at which the certificate becomes valid. format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param notBefore New value for the property.
         */
        public Builder setNotBefore(java.lang.Long notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        /**
         * Cryptographic algorithm used by the public key for data encryption.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param publicKeyAlgo New value for the property.
         */
        public Builder setPublicKeyAlgo(java.lang.String publicKeyAlgo) {
            this.publicKeyAlgo = publicKeyAlgo;
            return this;
        }

        /**
         * Size measured in bits of the public/private keys used in a cryptographic
         * algorithm. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param publicKeyLength New value for the property.
         */
        public Builder setPublicKeyLength(java.lang.Long publicKeyLength) {
            this.publicKeyLength = publicKeyLength;
            return this;
        }

        /**
         * An RSA public key is made up of the modulus and the public exponent. Exponent is
         * a power number.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rsaPublicKeyExponent New value for the property.
         */
        public Builder setRsaPublicKeyExponent(java.lang.String rsaPublicKeyExponent) {
            this.rsaPublicKeyExponent = rsaPublicKeyExponent;
            return this;
        }

        /**
         * An RSA public key is made up of the modulus and the public exponent. Modulus is
         * wrap around number.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rsaPublicKeyModulus New value for the property.
         */
        public Builder setRsaPublicKeyModulus(java.lang.String rsaPublicKeyModulus) {
            this.rsaPublicKeyModulus = rsaPublicKeyModulus;
            return this;
        }

        /**
         * Certificate's serial number.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serialNumber New value for the property.
         */
        public Builder setSerialNumber(java.lang.String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        /**
         * The SHA256 thumbprint of the certificate, in hexadecimal notation.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sha256Thumbprint New value for the property.
         */
        public Builder setSha256Thumbprint(java.lang.String sha256Thumbprint) {
            this.sha256Thumbprint = sha256Thumbprint;
            return this;
        }

        /**
         * The signature value(the raw signature bits) used for signing and validate the
         * cert.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param signature New value for the property.
         */
        public Builder setSignature(java.lang.String signature) {
            this.signature = signature;
            return this;
        }

        /**
         * The algorithm used by the Certificate Authority to sign the certificate.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param signatureAlgorithm New value for the property.
         */
        public Builder setSignatureAlgorithm(java.lang.String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        /**
         * The certificate owners complete distinguished name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param subject New value for the property.
         */
        public Builder setSubject(java.lang.String subject) {
            this.subject = subject;
            return this;
        }

        /**
         * The certificate owner's common name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param subjectCn New value for the property.
         */
        public Builder setSubjectCn(java.lang.String subjectCn) {
            this.subjectCn = subjectCn;
            return this;
        }

        /**
         * Certificate version (default v1).
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param version New value for the property.
         */
        public Builder setVersion(java.lang.String version) {
            this.version = version;
            return this;
        }

        public X509Certificate build() {
            X509Certificate result = new X509Certificate();
            result.setDsaPublicKeyg(this.dsaPublicKeyg);
            result.setDsaPublicKeyp(this.dsaPublicKeyp);
            result.setDsaPublicKeyq(this.dsaPublicKeyq);
            result.setDsaPublicKeyy(this.dsaPublicKeyy);
            result.setEcdsaCurveName(this.ecdsaCurveName);
            result.setEcdsaEcField(this.ecdsaEcField);
            result.setEcdsaEcFieldF2mks(this.ecdsaEcFieldF2mks);
            result.setEcdsaEcFieldF2mm(this.ecdsaEcFieldF2mm);
            result.setEcdsaEcFieldF2mrp(this.ecdsaEcFieldF2mrp);
            result.setEcdsaEcFieldF2pp(this.ecdsaEcFieldF2pp);
            result.setEcdsaPublicKeya(this.ecdsaPublicKeya);
            result.setEcdsaPublicKeyb(this.ecdsaPublicKeyb);
            result.setEcdsaPublicKeyCofactor(this.ecdsaPublicKeyCofactor);
            result.setEcdsaPublicKeyGeneratorx(this.ecdsaPublicKeyGeneratorx);
            result.setEcdsaPublicKeyGeneratory(this.ecdsaPublicKeyGeneratory);
            result.setEcdsaPublicKeyOrder(this.ecdsaPublicKeyOrder);
            result.setEcdsaPublicKeySeed(this.ecdsaPublicKeySeed);
            result.setIsCa(this.isCa);
            result.setIsValid(this.isValid);
            result.setIssuer(this.issuer);
            result.setIssuerCn(this.issuerCn);
            result.setNotAfter(this.notAfter);
            result.setNotBefore(this.notBefore);
            result.setPublicKeyAlgo(this.publicKeyAlgo);
            result.setPublicKeyLength(this.publicKeyLength);
            result.setRsaPublicKeyExponent(this.rsaPublicKeyExponent);
            result.setRsaPublicKeyModulus(this.rsaPublicKeyModulus);
            result.setSerialNumber(this.serialNumber);
            result.setSha256Thumbprint(this.sha256Thumbprint);
            result.setSignature(this.signature);
            result.setSignatureAlgorithm(this.signatureAlgorithm);
            result.setSubject(this.subject);
            result.setSubjectCn(this.subjectCn);
            result.setVersion(this.version);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dsa_public_key_g", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dsa_public_key_g",
                                                                                "dsaPublicKeyg",
                                                                                "getDsaPublicKeyg",
                                                                                "setDsaPublicKeyg");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dsa_public_key_p", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dsa_public_key_p",
                                                                                "dsaPublicKeyp",
                                                                                "getDsaPublicKeyp",
                                                                                "setDsaPublicKeyp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dsa_public_key_q", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dsa_public_key_q",
                                                                                "dsaPublicKeyq",
                                                                                "getDsaPublicKeyq",
                                                                                "setDsaPublicKeyq");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dsa_public_key_y", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dsa_public_key_y",
                                                                                "dsaPublicKeyy",
                                                                                "getDsaPublicKeyy",
                                                                                "setDsaPublicKeyy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_curve_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_curve_name",
                                                                                "ecdsaCurveName",
                                                                                "getEcdsaCurveName",
                                                                                "setEcdsaCurveName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_ec_field", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_ec_field",
                                                                                "ecdsaEcField",
                                                                                "getEcdsaEcField",
                                                                                "setEcdsaEcField");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_ec_field_f2mks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.IntegerType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_ec_field_f2mks",
                                                                                "ecdsaEcFieldF2mks",
                                                                                "getEcdsaEcFieldF2mks",
                                                                                "setEcdsaEcFieldF2mks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_ec_field_f2mm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_ec_field_f2mm",
                                                                                "ecdsaEcFieldF2mm",
                                                                                "getEcdsaEcFieldF2mm",
                                                                                "setEcdsaEcFieldF2mm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_ec_field_f2mrp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_ec_field_f2mrp",
                                                                                "ecdsaEcFieldF2mrp",
                                                                                "getEcdsaEcFieldF2mrp",
                                                                                "setEcdsaEcFieldF2mrp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_ec_field_f2pp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_ec_field_f2pp",
                                                                                "ecdsaEcFieldF2pp",
                                                                                "getEcdsaEcFieldF2pp",
                                                                                "setEcdsaEcFieldF2pp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_public_key_a", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_public_key_a",
                                                                                "ecdsaPublicKeya",
                                                                                "getEcdsaPublicKeya",
                                                                                "setEcdsaPublicKeya");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_public_key_b", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_public_key_b",
                                                                                "ecdsaPublicKeyb",
                                                                                "getEcdsaPublicKeyb",
                                                                                "setEcdsaPublicKeyb");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_public_key_cofactor", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_public_key_cofactor",
                                                                                "ecdsaPublicKeyCofactor",
                                                                                "getEcdsaPublicKeyCofactor",
                                                                                "setEcdsaPublicKeyCofactor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_public_key_generator_x", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_public_key_generator_x",
                                                                                "ecdsaPublicKeyGeneratorx",
                                                                                "getEcdsaPublicKeyGeneratorx",
                                                                                "setEcdsaPublicKeyGeneratorx");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_public_key_generator_y", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_public_key_generator_y",
                                                                                "ecdsaPublicKeyGeneratory",
                                                                                "getEcdsaPublicKeyGeneratory",
                                                                                "setEcdsaPublicKeyGeneratory");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_public_key_order", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_public_key_order",
                                                                                "ecdsaPublicKeyOrder",
                                                                                "getEcdsaPublicKeyOrder",
                                                                                "setEcdsaPublicKeyOrder");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecdsa_public_key_seed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecdsa_public_key_seed",
                                                                                "ecdsaPublicKeySeed",
                                                                                "getEcdsaPublicKeySeed",
                                                                                "setEcdsaPublicKeySeed");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_ca", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_ca",
                                                                                "isCa",
                                                                                "getIsCa",
                                                                                "setIsCa");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_valid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_valid",
                                                                                "isValid",
                                                                                "getIsValid",
                                                                                "setIsValid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("issuer", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("issuer",
                                                                                "issuer",
                                                                                "getIssuer",
                                                                                "setIssuer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("issuer_cn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("issuer_cn",
                                                                                "issuerCn",
                                                                                "getIssuerCn",
                                                                                "setIssuerCn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("not_after", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("not_after",
                                                                                "notAfter",
                                                                                "getNotAfter",
                                                                                "setNotAfter");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("not_before", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("not_before",
                                                                                "notBefore",
                                                                                "getNotBefore",
                                                                                "setNotBefore");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("public_key_algo", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("public_key_algo",
                                                                                "publicKeyAlgo",
                                                                                "getPublicKeyAlgo",
                                                                                "setPublicKeyAlgo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("public_key_length", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("public_key_length",
                                                                                "publicKeyLength",
                                                                                "getPublicKeyLength",
                                                                                "setPublicKeyLength");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rsa_public_key_exponent", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rsa_public_key_exponent",
                                                                                "rsaPublicKeyExponent",
                                                                                "getRsaPublicKeyExponent",
                                                                                "setRsaPublicKeyExponent");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rsa_public_key_modulus", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rsa_public_key_modulus",
                                                                                "rsaPublicKeyModulus",
                                                                                "getRsaPublicKeyModulus",
                                                                                "setRsaPublicKeyModulus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("serial_number", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("serial_number",
                                                                                "serialNumber",
                                                                                "getSerialNumber",
                                                                                "setSerialNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sha_256_thumbprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sha_256_thumbprint",
                                                                                "sha256Thumbprint",
                                                                                "getSha256Thumbprint",
                                                                                "setSha256Thumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("signature", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("signature",
                                                                                "signature",
                                                                                "getSignature",
                                                                                "setSignature");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("signature_algorithm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("signature_algorithm",
                                                                                "signatureAlgorithm",
                                                                                "getSignatureAlgorithm",
                                                                                "setSignatureAlgorithm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subject", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subject",
                                                                                "subject",
                                                                                "getSubject",
                                                                                "setSubject");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subject_cn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subject_cn",
                                                                                "subjectCn",
                                                                                "getSubjectCn",
                                                                                "setSubjectCn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("version",
                                                                                "version",
                                                                                "getVersion",
                                                                                "setVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.x509_certificate",
                                                            fields,
                                                            com.vmware.nsx_policy.model.X509Certificate.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

