/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.infra.drafts.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.infra.drafts;

public interface AggregatedWithPagination extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.infra.drafts.AggregatedWithPaginationTypes {

    /**
     * Get a paginated aggregated configuration of a given draft. This aggregated
     * configuration is the differnece between the current published firewall
     * configuration and a firewall configuration stored in a given draft. For an
     * initial API call, if request_id is present in a response, then this is a
     * paginated aggregated configuration of a given draft, containing all the security
     * policies from the aggregated configuration. Using this request_id, more granular
     * aggregated configuration, at security policy level, can be fetched from
     * subsequent API calls. Absence of request_id suggests that whole aggregated
     * configuration has been returned as a response to initial API call, as the size
     * of aggregated configuration is not big enough to need pagination.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param draftId (required)
     * @param requestId Request identifier to track subsequent API calls (optional)
     * @param rootPath Path of the root object of subtree (optional)
     * @return com.vmware.nsx_policy.model.PolicyDraftPaginatedAggregatedConfigurationResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDraftPaginatedAggregatedConfigurationResult get(java.lang.String orgId, java.lang.String projectId, java.lang.String draftId, java.lang.String requestId, java.lang.String rootPath);

    /**
     * Get a paginated aggregated configuration of a given draft. This aggregated
     * configuration is the differnece between the current published firewall
     * configuration and a firewall configuration stored in a given draft. For an
     * initial API call, if request_id is present in a response, then this is a
     * paginated aggregated configuration of a given draft, containing all the security
     * policies from the aggregated configuration. Using this request_id, more granular
     * aggregated configuration, at security policy level, can be fetched from
     * subsequent API calls. Absence of request_id suggests that whole aggregated
     * configuration has been returned as a response to initial API call, as the size
     * of aggregated configuration is not big enough to need pagination.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param draftId (required)
     * @param requestId Request identifier to track subsequent API calls (optional)
     * @param rootPath Path of the root object of subtree (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyDraftPaginatedAggregatedConfigurationResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDraftPaginatedAggregatedConfigurationResult get(java.lang.String orgId, java.lang.String projectId, java.lang.String draftId, java.lang.String requestId, java.lang.String rootPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get a paginated aggregated configuration of a given draft. This aggregated
     * configuration is the differnece between the current published firewall
     * configuration and a firewall configuration stored in a given draft. For an
     * initial API call, if request_id is present in a response, then this is a
     * paginated aggregated configuration of a given draft, containing all the security
     * policies from the aggregated configuration. Using this request_id, more granular
     * aggregated configuration, at security policy level, can be fetched from
     * subsequent API calls. Absence of request_id suggests that whole aggregated
     * configuration has been returned as a response to initial API call, as the size
     * of aggregated configuration is not big enough to need pagination.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDraftPaginatedAggregatedConfigurationResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param draftId (required)
     * @param requestId Request identifier to track subsequent API calls (optional)
     * @param rootPath Path of the root object of subtree (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String draftId, java.lang.String requestId, java.lang.String rootPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDraftPaginatedAggregatedConfigurationResult> asyncCallback);

    /**
     * Get a paginated aggregated configuration of a given draft. This aggregated
     * configuration is the differnece between the current published firewall
     * configuration and a firewall configuration stored in a given draft. For an
     * initial API call, if request_id is present in a response, then this is a
     * paginated aggregated configuration of a given draft, containing all the security
     * policies from the aggregated configuration. Using this request_id, more granular
     * aggregated configuration, at security policy level, can be fetched from
     * subsequent API calls. Absence of request_id suggests that whole aggregated
     * configuration has been returned as a response to initial API call, as the size
     * of aggregated configuration is not big enough to need pagination.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDraftPaginatedAggregatedConfigurationResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param draftId (required)
     * @param requestId Request identifier to track subsequent API calls (optional)
     * @param rootPath Path of the root object of subtree (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String draftId, java.lang.String requestId, java.lang.String rootPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDraftPaginatedAggregatedConfigurationResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
