/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.infra.ip_pools.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.infra.ip_pools;

public interface IpAllocations extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.infra.ip_pools.IpAllocationsTypes {

    /**
     * Releases the IP that was allocated for this allocation request
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId);

    /**
     * Releases the IP that was allocated for this allocation request
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Releases the IP that was allocated for this allocation request
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Releases the IP that was allocated for this allocation request
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read a previously created allocation
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @return com.vmware.nsx_policy.model.IpAddressAllocation
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocation get(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId);

    /**
     * Read a previously created allocation
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IpAddressAllocation
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocation get(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read a previously created allocation
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocation
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocation> asyncCallback);

    /**
     * Read a previously created allocation
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocation
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocation> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about which addresses have been allocated from a specified
     * IP address pool in policy.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.IpAddressAllocationListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocationListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about which addresses have been allocated from a specified
     * IP address pool in policy.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IpAddressAllocationListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocationListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about which addresses have been allocated from a specified
     * IP address pool in policy.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocationListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocationListResult> asyncCallback);

    /**
     * Returns information about which addresses have been allocated from a specified
     * IP address pool in policy.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocationListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocationListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If allocation of the same ID is found, this is a no-op. If no allocation of the
     * specified ID is found, then a new allocation is created. An allocation cannot be
     * updated once created. When an allocation is requested from an IpAddressPool, the
     * IP could be allocated from any subnet in the pool that has the available
     * capacity. Request to allocate an IP will fail if no subnet was previously
     * created. If specific IP was requested, the status of allocation is reflected in
     * the realized state. If any IP is requested, the IP finally allocated is obtained
     * by polling on the realized state until the allocated IP is returned in the
     * extended attributes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation);

    /**
     * If allocation of the same ID is found, this is a no-op. If no allocation of the
     * specified ID is found, then a new allocation is created. An allocation cannot be
     * updated once created. When an allocation is requested from an IpAddressPool, the
     * IP could be allocated from any subnet in the pool that has the available
     * capacity. Request to allocate an IP will fail if no subnet was previously
     * created. If specific IP was requested, the status of allocation is reflected in
     * the realized state. If any IP is requested, the IP finally allocated is obtained
     * by polling on the realized state until the allocated IP is returned in the
     * extended attributes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If allocation of the same ID is found, this is a no-op. If no allocation of the
     * specified ID is found, then a new allocation is created. An allocation cannot be
     * updated once created. When an allocation is requested from an IpAddressPool, the
     * IP could be allocated from any subnet in the pool that has the available
     * capacity. Request to allocate an IP will fail if no subnet was previously
     * created. If specific IP was requested, the status of allocation is reflected in
     * the realized state. If any IP is requested, the IP finally allocated is obtained
     * by polling on the realized state until the allocated IP is returned in the
     * extended attributes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If allocation of the same ID is found, this is a no-op. If no allocation of the
     * specified ID is found, then a new allocation is created. An allocation cannot be
     * updated once created. When an allocation is requested from an IpAddressPool, the
     * IP could be allocated from any subnet in the pool that has the available
     * capacity. Request to allocate an IP will fail if no subnet was previously
     * created. If specific IP was requested, the status of allocation is reflected in
     * the realized state. If any IP is requested, the IP finally allocated is obtained
     * by polling on the realized state until the allocated IP is returned in the
     * extended attributes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If allocation of the same ID is found, this is a no-op. If no allocation of the
     * specified ID is found, then a new allocation is created. An allocation cannot be
     * updated once created. When an IP allocation is requested from an IpAddressPool,
     * the IP could be allocated from any subnet in the pool that has the available
     * capacity. Request to allocate an IP will fail if no subnet was previously
     * created. If specific IP was requested, the status of allocation is reflected in
     * the realized state. If any IP is requested, the IP finally allocated is obtained
     * by polling on the realized state until the allocated IP is returned in the
     * extended attributes. An allocation cannot be updated once created.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @return com.vmware.nsx_policy.model.IpAddressAllocation
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocation update(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation);

    /**
     * If allocation of the same ID is found, this is a no-op. If no allocation of the
     * specified ID is found, then a new allocation is created. An allocation cannot be
     * updated once created. When an IP allocation is requested from an IpAddressPool,
     * the IP could be allocated from any subnet in the pool that has the available
     * capacity. Request to allocate an IP will fail if no subnet was previously
     * created. If specific IP was requested, the status of allocation is reflected in
     * the realized state. If any IP is requested, the IP finally allocated is obtained
     * by polling on the realized state until the allocated IP is returned in the
     * extended attributes. An allocation cannot be updated once created.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IpAddressAllocation
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocation update(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If allocation of the same ID is found, this is a no-op. If no allocation of the
     * specified ID is found, then a new allocation is created. An allocation cannot be
     * updated once created. When an IP allocation is requested from an IpAddressPool,
     * the IP could be allocated from any subnet in the pool that has the available
     * capacity. Request to allocate an IP will fail if no subnet was previously
     * created. If specific IP was requested, the status of allocation is reflected in
     * the realized state. If any IP is requested, the IP finally allocated is obtained
     * by polling on the realized state until the allocated IP is returned in the
     * extended attributes. An allocation cannot be updated once created.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocation
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocation> asyncCallback);

    /**
     * If allocation of the same ID is found, this is a no-op. If no allocation of the
     * specified ID is found, then a new allocation is created. An allocation cannot be
     * updated once created. When an IP allocation is requested from an IpAddressPool,
     * the IP could be allocated from any subnet in the pool that has the available
     * capacity. Request to allocate an IP will fail if no subnet was previously
     * created. If specific IP was requested, the status of allocation is reflected in
     * the realized state. If any IP is requested, the IP finally allocated is obtained
     * by polling on the realized state until the allocated IP is returned in the
     * extended attributes. An allocation cannot be updated once created.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocation
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocation> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
