/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.infra.tier_1s.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.infra.tier_1s;

public interface DnsForwarder extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.infra.tier_1s.DnsForwarderTypes {

    /**
     * Perform the specified action for Tier0 DNS forwarder on specified enforcement
     * point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param action An action to be performed for DNS forwarder on EP (required)
     * @param enforcementPointPath An enforcement point path, on which the action is to be performed (optional,
     * default to /infra/sites/default/enforcement-points/default)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void create(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String action, java.lang.String enforcementPointPath);

    /**
     * Perform the specified action for Tier0 DNS forwarder on specified enforcement
     * point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param action An action to be performed for DNS forwarder on EP (required)
     * @param enforcementPointPath An enforcement point path, on which the action is to be performed (optional,
     * default to /infra/sites/default/enforcement-points/default)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void create(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String action, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Perform the specified action for Tier0 DNS forwarder on specified enforcement
     * point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param action An action to be performed for DNS forwarder on EP (required)
     * @param enforcementPointPath An enforcement point path, on which the action is to be performed (optional,
     * default to /infra/sites/default/enforcement-points/default)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String action, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Perform the specified action for Tier0 DNS forwarder on specified enforcement
     * point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param action An action to be performed for DNS forwarder on EP (required)
     * @param enforcementPointPath An enforcement point path, on which the action is to be performed (optional,
     * default to /infra/sites/default/enforcement-points/default)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String action, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete DNS configuration for tier-1 instance
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id);

    /**
     * Delete DNS configuration for tier-1 instance
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete DNS configuration for tier-1 instance
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete DNS configuration for tier-1 instance
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read the DNS Forwarder for the given tier-1 instance
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @return com.vmware.nsx_policy.model.PolicyDnsForwarder
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDnsForwarder get(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id);

    /**
     * Read the DNS Forwarder for the given tier-1 instance
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyDnsForwarder
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDnsForwarder get(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read the DNS Forwarder for the given tier-1 instance
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDnsForwarder
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDnsForwarder> asyncCallback);

    /**
     * Read the DNS Forwarder for the given tier-1 instance
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDnsForwarder
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDnsForwarder> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create or update the DNS Forwarder
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param policyDnsForwarder (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.nsx_policy.model.PolicyDnsForwarder policyDnsForwarder);

    /**
     * Create or update the DNS Forwarder
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param policyDnsForwarder (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.nsx_policy.model.PolicyDnsForwarder policyDnsForwarder, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create or update the DNS Forwarder
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param policyDnsForwarder (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.nsx_policy.model.PolicyDnsForwarder policyDnsForwarder, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create or update the DNS Forwarder
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param policyDnsForwarder (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.nsx_policy.model.PolicyDnsForwarder policyDnsForwarder, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create or update the DNS Forwarder
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param policyDnsForwarder (required)
     * @return com.vmware.nsx_policy.model.PolicyDnsForwarder
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDnsForwarder update(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.nsx_policy.model.PolicyDnsForwarder policyDnsForwarder);

    /**
     * Create or update the DNS Forwarder
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param policyDnsForwarder (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyDnsForwarder
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDnsForwarder update(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.nsx_policy.model.PolicyDnsForwarder policyDnsForwarder, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create or update the DNS Forwarder
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDnsForwarder
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param policyDnsForwarder (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.nsx_policy.model.PolicyDnsForwarder policyDnsForwarder, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDnsForwarder> asyncCallback);

    /**
     * Create or update the DNS Forwarder
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDnsForwarder
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id Tier-1 ID (required)
     * @param policyDnsForwarder (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, com.vmware.nsx_policy.model.PolicyDnsForwarder policyDnsForwarder, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDnsForwarder> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
