/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.vpcs.nat.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.vpcs.nat;

public interface NatRules extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.vpcs.nat.NatRulesTypes {

    /**
     * Delete NAT Rule from VPC denoted by VPC ID, under NAT section denoted by
     * <nat-id>. Under VPC there will be 2 different NATs(sections). (USER and NAT64)
     * For more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId);

    /**
     * Delete NAT Rule from VPC denoted by VPC ID, under NAT section denoted by
     * <nat-id>. Under VPC there will be 2 different NATs(sections). (USER and NAT64)
     * For more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete NAT Rule from VPC denoted by VPC ID, under NAT section denoted by
     * <nat-id>. Under VPC there will be 2 different NATs(sections). (USER and NAT64)
     * For more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete NAT Rule from VPC denoted by VPC ID, under NAT section denoted by
     * <nat-id>. Under VPC there will be 2 different NATs(sections). (USER and NAT64)
     * For more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get NAT Rule from VPC denoted by VPC ID, under NAT section denoted by <nat-id>.
     * Under VPC there will be 2 different NATs(sections). (USER and NAT64) For more
     * details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @return com.vmware.nsx_policy.model.PolicyVpcNatRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyVpcNatRule get(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId);

    /**
     * Get NAT Rule from VPC denoted by VPC ID, under NAT section denoted by <nat-id>.
     * Under VPC there will be 2 different NATs(sections). (USER and NAT64) For more
     * details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyVpcNatRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyVpcNatRule get(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get NAT Rule from VPC denoted by VPC ID, under NAT section denoted by <nat-id>.
     * Under VPC there will be 2 different NATs(sections). (USER and NAT64) For more
     * details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyVpcNatRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyVpcNatRule> asyncCallback);

    /**
     * Get NAT Rule from VPC denoted by VPC ID, under NAT section denoted by <nat-id>.
     * Under VPC there will be 2 different NATs(sections). (USER and NAT64) For more
     * details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyVpcNatRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyVpcNatRule> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List NAT Rules from VPC denoted by VPC ID, under NAT section denoted by
     * <nat-id>. Under VPC there will be 2 different NATs(sections). (USER and NAT64)
     * For more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.PolicyVpcNatRuleListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyVpcNatRuleListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List NAT Rules from VPC denoted by VPC ID, under NAT section denoted by
     * <nat-id>. Under VPC there will be 2 different NATs(sections). (USER and NAT64)
     * For more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyVpcNatRuleListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyVpcNatRuleListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List NAT Rules from VPC denoted by VPC ID, under NAT section denoted by
     * <nat-id>. Under VPC there will be 2 different NATs(sections). (USER and NAT64)
     * For more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyVpcNatRuleListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyVpcNatRuleListResult> asyncCallback);

    /**
     * List NAT Rules from VPC denoted by VPC ID, under NAT section denoted by
     * <nat-id>. Under VPC there will be 2 different NATs(sections). (USER and NAT64)
     * For more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyVpcNatRuleListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyVpcNatRuleListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If a NAT Rule is not already present on VPC denoted by VPC ID, under NAT section
     * denoted by <nat-id>, create a new NAT Rule. If it already exists, update the NAT
     * Rule. Under VPC there will be 2 different NATs(sections). (USER and NAT64) For
     * more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyVpcNatRule (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_policy.model.PolicyVpcNatRule policyVpcNatRule);

    /**
     * If a NAT Rule is not already present on VPC denoted by VPC ID, under NAT section
     * denoted by <nat-id>, create a new NAT Rule. If it already exists, update the NAT
     * Rule. Under VPC there will be 2 different NATs(sections). (USER and NAT64) For
     * more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyVpcNatRule (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_policy.model.PolicyVpcNatRule policyVpcNatRule, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If a NAT Rule is not already present on VPC denoted by VPC ID, under NAT section
     * denoted by <nat-id>, create a new NAT Rule. If it already exists, update the NAT
     * Rule. Under VPC there will be 2 different NATs(sections). (USER and NAT64) For
     * more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyVpcNatRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_policy.model.PolicyVpcNatRule policyVpcNatRule, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If a NAT Rule is not already present on VPC denoted by VPC ID, under NAT section
     * denoted by <nat-id>, create a new NAT Rule. If it already exists, update the NAT
     * Rule. Under VPC there will be 2 different NATs(sections). (USER and NAT64) For
     * more details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyVpcNatRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_policy.model.PolicyVpcNatRule policyVpcNatRule, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update NAT Rule on VPC denoted by VPC ID, under NAT section denoted by <nat-id>.
     * Under VPC there will be 2 different NATs(sections). (USER and NAT64) For more
     * details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyVpcNatRule (required)
     * @return com.vmware.nsx_policy.model.PolicyVpcNatRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyVpcNatRule update(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_policy.model.PolicyVpcNatRule policyVpcNatRule);

    /**
     * Update NAT Rule on VPC denoted by VPC ID, under NAT section denoted by <nat-id>.
     * Under VPC there will be 2 different NATs(sections). (USER and NAT64) For more
     * details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyVpcNatRule (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyVpcNatRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyVpcNatRule update(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_policy.model.PolicyVpcNatRule policyVpcNatRule, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update NAT Rule on VPC denoted by VPC ID, under NAT section denoted by <nat-id>.
     * Under VPC there will be 2 different NATs(sections). (USER and NAT64) For more
     * details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyVpcNatRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyVpcNatRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_policy.model.PolicyVpcNatRule policyVpcNatRule, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyVpcNatRule> asyncCallback);

    /**
     * Update NAT Rule on VPC denoted by VPC ID, under NAT section denoted by <nat-id>.
     * Under VPC there will be 2 different NATs(sections). (USER and NAT64) For more
     * details related to NAT section please refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyVpcNatRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param orgId Org ID (required)
     * @param projectId Project ID (required)
     * @param vpcId VPC ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyVpcNatRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_policy.model.PolicyVpcNatRule policyVpcNatRule, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyVpcNatRule> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
