/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * CoreException.java --
 *
 * TODO: describe the compilation unit
 */
package com.vmware.vapi;

import java.util.*;

/**
 *
 */
public class CoreException extends RuntimeException {
    /** Generated */
    private static final long serialVersionUID = -2630694780348150752L;

    private Message message;

    public CoreException(Message message, Throwable cause) {
        super(message.toString(), cause);
        this.message = message;
    }

    /**
    *
    * @param message
    * @throws NullPointerException if message is null
    */
   public CoreException(Message message) {
       this(message, null);
   }

    public CoreException(String messageId, String... args) {
        this(MessageFactory.getMessage(messageId, args));
    }

    public List<Message> getExceptionMessages() {
        List<Message> messages = new LinkedList<Message>();

        Throwable exc = this;
        while (exc != null && exc instanceof CoreException) {
            messages.add(((CoreException) exc).message);
            exc = exc.getCause();
        }

        return messages;
    }

}
