
/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


/**
 * The {@code com.vmware.vapi} component provides API infrastructure interfaces and
 * standard types that can be used in the interface specification of any interface.
 */
package com.vmware.vapi;

/**
 * {@link VapiFactory} is responsible for creating instances of services
 * contained inside the com.vmware.vapi package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class VapiFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private VapiFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link VapiFactory} factory instance
     */
    public static VapiFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        VapiFactory instance = new VapiFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * The {@code com.vmware.vapi.std} package provides standard types that can be used
     * in the interface specification of any interface.
     */
    public com.vmware.vapi.std.StdFactory std() {
        return com.vmware.vapi.std.StdFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
