/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.activation;

/**
 * <b>WARNING:</b> Use only as a sample. The API is experimental and subject to
 * change in future versions.
 *
 * <p>
 * Local in-process API to an activation registry. Service implementations that
 * want to check for cancellation should depend on this abstraction and not on a
 * concrete activation registry flavor.
 * </p>
 */
public abstract class ActivationMonitor {

    /**
     * Returns whether cancellation is requested for the specified activation.
     *
     * @param activationId activation identifier
     * @return whether cancellation is request for the activation
     */
    public abstract boolean isCancelRequested(String activationId);
}
