/* **********************************************************
 * Copyright 2013, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * GenericError.java --
 *
 *       Concrete ApiError which represents a VMODL2 error that
 *       was reported but couldn't be resolved.
 */
package com.vmware.vapi.bindings;

import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.internal.util.Validate;

/**
 * Concrete <code>ApiError</code> which represents a VMODL2 error that
 * was reported but couldn't be resolved.
 *
 * <p>This is only relevant on the client side and is used to represent
 * errors (i.e. <code>ErrorValue</code> names) that are unknown for the
 * client/stub.
 */
@SuppressWarnings("serial")
public final class UnresolvedError extends ApiError {
    private final ErrorValue errorValue;

    public UnresolvedError(ErrorValue errorValue) {
        Validate.notNull(errorValue);
        this.errorValue = errorValue;
    }

    @Override
    public ErrorValue _getDataValue() {
        return errorValue;
    }

    @Override
    public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
        return BindingsUtil.hasTypeNameOf(errorValue, clazz);
    }

    @Override
    public <T extends Structure> T _convertTo(Class<T> clazz) {
        return BindingsUtil.convertTo(this, clazz);
    }

    @Override
    public String _getCanonicalName() {
        return errorValue.getName();
    }
}
