/* **********************************************************
 * Copyright (c) 2013, 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * ConverterException.java --
 *
 * Thrown by the type converter in case of error.
 */
package com.vmware.vapi.bindings.convert;

import com.vmware.vapi.Message;
import com.vmware.vapi.data.ConstraintValidationException;

/**
 * Exception thrown by the type converter.
 */
public class ConverterException extends ConstraintValidationException {
    /** Generated */
    private static final long serialVersionUID = 5678375627629115732L;

    public ConverterException(Message message, Throwable cause) {
        super(message, cause);
    }

    public ConverterException(Message message) {
        super(message);
    }

    public ConverterException(String messageId, String... args) {
        super(messageId, args);
    }
}
