/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings.convert.impl;


/**
 * Utility for conversion between different naming conventions.
 */
public final class JavaBeanAdapter {

    /**
     * @param s string of ASCII characters. This method might not handle
     *          Unicode characters correctly.
     *
     * @return A version of the string where the first character is upper case.
     */
    private static String capitalize(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        char firstChar = s.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            return s;
        }
        return Character.toUpperCase(firstChar) + s.substring(1);
    }

    /**
     * Converts underscore (_) separated words to CamelCase, e.g.
     * <pre>
     *   one  -> One
     *   two_words -> TwoWords
     *   three_words_string -> ThreeWordsString
     *   v_App -> vApp
     *   V_App -> VApp
     * </pre>
     *
     * All other capitalization is left unmodified.
     *
     * @param s <code>String</code> to convert
     * @return converted <code>String</code>
     */
    public static String underscoreToCamelCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }

        String[] words = s.split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; i++) {
            if (words[i].isEmpty()) {
                result.append('_');
            } else {
                // TODO: words.length > 1 is here (below) because for single
                //       letter identifiers we always capitalize them in the
                //       toolkit ( a -> setA/getA ); this might be wrong,
                //       just like we fixed vApp -> getvApp/setvApp

                // TODO: completely remove this computation (toCamelCase/toMixedCase
                //       from the Java code. Just keep and use the values computed
                //       during bindings generation in the respective StructType
                //       instances
                if (i == 0 && words[i].length() == 1 && words.length > 1) {
                    // first word, which is single letter one, and there are
                    // more words - don't capitalize it
                    result.append(words[i]);
                } else {
                    result.append(capitalize(words[i]));
                }
            }
        }

        return result.toString();
    }

}
