/* **********************************************************
 * Copyright 2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.client.exception;

/**
 * Thrown in cases of server connection exceptions.
 * <p>
 * The exceptions translated to this one are:
 * <li> java.net.SocketException
 * <li> java.net.SocketTimeoutException
 * <li> java.io.InterruptedIOException
 * <li> org.apache.http.ConnectionClosedException
 */
public class ConnectionException extends TransportProtocolException {

    private static final long serialVersionUID = -3021031199739951875L;

    public ConnectionException() {
        super();
    }

    public ConnectionException(String message) {
        super(message);
    }

    public ConnectionException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConnectionException(Throwable cause) {
        super(cause);
    }
}