/* **********************************************************
 * Copyright 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.client.util;

import com.vmware.vapi.security.AuthenticationFilter;

/**
 * Exception raised when acquiring authentication token from the configured in
 * the {@link AuthenticationFilter} {@link java.util.function.Supplier} fails.
 * <p>
 * This is error in the client code. Look at the enclosed exception for more
 * details.
 */
public class SecurityContextAcquisitionError extends RuntimeException {
    private static final long serialVersionUID = 325823017210976460L;

    public SecurityContextAcquisitionError(String message) {
        super(message);
    }

    public SecurityContextAcquisitionError(String message, Throwable cause) {
        super(message, cause);
    }
}
