/*
 * **********************************************************************
 * Copyright 2015 VMware, Inc. All rights reserved. VMware Confidential
 * **********************************************************************
 */

package com.vmware.vapi.config;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Utility class containing a helper method for merging multiple maps.
 */
public class MapHelper {

    private static <E> List<E> reversedView(final E[] a) {
        return new AbstractList<E>() {
            public E get(int index) {
                return a[a.length - index - 1];
            }

            public int size() {
                return a.length;
            }
        };
    }

    /**
     * Return a new map contain the mappings from all the maps.
     * In case of collisions, mappings from later maps are ignored.
     */
    public <K, V> Map<K, V> mergeMaps(Map<K, V>... maps) {
        Map<K, V> result = new HashMap<K, V>();
        if (maps != null) {
            for (Map<K, V> map : reversedView(maps)) {
                result.putAll(map);
            }
        }
        return result;
    }
}
