/* **********************************************************
 * Copyright 2012-2013, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.core;

import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.util.Validate;

/**
 * Utility which decorates an existing provider. Use as a base class and
 * override just the methods you need to save some boilerplate.
 */
public abstract class DecoratorApiProvider implements ApiProvider {

    protected final ApiProvider decoratedProvider;

    /**
     * Creates <code>ApiProvider</code> Decorator.
     *
     * @param decoratedProvider provider to be decorated; must not be
     *                          <code>null</code>
     */
    public DecoratorApiProvider(ApiProvider decoratedProvider) {
        Validate.notNull(decoratedProvider);
        this.decoratedProvider = decoratedProvider;
    }

    @Override
    public void invoke(String serviceId,
                       String operationId,
                       DataValue input,
                       ExecutionContext ctx,
                       AsyncHandle<MethodResult> asyncHandle) {

        decoratedProvider.invoke(serviceId, operationId, input, ctx, asyncHandle);
    }
}
