/* **********************************************************
 * Copyright (c) 2018 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.core;

/**
 * Accessor of the raw HTTP response for REST API invocations.
 *
 * <p>Implementations can access and store the raw HTTP response or
 * pieces of it for later usage.
 *
 * <p>This mechanism is only applicable if REST transport is used
 * by the client to access the API.
 */
public interface HttpResponseAccessor {

    /**
     * Processes the raw HTTP response.
     *
     * <p>If the implementation of this method throws a {@code RuntimeException}
     * it will be logged and ignored, i.e. it cannot fail the response
     * processing.
     *
     * @param response representing the raw REST/HTTP response
     */
    void access(HttpResponse response);
}