/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.data;

import java.io.Serializable;
import java.util.ConcurrentModificationException;

public interface DataValue extends Serializable {
    public DataType getType();

    public void accept(ValueVisitor visitor);

    /**
     * @return a deep copy of this data value instance. this operation is NOT
     *         thread-safe and might throw {@link ConcurrentModificationException}
     *         if the DataValue is modified at the time of coping.
     */
    public DataValue copy();
}
