/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * DataValueOpaqueConverter.java --
 *
 *      Convert opaque type to the underlying data value
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert opaque type to the underlying data value.
 */
public final class DataValueOpaqueConverter implements
        PrimitiveConverter<DataValue> {

    @Override
    public DataValue fromValue(DataValue value) {
        return value;
    }

    @Override
    public DataValue toValue(Object primitiveBinding) {
        return ConvertUtil.narrowType(primitiveBinding, DataValue.class);
    }

}
